/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.config.serverbeans.TransactionService;
import com.iplanet.ias.jms.IASJmsUtil;
import com.iplanet.ias.loader.EJBClassLoader;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.transaction.XAResourceWrapper;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import com.sun.enterprise.repository.ConnectorResource;
import com.sun.enterprise.repository.CustomResource;
import com.sun.enterprise.repository.ExternalJndiResource;
import com.sun.enterprise.repository.IASJdbcResource;
import com.sun.enterprise.repository.IASJdbcXAResource;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceBase;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.repository.JdbcConnectionPool;
import com.sun.enterprise.repository.JdbcResource;
import com.sun.enterprise.repository.JdbcXAResource;
import com.sun.enterprise.repository.MailResource;
import com.sun.enterprise.repository.PMFResource;
import com.sun.enterprise.repository.ResourceAdapter;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import com.sun.enterprise.resource.ConfigurationPropertyException;
import com.sun.enterprise.resource.ConnectorInfo;
import com.sun.enterprise.resource.DuplicateNameException;
import com.sun.enterprise.resource.JdbcDataSource;
import com.sun.enterprise.resource.JndiProxyObjectFactory;
import com.sun.enterprise.resource.NameNotFoundException;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ProxyRefAddr;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.SystemJdbcDataSource;
import com.sun.enterprise.tools.deployment.backend.JarRepository;
import com.sun.enterprise.util.ConnectorClassLoader;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jms.spi.xa.JMSXAConnection;
import com.sun.jms.spi.xa.JMSXAConnectionFactory;
import com.sun.jms.spi.xa.JMSXAQueueConnection;
import com.sun.jms.spi.xa.JMSXAQueueConnectionFactory;
import com.sun.jms.spi.xa.JMSXATopicConnection;
import com.sun.jms.spi.xa.JMSXATopicConnectionFactory;
import com.sun.logging.LogDomains;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public class ResourceInstaller {
    public static final String CONNECTOR_ADAPTER_DIR = "connector" + File.separator + "adapters";
    public static final String CONNECTOR_PROPS = "connector" + File.separator + "connector.properties";
    private static final String XA_JNDI_EXTENSION = "__xa";
    private static final String PM_JNDI_EXTENSION = "__pm";
    private static final String OBSOLETE_JDBC_DRIVER_PROP = "jdbc.drivers";
    private static final String OBSOLETE_JDBC10_PROP = "jdbc.datasources";
    private static final String OBSOLETE_JDBC20_PROP = "jdbc20.datasources";
    private static final String SET_ = "set";
    private static final String SET_CONNECTION_FACTORY = "setConnectionFactory";
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$resource$ResourceInstaller == null ? (class$com$sun$enterprise$resource$ResourceInstaller = ResourceInstaller.class$("com.sun.enterprise.resource.ResourceInstaller")) : class$com$sun$enterprise$resource$ResourceInstaller);
    private Hashtable connectorDescriptors = new Hashtable();
    private J2EEResourceFactory resFactory;
    private J2EEResourceCollection resourceInfo;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    static /* synthetic */ Class class$com$sun$enterprise$resource$ResourceInstaller;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public ResourceInstaller() {
        try {
            this.resFactory = ServerConfiguration.getJ2EEResourceFactory();
            this.resourceInfo = this.resFactory.loadDefaultResourceCollection();
        }
        catch (J2EEResourceException j2EEResourceException) {
            _logger.log(Level.SEVERE, "J2EE.cannot_load_resources", j2EEResourceException);
        }
    }

    public void recoverXAResources() {
        try {
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            Vector vector4 = new Vector();
            Context context = Switch.getSwitch().getNamingManager().getInitialContext();
            this.recoverJdbcXAResources(context, vector, vector2);
            this.recoverJMSResourceJMSXAResources(context, vector, vector3);
            this.recoverExternalJndiResourceJMSXAResources(context, vector, vector3);
            this.recoverConnectorXAResources(context, vector, vector4);
            int n = vector.size();
            XAResource[] xAResourceArray = new XAResource[n];
            int n2 = 0;
            while (n2 < n) {
                xAResourceArray[n2] = (XAResource)vector.elementAt(n2);
                ++n2;
            }
            J2EETransactionManager j2EETransactionManager = Switch.getSwitch().getTransactionManager();
            String string = localStrings.getLocalString("xaresource.recovering", "Recovering {0} XA resources...", new Object[]{String.valueOf(n)});
            _logger.log(Level.FINE, string);
            j2EETransactionManager.recover(xAResourceArray);
            this.closeJdbcXAResources(vector2);
            this.closeJMSXAResources(vector3);
            this.closeConnectorXAResources(vector4);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "xaresource.recover_error", exception);
        }
    }

    private void recoverJdbcXAResources(Context context, Vector vector, Vector vector2) {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        Set set = this.resourceInfo.getResourcesByType(4);
        String string = null;
        Properties properties = new Properties();
        try {
            object4 = ApplicationServer.getServerContext().getConfigContext();
            serializable = ServerBeansFactory.getServerBean((ConfigContext)object4).getTransactionService();
            object3 = ((TransactionService)serializable).getElementProperty();
            int n = 0;
            while (n < ((ElementProperty[])object3).length) {
                object2 = object3[n].getName();
                object = object3[n].getValue();
                if (((String)object2).equals("oracle-xa-recovery-workaround")) {
                    if (((String)object).equals("true")) {
                        properties.put("oracle.jdbc.xa.client.OracleXAResource", "com.iplanet.ias.transaction.OracleXAResource");
                    }
                } else if (((String)object2).equals("sybase-xa-recovery-workaround") && ((String)object).equals("true")) {
                    properties.put("com.sybase.jdbc2.jdbc.SybXAResource11", "com.iplanet.ias.transaction.SybaseXAResource");
                    properties.put("com.sybase.jdbc2.jdbc.SybXAResource", "com.iplanet.ias.transaction.SybaseXAResource");
                }
                ++n;
            }
        }
        catch (ConfigException configException) {
            _logger.log(Level.INFO, "jdbc.config_error", configException);
        }
        object4 = set.iterator();
        while (object4.hasNext()) {
            serializable = (JdbcXAResource)object4.next();
            try {
                string = ((J2EEResourceBase)serializable).getName();
                object3 = (JdbcDataSource)context.lookup(string);
                String string2 = ((JdbcDataSource)object3).getDataSourceName();
                object2 = (JdbcConnectionPool)context.lookup(string2);
                object = (XADataSource)((JdbcConnectionPool)object2).createDataSource();
                XAConnection xAConnection = object.getXAConnection();
                vector2.addElement(xAConnection);
                XAResource xAResource = xAConnection.getXAResource();
                String string3 = xAResource.getClass().getName();
                String string4 = (String)properties.get(string3);
                if (string4 != null) {
                    XAResourceWrapper xAResourceWrapper = null;
                    xAResourceWrapper = (XAResourceWrapper)Class.forName(string4).newInstance();
                    xAResourceWrapper.init(xAConnection);
                    vector.addElement(xAResourceWrapper);
                    continue;
                }
                vector.addElement(xAResource);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "datasource.xadatasource_error", string);
                _logger.log(Level.SEVERE, "datasource.xadatasource_error_excp", exception);
            }
        }
    }

    private void recoverExternalJndiResourceJMSXAResources(Context context, Vector vector, Vector vector2) {
        Set set = this.resourceInfo.getResourcesByType(10);
        this.recoverJMSXAResources(context, vector, vector2, set);
    }

    private void recoverJMSResourceJMSXAResources(Context context, Vector vector, Vector vector2) {
        JMSXAConnectionFactory jMSXAConnectionFactory;
        Set set = this.resourceInfo.getResourcesByType(2);
        this.recoverJMSXAResources(context, vector, vector2, set);
        String string = null;
        try {
            string = "MDB_CONTAINER_QUEUE_CF__jmsxa_default";
            jMSXAConnectionFactory = (JMSXAConnectionFactory)context.lookup(string);
            this.recoverJMSXAResource(vector, vector2, jMSXAConnectionFactory, true);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "datasource.xadatasource_error", string);
            _logger.log(Level.SEVERE, "datasource.xadatasource_error_excp", exception);
        }
        try {
            string = "MDB_CONTAINER_TOPIC_CF__jmsxa_default";
            jMSXAConnectionFactory = (JMSXAConnectionFactory)context.lookup(string);
            this.recoverJMSXAResource(vector, vector2, jMSXAConnectionFactory, false);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "datasource.xadatasource_error", string);
            _logger.log(Level.SEVERE, "datasource.xadatasource_error_excp", exception);
        }
    }

    private void recoverJMSXAResources(Context context, Vector vector, Vector vector2, Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            J2EEResource j2EEResource = (J2EEResource)iterator.next();
            if (j2EEResource instanceof ExternalJndiResource && !((ExternalJndiResource)j2EEResource).isJMSConnectionFactory()) continue;
            String string = j2EEResource.getName();
            try {
                boolean bl;
                JMSXAConnectionFactory jMSXAConnectionFactory;
                if (j2EEResource instanceof ExternalJndiResource) {
                    Object object = context.lookup(string);
                    if (!(object instanceof ConnectionFactory)) {
                        throw new NamingException(localStrings.getLocalString("recovery.unexpected_objtype", "Unexpected object type " + object.getClass().getName() + " for " + string, new Object[]{object.getClass().getName(), string}));
                    }
                    jMSXAConnectionFactory = (JMSXAConnectionFactory)IASJmsUtil.wrapJMSConnectionFactoryObject(object);
                    bl = object instanceof QueueConnectionFactory;
                } else {
                    jMSXAConnectionFactory = (JMSXAConnectionFactory)context.lookup(IASJmsUtil.getXAConnectionFactoryName(string));
                    bl = jMSXAConnectionFactory instanceof JMSXAQueueConnectionFactory;
                }
                this.recoverJMSXAResource(vector, vector2, jMSXAConnectionFactory, bl);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "datasource.xadatasource_error", string);
                _logger.log(Level.SEVERE, "datasource.xadatasource_error_excp", exception);
            }
        }
    }

    private void recoverJMSXAResource(Vector vector, Vector vector2, JMSXAConnectionFactory jMSXAConnectionFactory, boolean bl) throws Exception {
        if (bl) {
            JMSXAQueueConnectionFactory jMSXAQueueConnectionFactory = (JMSXAQueueConnectionFactory)jMSXAConnectionFactory;
            JMSXAQueueConnection jMSXAQueueConnection = jMSXAQueueConnectionFactory.createXAQueueConnection();
            vector2.addElement(jMSXAQueueConnection);
            XAResource xAResource = jMSXAQueueConnection.createXAQueueSession(true, 1).getXAResource();
            vector.addElement(xAResource);
        } else {
            JMSXATopicConnectionFactory jMSXATopicConnectionFactory = (JMSXATopicConnectionFactory)jMSXAConnectionFactory;
            JMSXATopicConnection jMSXATopicConnection = jMSXATopicConnectionFactory.createXATopicConnection();
            vector2.addElement(jMSXATopicConnection);
            XAResource xAResource = jMSXATopicConnection.createXATopicSession(true, 1).getXAResource();
            vector.addElement(xAResource);
        }
    }

    private void recoverConnectorXAResources(Context context, Vector vector, Vector vector2) {
        Set set = this.resourceInfo.getResourcesByType(6);
        String string = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ConnectorResource connectorResource = (ConnectorResource)iterator.next();
            try {
                String string2;
                string = connectorResource.getName();
                String string3 = connectorResource.getDbuser();
                String string4 = connectorResource.getDbpassword();
                String string5 = connectorResource.getApplicationName();
                EJBClassLoader eJBClassLoader = null;
                if (string5 == null || string5.equals("")) {
                    eJBClassLoader = ConnectorClassLoader.getInstance();
                } else {
                    string2 = JarRepository.getServerJarFilename(string5);
                    eJBClassLoader = new JarClassLoader();
                    ((JarClassLoader)eJBClassLoader).addJar(string2);
                }
                string2 = connectorResource.createManagedConnectionFactory(eJBClassLoader);
                Subject subject = new Subject();
                PasswordCredential passwordCredential = new PasswordCredential(string3, string4.toCharArray());
                passwordCredential.setManagedConnectionFactory((ManagedConnectionFactory)string2);
                ResourcePrincipal resourcePrincipal = new ResourcePrincipal(string3, string4);
                subject.getPrincipals().add(resourcePrincipal);
                subject.getPrivateCredentials().add(passwordCredential);
                ManagedConnection managedConnection = string2.createManagedConnection(subject, null);
                try {
                    XAResource xAResource = managedConnection.getXAResource();
                    if (xAResource == null) continue;
                    vector2.addElement(managedConnection);
                    vector.addElement(xAResource);
                }
                catch (ResourceException resourceException) {}
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "datasource.xadatasource_error", string);
                _logger.log(Level.SEVERE, "datasource.xadatasource_error_excp", exception);
            }
        }
    }

    private void closeJdbcXAResources(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                XAConnection xAConnection = (XAConnection)vector.elementAt(n2);
                xAConnection.close();
            }
            catch (SQLException sQLException) {
                _logger.log(Level.FINE, "JDBC Resources cannot be closed", sQLException);
            }
            ++n2;
        }
    }

    private void closeJMSXAResources(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                Object e = vector.elementAt(n2);
                ((JMSXAConnection)e).close();
            }
            catch (JMSException jMSException) {
                _logger.log(Level.FINE, "JMS Resources cannot be closed", jMSException);
            }
            ++n2;
        }
    }

    private void closeConnectorXAResources(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                Object e = vector.elementAt(n2);
                ((ManagedConnection)e).destroy();
            }
            catch (ResourceException resourceException) {
                _logger.log(Level.FINE, "Connector Resources cannot be closed", resourceException);
            }
            ++n2;
        }
    }

    public void installJdbcDataSources() {
        this.checkObsoleteJdbcConfig(OBSOLETE_JDBC_DRIVER_PROP);
        this.checkObsoleteJdbcConfig(OBSOLETE_JDBC10_PROP);
        this.checkObsoleteJdbcConfig(OBSOLETE_JDBC20_PROP);
        _logger.log(Level.INFO, "jdbc.install_resources");
        this.installJDBCConnectionPoolResources();
        this.installJdbc10DataSources();
        this.installJdbcXADataSources();
    }

    private void checkObsoleteJdbcConfig(String string) {
        ServerConfiguration serverConfiguration = ServerConfiguration.getConfiguration();
        String string2 = serverConfiguration.getProperty(string);
        if (string2 != null) {
            _logger.log(Level.WARNING, "jdbc.obsolete_config", new Object[]{string, string2});
        }
    }

    private static String getXAJndiName(String string) {
        return string + XA_JNDI_EXTENSION;
    }

    public static String getPMJndiName(String string) {
        return string + PM_JNDI_EXTENSION;
    }

    private void installJDBCConnectionPoolResources() {
        Set set = this.resourceInfo.getResourcesByType(8);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            JdbcConnectionPool jdbcConnectionPool = (JdbcConnectionPool)iterator.next();
            this.installJDBCConnectionPoolResource(jdbcConnectionPool);
        }
    }

    public void installJDBCConnectionPoolResource(JdbcConnectionPool jdbcConnectionPool) {
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        String string = jdbcConnectionPool.getName();
        try {
            namingManager.publishObject(string, (Object)jdbcConnectionPool, true);
        }
        catch (NamingException namingException) {
            _logger.log(Level.SEVERE, "jdbc.publish_error", namingException);
        }
    }

    public void installJdbc10DataSource(JdbcResource jdbcResource) {
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        int n = 1;
        String string = null;
        try {
            String string2;
            string = string2 = jdbcResource.getName();
            IASJdbcResource iASJdbcResource = (IASJdbcResource)jdbcResource;
            String string3 = iASJdbcResource.getJdbcConnectionPool().getName();
            JdbcDataSource jdbcDataSource = new JdbcDataSource();
            jdbcDataSource.setDataSourceName(string3);
            jdbcDataSource.setJndiName(string2);
            jdbcDataSource.setJdbcMajorVersion(n);
            jdbcDataSource.setUserName(iASJdbcResource.getUserName());
            jdbcDataSource.setPassword(iASJdbcResource.getPassword());
            namingManager.publishObject(string, (Object)jdbcDataSource, true);
            Object[] objectArray = new Object[]{string2, string3};
            _logger.log(Level.INFO, "jdbc.binding", objectArray);
            SystemJdbcDataSource systemJdbcDataSource = new SystemJdbcDataSource();
            systemJdbcDataSource.setDataSourceName(string3);
            string = ResourceInstaller.getPMJndiName(string2);
            systemJdbcDataSource.setJndiName(string);
            systemJdbcDataSource.setJdbcMajorVersion(n);
            systemJdbcDataSource.setDescription("J2EE internal use only");
            systemJdbcDataSource.setUserName(iASJdbcResource.getUserName());
            systemJdbcDataSource.setPassword(iASJdbcResource.getPassword());
            namingManager.publishObject(string, (Object)systemJdbcDataSource, true);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "poolmgr.datasource_error", string);
            _logger.log(Level.SEVERE, "poolmgr.datasource_error_excp", exception);
        }
    }

    private void installJdbc10DataSources() {
        Set set = this.resourceInfo.getResourcesByType(3);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            JdbcResource jdbcResource = (JdbcResource)iterator.next();
            if (!jdbcResource.isEnabled()) {
                _logger.log(Level.WARNING, localStrings.getLocalString("datasource.disabled", "", new Object[]{jdbcResource.getName()}));
                continue;
            }
            this.installJdbc10DataSource(jdbcResource);
        }
    }

    public void installJdbcXADataSource(JdbcXAResource jdbcXAResource) {
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        int n = 2;
        String string = null;
        try {
            String string2;
            string = string2 = jdbcXAResource.getName();
            IASJdbcXAResource iASJdbcXAResource = (IASJdbcXAResource)jdbcXAResource;
            String string3 = iASJdbcXAResource.getJdbcConnectionPool().getName();
            JdbcDataSource jdbcDataSource = new JdbcDataSource();
            jdbcDataSource.setDataSourceName(string3);
            jdbcDataSource.setJndiName(string2);
            jdbcDataSource.setJdbcMajorVersion(n);
            jdbcDataSource.setUserName(iASJdbcXAResource.getUserName());
            jdbcDataSource.setPassword(iASJdbcXAResource.getPassword());
            _logger.log(Level.FINE, localStrings.getLocalString("binding.datasource", "", new Object[]{string2, string3}));
            namingManager.publishObject(string, (Object)jdbcDataSource, true);
            Object[] objectArray = new Object[]{string2, string3};
            _logger.log(Level.INFO, "jdbc.binding", objectArray);
            string = ResourceInstaller.getPMJndiName(string2);
            SystemJdbcDataSource systemJdbcDataSource = new SystemJdbcDataSource();
            systemJdbcDataSource.setDataSourceName(string3);
            systemJdbcDataSource.setJndiName(string);
            systemJdbcDataSource.setJdbcMajorVersion(n);
            systemJdbcDataSource.setDescription("J2EE internal use only");
            systemJdbcDataSource.setUserName(iASJdbcXAResource.getUserName());
            systemJdbcDataSource.setPassword(iASJdbcXAResource.getPassword());
            namingManager.publishObject(string, (Object)systemJdbcDataSource, true);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "poolmgr.datasource_error", string);
            _logger.log(Level.SEVERE, "poolmgr.datasource_error_excp", exception);
        }
    }

    private void installJdbcXADataSources() {
        Set set = this.resourceInfo.getResourcesByType(4);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            JdbcXAResource jdbcXAResource = (JdbcXAResource)iterator.next();
            if (!jdbcXAResource.isEnabled()) {
                _logger.log(Level.WARNING, localStrings.getLocalString("datasource.disabled", "", new Object[]{jdbcXAResource.getName()}));
                continue;
            }
            this.installJdbcXADataSource(jdbcXAResource);
        }
    }

    public JdbcConnectionPool lookupJdbcConnectionPool(String string) {
        J2EEResource j2EEResource = this.resourceInfo.getResourceByName(8, string);
        return j2EEResource == null ? null : (JdbcConnectionPool)j2EEResource;
    }

    public J2EEResource lookupJdbcResource(String string) {
        J2EEResource j2EEResource = this.resourceInfo.getResourceByName(4, string);
        if (j2EEResource == null) {
            j2EEResource = this.resourceInfo.getResourceByName(3, string);
        }
        return j2EEResource;
    }

    public void installPersistenceManagerResources() {
        Set set = this.resourceInfo.getResourcesByType(9);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            PMFResource pMFResource = (PMFResource)iterator.next();
            this.installPersistenceManagerResource(pMFResource);
        }
    }

    public void installPersistenceManagerResource(PMFResource pMFResource) {
        String string = null;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            string = pMFResource.getName();
            String string2 = pMFResource.getFactoryClass();
            Class<?> clazz = Class.forName(string2);
            Object obj = clazz.newInstance();
            String string3 = pMFResource.getJdbcResourceJndiName();
            if (string3 != null && string3.length() > 0) {
                object4 = ResourceInstaller.getPMJndiName(string3);
                object3 = null;
                try {
                    object2 = new InitialContext();
                    object3 = (DataSource)object2.lookup((String)object4);
                    object = clazz.getMethod(SET_CONNECTION_FACTORY, class$java$lang$Object == null ? (class$java$lang$Object = ResourceInstaller.class$("java.lang.Object")) : class$java$lang$Object);
                    ((Method)object).invoke(obj, object3);
                }
                catch (Exception exception) {
                    _logger.log(Level.INFO, "jndi.persistence_manager_config", object4);
                    _logger.log(Level.INFO, "jndi.persistence_manager_config_excp", exception);
                }
            }
            object4 = pMFResource.getProperties();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (ResourceProperty)object3.next();
                object = object2.getName();
                String string4 = (String)object2.getValue();
                String string5 = SET_ + ((String)object).substring(0, 1).toUpperCase() + ((String)object).substring(1);
                Method method = clazz.getMethod(string5, class$java$lang$String == null ? ResourceInstaller.class$("java.lang.String") : class$java$lang$String);
                method.invoke(obj, string4);
            }
            object2 = Switch.getSwitch().getNamingManager();
            object2.publishObject(string, obj, true);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "poolmgr.datasource_error", string);
            _logger.log(Level.SEVERE, "poolmgr.datasource_error_excp", exception);
        }
    }

    public void installCustomResource(CustomResource customResource) {
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        String string = null;
        try {
            string = customResource.getName();
            Reference reference = new Reference(customResource.getResType(), customResource.getFactoryClass(), null);
            Iterator iterator = customResource.getProperties().iterator();
            while (iterator.hasNext()) {
                ResourceProperty resourceProperty = (ResourceProperty)iterator.next();
                reference.add(new StringRefAddr(resourceProperty.getName(), (String)resourceProperty.getValue()));
            }
            namingManager.publishObject(string, (Object)reference, true);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error", string);
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error_excp", exception);
        }
    }

    public void installCustomResources() {
        Set set = this.resourceInfo.getResourcesByType(11);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            CustomResource customResource = (CustomResource)iterator.next();
            this.installCustomResource(customResource);
        }
    }

    public static Object loadObject(String string) {
        Object var1_1 = null;
        try {
            var1_1 = Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string);
                var1_1 = clazz.newInstance();
            }
            catch (Exception exception2) {
                _logger.log(Level.SEVERE, "classloader.load_class_fail", string);
                _logger.log(Level.SEVERE, "classloader.load_class_fail_excp", exception2.getMessage());
            }
        }
        return var1_1;
    }

    public void installExternalJndiResource(ExternalJndiResource externalJndiResource) {
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        String string = null;
        try {
            Object object;
            string = externalJndiResource.getName();
            String string2 = externalJndiResource.getFactoryClass();
            String string3 = externalJndiResource.getJndiLookupName();
            Object object2 = ResourceInstaller.loadObject(string2);
            if (object2 == null) {
                _logger.log(Level.WARNING, "jndi.factory_load_error", string2);
                return;
            }
            if (!(object2 instanceof InitialContextFactory)) {
                _logger.log(Level.WARNING, "jndi.factory_class_unexpected", string2);
                return;
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            Iterator iterator = externalJndiResource.getProperties().iterator();
            while (iterator.hasNext()) {
                object = (ResourceProperty)iterator.next();
                hashtable.put(object.getName(), object.getValue());
            }
            object = null;
            try {
                object = ((InitialContextFactory)object2).getInitialContext(hashtable);
            }
            catch (NamingException namingException) {
                _logger.log(Level.SEVERE, "jndi.initial_context_error", string2);
                _logger.log(Level.SEVERE, "jndi.initial_context_error_excp", namingException.getMessage());
            }
            if (object == null) {
                _logger.log(Level.SEVERE, "jndi.factory_create_error", string2);
                return;
            }
            Reference reference = new Reference(externalJndiResource.getResType(), "com.sun.enterprise.resource.JndiProxyObjectFactory", null);
            reference.add(new StringRefAddr("jndiName", string));
            reference.add(new StringRefAddr("jndiLookupName", string3));
            reference.add(new StringRefAddr("jndiFactoryClass", string2));
            reference.add(new ProxyRefAddr(string, hashtable));
            namingManager.publishObject(string, (Object)reference, true);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error", string);
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error_excp", exception);
        }
    }

    public void installExternalJndiResources() {
        Set set = this.resourceInfo.getResourcesByType(10);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ExternalJndiResource externalJndiResource = (ExternalJndiResource)iterator.next();
            this.installExternalJndiResource(externalJndiResource);
        }
    }

    public void uninstallExternalJndiResource(J2EEResource j2EEResource) {
        this.resourceInfo.removeResource(j2EEResource);
        JndiProxyObjectFactory.removeInitialContext(j2EEResource.getName());
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        try {
            namingManager.unpublishObject(j2EEResource.getName());
            if (((ExternalJndiResource)j2EEResource).isJMSConnectionFactory()) {
                namingManager.unpublishObject(IASJmsUtil.getXAConnectionFactoryName(j2EEResource.getName()));
            }
        }
        catch (NamingException namingException) {
            _logger.log(Level.FINE, "Error while unpublishing resource: " + j2EEResource.getName(), namingException);
        }
    }

    public void uninstallJdbcResource(J2EEResource j2EEResource) {
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        try {
            String string = j2EEResource.getName();
            String string2 = ResourceInstaller.getPMJndiName(string);
            namingManager.unpublishObject(string);
            namingManager.unpublishObject(string2);
        }
        catch (NamingException namingException) {
            _logger.log(Level.FINE, "Error while unpublishing resource: " + j2EEResource.getName(), namingException);
        }
        this.resourceInfo.removeResource(j2EEResource);
    }

    public void installMailResource(MailResource mailResource) {
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        String string = null;
        try {
            string = mailResource.getName();
            MailConfiguration mailConfiguration = new MailConfiguration(mailResource);
            namingManager.publishObject(string, (Object)mailConfiguration, true);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "mailrsrc.create_obj_error", string);
            _logger.log(Level.SEVERE, "mailrsrc.create_obj_error_excp", exception);
        }
    }

    public void installMailResources() {
        Set set = this.resourceInfo.getResourcesByType(12);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            MailResource mailResource = (MailResource)iterator.next();
            this.installMailResource(mailResource);
        }
    }

    public void installJMSResources() throws Exception {
        IASJmsUtil.installJMSResources(this.resourceInfo);
    }

    public void installResourceAdapters() {
    }

    public void installResourceAdapter(byte[] byArray, String string) throws PoolingException {
        try {
            J2EEResource j2EEResource = this.resourceInfo.getResourceByName(7, string);
            if (j2EEResource != null) {
                throw new DuplicateNameException(string);
            }
            File file = new File(FileUtil.getAbsolutePath(CONNECTOR_ADAPTER_DIR));
            File file2 = File.createTempFile("rar", "temp-rar", file);
            file2.deleteOnExit();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            bufferedOutputStream.write(byArray, 0, byArray.length);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            JarFile jarFile = new JarFile(file2);
            JarEntry jarEntry = jarFile.getJarEntry(ConnectorArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY);
            if (jarEntry == null) {
                throw new PoolingException("Cannot find ra.xml file");
            }
            Archivist.validate(jarFile.getInputStream(jarEntry));
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            ConnectorNode connectorNode = ConnectorNode.read(inputStream, false);
            ConnectorDescriptor connectorDescriptor = connectorNode.getDescriptor();
            this.registerConnectorDescriptor(connectorDescriptor, null, string);
            inputStream.close();
            File file3 = new File(FileUtil.getAbsolutePath(CONNECTOR_ADAPTER_DIR + File.separator + string));
            JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(file3)));
            ApplicationArchivist.expandRarFile(jarFile, jarOutputStream);
            inputStream = jarFile.getInputStream(jarEntry);
            jarOutputStream.putNextEntry(new JarEntry(jarEntry));
            ApplicationArchivist.copy(inputStream, jarOutputStream);
            jarOutputStream.flush();
            jarOutputStream.close();
            inputStream.close();
            jarFile.close();
            file2.delete();
            ResourceAdapter resourceAdapter = new ResourceAdapter(string);
            this.resourceInfo = this.resFactory.loadDefaultResourceCollection();
            this.resourceInfo.addResource(resourceAdapter);
            this.resFactory.storeDefaultResourceCollection(this.resourceInfo);
            ConnectorClassLoader.getInstance().addResourceAdapter(string);
        }
        catch (PoolingException poolingException) {
            _logger.log(Level.SEVERE, "poolmgr.resource_adapter_error", poolingException);
            throw poolingException;
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "poolmgr.resource_adapter_error", exception);
            throw new PoolingException(localStrings.getLocalString("poolmgr.resourceadaptererror", "Error in installing resource adapters: {0}", new Object[]{exception.getLocalizedMessage()}));
        }
    }

    public void uninstallResourceAdapter(String string) throws PoolingException {
        try {
            ResourceAdapter resourceAdapter = (ResourceAdapter)this.resourceInfo.getResourceByName(7, string);
            if (resourceAdapter == null) {
                throw new NameNotFoundException(string);
            }
            this.forceResourcePoolCleanup(null, string);
            this.unregisterConnectorDescriptor(null, string);
            this.resourceInfo = this.resFactory.loadDefaultResourceCollection();
            this.resourceInfo.removeResource(resourceAdapter);
            this.resFactory.storeDefaultResourceCollection(this.resourceInfo);
            File file = new File(FileUtil.getAbsolutePath(CONNECTOR_ADAPTER_DIR + File.separator + string));
            file.delete();
        }
        catch (J2EEResourceException j2EEResourceException) {
            _logger.log(Level.WARNING, "poolmgr.config_access_error", j2EEResourceException);
            throw new PoolingException("Error accessing configuration file: " + j2EEResourceException);
        }
    }

    private String[] getAllConnectionFactories() {
        Set set = this.resourceInfo.getResourcesByType(6);
        int n = set.size();
        String[] stringArray = new String[n];
        Iterator iterator = set.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray[n2++] = ((J2EEResource)iterator.next()).getName();
        }
        return stringArray;
    }

    private String[] getAllConnectors() {
        Serializable serializable;
        Set set = this.resourceInfo.getResourcesByType(7);
        int n = set.size();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            serializable = (ResourceAdapter)iterator.next();
            arrayList.add(((J2EEResourceBase)serializable).getName());
        }
        serializable = JarRepository.getApplicationList();
        Enumeration enumeration = ((Vector)serializable).elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.findEmbeddedAdapters(string, arrayList);
        }
        int n2 = arrayList.size();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = (String)arrayList.get(n3);
            ++n3;
        }
        return stringArray;
    }

    private void findEmbeddedAdapters(String string, List list) {
        String string2 = JarRepository.getJarFilename(string);
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(new File(string2));
        }
        catch (IOException iOException) {
            _logger.log(Level.SEVERE, "rsrc.file_create_error", iOException);
            return;
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string3 = zipEntry.getName();
            if (!string3.endsWith(".rar")) continue;
            list.add(this.getFullConnectorName(string, string3));
        }
    }

    public ConnectorInfo listResourceAdapters() throws PoolingException {
        ConnectorInfo connectorInfo = new ConnectorInfo();
        connectorInfo.connectors = this.getAllConnectors();
        connectorInfo.connectionFactories = this.getAllConnectionFactories();
        return connectorInfo;
    }

    public Set listConnectorResources() {
        Set set = this.resourceInfo.getResourcesByType(6);
        return set;
    }

    public void installConnectionFactories() throws PoolingException {
    }

    public void addConnectionFactory(String string, String string2, String string3, String string4, String string5, Properties properties) throws PoolingException {
        Object object;
        Object object2;
        Object object3;
        ConnectorDescriptor connectorDescriptor;
        if (properties == null) {
            properties = new Properties();
        }
        if ((connectorDescriptor = this.getDescriptorByConnectorName(string, string2)) == null) {
            throw new NameNotFoundException(this.getFullConnectorName(string, string2));
        }
        ConnectorResource connectorResource = (ConnectorResource)this.resourceInfo.getResourceByName(6, string3);
        if (connectorResource != null) {
            throw new DuplicateNameException(string3);
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = connectorDescriptor.getConfigProperties().iterator();
        while (iterator.hasNext()) {
            object3 = (EnvironmentProperty)iterator.next();
            hashSet.add(((Descriptor)object3).getName());
        }
        object3 = properties.keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            if (hashSet.contains(object2)) continue;
            throw new ConfigurationPropertyException((String)object2);
        }
        connectorResource = new ConnectorResource(string3);
        connectorResource.setApplicationName(string);
        connectorResource.setConnectorName(string2);
        connectorResource.setDbuser(string4);
        connectorResource.setDbpassword(string5);
        connectorResource.setConnectionFactoryClass(connectorDescriptor.getConnectionFactoryImpl());
        iterator = connectorDescriptor.getConfigProperties().iterator();
        while (iterator.hasNext()) {
            object2 = (EnvironmentProperty)iterator.next();
            object = ((Descriptor)object2).getName();
            String string6 = properties.getProperty((String)object);
            if (string6 == null) {
                string6 = ((EnvironmentProperty)object2).getValue();
            }
            ResourcePropertyImpl resourcePropertyImpl = new ResourcePropertyImpl((String)object, string6);
            connectorResource.addProperty(resourcePropertyImpl);
        }
        try {
            object2 = connectorResource.createConnectionFactoryReference();
            object = Switch.getSwitch().getNamingManager();
            object.publishObject(string3, object2, true);
            this.resourceInfo = this.resFactory.loadDefaultResourceCollection();
            this.resourceInfo.addResource(connectorResource);
            this.resFactory.storeDefaultResourceCollection(this.resourceInfo);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "jndi.bind_error", exception);
            throw new PoolingException(exception.toString());
        }
    }

    public void removeConnectionFactory(String string) throws PoolingException {
        try {
            ConnectorResource connectorResource = (ConnectorResource)this.resourceInfo.getResourceByName(6, string);
            if (connectorResource == null) {
                throw new NameNotFoundException(string);
            }
            NamingManager namingManager = Switch.getSwitch().getNamingManager();
            Context context = namingManager.getInitialContext();
            context.unbind(string);
            this.resourceInfo = this.resFactory.loadDefaultResourceCollection();
            this.resourceInfo.removeResource(connectorResource);
            this.resFactory.storeDefaultResourceCollection(this.resourceInfo);
        }
        catch (Exception exception) {
            if (exception instanceof PoolingException) {
                throw (PoolingException)exception;
            }
            _logger.log(Level.WARNING, "jndi.remove_connection_factory_error", exception);
            throw new PoolingException(exception.toString());
        }
    }

    public void registerConnectorDescriptor(ConnectorDescriptor connectorDescriptor, String string, String string2) {
        if (string != null) {
            ResourceInstaller.assertit(connectorDescriptor.getArchivist().getArchiveUri().equals(string2));
        }
        String string3 = this.getFullConnectorName(string, string2);
        this.connectorDescriptors.put(string3, connectorDescriptor);
    }

    public void unregisterConnectorDescriptor(String string, String string2) {
        String string3 = this.getFullConnectorName(string, string2);
        this.connectorDescriptors.remove(string3);
    }

    public void forceResourcePoolCleanup(String string, String string2) {
        String string3 = this.getFullConnectorName(string, string2);
        PoolManager poolManager = Switch.getSwitch().getPoolManager();
        Set set = this.resourceInfo.getResourcesByType(6);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ConnectorResource connectorResource = (ConnectorResource)iterator.next();
            String string4 = this.getFullConnectorName(connectorResource.getApplicationName(), connectorResource.getConnectorName());
            if (!string4.equals(string3)) continue;
            ResourceSpec resourceSpec = new ResourceSpec(connectorResource.getName(), 1);
            poolManager.emptyResourcePool(resourceSpec);
        }
    }

    public ConnectorDescriptor getDescriptorByJndiName(String string) {
        ConnectorResource connectorResource = (ConnectorResource)this.resourceInfo.getResourceByName(6, string);
        if (connectorResource == null) {
            return null;
        }
        return this.getDescriptorByConnectorName(connectorResource.getApplicationName(), connectorResource.getConnectorName());
    }

    public ConnectorDescriptor getDescriptorByConnectorName(String string, String string2) {
        try {
            String string3 = this.getFullConnectorName(string, string2);
            ConnectorDescriptor connectorDescriptor = (ConnectorDescriptor)this.connectorDescriptors.get(string3);
            if (connectorDescriptor != null) {
                return connectorDescriptor;
            }
            ResourceAdapter resourceAdapter = (ResourceAdapter)this.resourceInfo.getResourceByName(7, string3);
            ConnectorDescriptor connectorDescriptor2 = null;
            if (resourceAdapter != null) {
                File file = new File(FileUtil.getAbsolutePath(CONNECTOR_ADAPTER_DIR + File.separator + resourceAdapter.getName()));
                JarFile jarFile = new JarFile(file);
                JarEntry jarEntry = jarFile.getJarEntry(ConnectorArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY);
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                ConnectorNode connectorNode = ConnectorNode.read(inputStream, false);
                connectorDescriptor2 = connectorNode.getDescriptor();
                inputStream.close();
                jarFile.close();
            } else {
                Application application = JarRepository.getApplicationForName(string);
                if (application == null) {
                    return null;
                }
                try {
                    connectorDescriptor2 = application.getRarDescriptorByUri(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
            if (connectorDescriptor2 != null) {
                this.connectorDescriptors.put(string3, connectorDescriptor2);
            }
            return connectorDescriptor2;
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "jndi.connection_cannot_get", exception);
            return null;
        }
    }

    public Object createConnectionFactory(String string) {
        ConnectorResource connectorResource = (ConnectorResource)this.resourceInfo.getResourceByName(6, string);
        try {
            Object object = connectorResource.createConnectionFactory();
            return object;
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "jndi.connection_create_error", exception);
            return null;
        }
    }

    private String getFullConnectorName(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException("Null connectorName");
        }
        if (string == null || string.equals("")) {
            return string2;
        }
        return string + ":" + string2;
    }

    private static void assertit(boolean bl) {
        if (!bl) {
            Thread.dumpStack();
        }
    }

    public void addResource(J2EEResource j2EEResource) throws PoolingException {
        try {
            this.resourceInfo.addResource(j2EEResource);
            this.resFactory.storeDefaultResourceCollection(this.resourceInfo);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "J2EE.add_resource_error", exception);
            throw new PoolingException(exception.toString());
        }
    }

    public void removeResource(J2EEResource j2EEResource) throws PoolingException {
        try {
            this.resourceInfo.removeResource(j2EEResource);
            this.resFactory.storeDefaultResourceCollection(this.resourceInfo);
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "J2EE.remove_resource_error", exception);
            throw new PoolingException(exception.toString());
        }
    }

    public Set listAdapterResources() {
        Set set = this.resourceInfo.getResourcesByType(7);
        return set;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

