/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.repository.JdbcConnectionPool;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Context;
import javax.sql.DataSource;

public class JdbcUrlAllocator
implements ResourceAllocator {
    private PoolManager poolMgr;
    private ResourceSpec spec;
    private ClientSecurityInfo info;
    private Context ic;
    private String jdbcUrl;

    public JdbcUrlAllocator(PoolManager poolManager, String string, ResourceSpec resourceSpec, ClientSecurityInfo clientSecurityInfo) {
        this.poolMgr = poolManager;
        this.spec = resourceSpec;
        this.info = clientSecurityInfo;
        this.jdbcUrl = string;
        this.ic = Switch.getSwitch().getNamingManager().getInitialContext();
    }

    public ResourceHandle createResource() throws PoolingException {
        try {
            ResourceHandle resourceHandle = null;
            ResourcePrincipal resourcePrincipal = this.info.getPrincipal();
            String string = resourcePrincipal.getName();
            String string2 = resourcePrincipal.getPassword();
            JdbcConnectionPool jdbcConnectionPool = (JdbcConnectionPool)this.ic.lookup(this.jdbcUrl);
            DataSource dataSource = (DataSource)jdbcConnectionPool.createDataSource();
            Connection connection = resourcePrincipal.isDefault() ? dataSource.getConnection() : dataSource.getConnection(string, string2);
            connection.setAutoCommit(false);
            resourceHandle = new ResourceHandle(connection, this.spec, this, this.info);
            return resourceHandle;
        }
        catch (Exception exception) {
            if (exception instanceof PoolingException) {
                throw (PoolingException)exception;
            }
            throw new PoolingException(exception);
        }
    }

    public void fillInResourceObjects(ResourceHandle resourceHandle) throws PoolingException {
    }

    public void closeUserConnection(ResourceHandle resourceHandle) throws PoolingException {
    }

    public void destroyResource(ResourceHandle resourceHandle) throws PoolingException {
        try {
            Connection connection = (Connection)resourceHandle.getResource();
            connection.close();
        }
        catch (SQLException sQLException) {
            throw new PoolingException(sQLException);
        }
    }

    public boolean matchConnection(ResourceHandle resourceHandle) {
        return resourceHandle.getClientSecurityInfo().equals(this.info);
    }

    public boolean supportsReauthentication() {
        return false;
    }

    public void cleanup(ResourceHandle resourceHandle) throws PoolingException {
    }

    public boolean isTransactional() {
        return false;
    }

    public boolean shareableWithinComponent() {
        return false;
    }

    public Object getSharedConnection(ResourceHandle resourceHandle) throws PoolingException {
        throw new IllegalStateException("getSharedConnection not supported");
    }
}

