/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.AbstractSchemaName;
import com.sun.ejb.ejbql.BinaryOperator;
import com.sun.ejb.ejbql.BinaryOperatorExpression;
import com.sun.ejb.ejbql.BooleanLiteral;
import com.sun.ejb.ejbql.CmpField;
import com.sun.ejb.ejbql.CmrField;
import com.sun.ejb.ejbql.EjbQLQuery;
import com.sun.ejb.ejbql.Expression;
import com.sun.ejb.ejbql.IdentificationVar;
import com.sun.ejb.ejbql.InputParam;
import com.sun.ejb.ejbql.Literal;
import com.sun.ejb.ejbql.NavigationExpression;
import com.sun.ejb.ejbql.Operator;
import com.sun.ejb.ejbql.OperatorExpression;
import com.sun.ejb.ejbql.QueryParam;
import com.sun.ejb.ejbql.SelectClause;
import com.sun.ejb.ejbql.VisitorAdapter;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import java.lang.reflect.Field;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class RuntimeInfoVisitor
extends VisitorAdapter {
    private static final boolean debug = false;
    private EjbQLQuery query_;
    private PersistentFieldInfo cmpFieldInfo_;
    private PersistenceDescriptor ejbObjReturnDesc_;
    private List queryParams_;

    public RuntimeInfoVisitor(EjbQLQuery ejbQLQuery) {
        super(1);
        this.query_ = ejbQLQuery;
        this.queryParams_ = new Vector();
        this.cmpFieldInfo_ = null;
        this.ejbObjReturnDesc_ = null;
    }

    public void generateRuntimeInfo() {
        this.query_.accept(this);
    }

    public boolean getReturnsCmpField() {
        return this.cmpFieldInfo_ != null;
    }

    public boolean getReturnsEjb() {
        return this.ejbObjReturnDesc_ != null;
    }

    public int getCmpFieldReturnJdbcType() {
        if (!this.getReturnsCmpField()) {
            throw new IllegalStateException();
        }
        return this.cmpFieldInfo_.jdbcType;
    }

    public PersistenceDescriptor getEjbDescriptor() {
        if (!this.getReturnsEjb()) {
            throw new IllegalStateException();
        }
        return this.ejbObjReturnDesc_;
    }

    public Class getQueryMethodReturnType() throws Exception {
        return this.query_.getQueryMethodReturnType();
    }

    public boolean getQueryMethodReturnsSingleValue() {
        return this.query_.queryMethodReturnsSingleValue();
    }

    public boolean getQueryMethodReturnsCollection() {
        return this.query_.queryMethodReturnsCollection();
    }

    public boolean getQueryMethodReturnsSet() {
        return this.query_.queryMethodReturnsSet();
    }

    public boolean hasLocalReturnTypeMapping() {
        if (this.query_.isSelectQuery() && this.getReturnsEjb()) {
            return this.query_.hasLocalReturnTypeMapping();
        }
        throw new IllegalStateException("only applicable for select queries returning ejbs");
    }

    public boolean hasRemoteReturnTypeMapping() {
        return !this.hasLocalReturnTypeMapping();
    }

    public boolean getQueryHasDistinctResults() {
        return this.query_.hasDistinctResults();
    }

    public Class getReturnObjectType() throws Exception {
        Class<?> clazz = this.getQueryMethodReturnType();
        if (!this.getQueryMethodReturnsSingleValue()) {
            if (this.getReturnsCmpField()) {
                clazz = this.cmpFieldInfo_.type;
            } else if (this.getReturnsEjb()) {
                String string = this.query_.getQueryReturnType();
                ClassLoader classLoader = this.query_.getEjbBundleClassLoader();
                clazz = classLoader.loadClass(string);
            }
        }
        return clazz;
    }

    public List getQueryParams() {
        return this.queryParams_;
    }

    public void visitMemberOfExpression(OperatorExpression operatorExpression) {
        BinaryOperatorExpression binaryOperatorExpression = (BinaryOperatorExpression)operatorExpression;
        Expression expression = binaryOperatorExpression.getFirstExpression();
        if (expression.isInputParam()) {
            NavigationExpression navigationExpression = (NavigationExpression)binaryOperatorExpression.getSecondExpression();
            AbstractSchemaName abstractSchemaName = navigationExpression.getAbstractSchema();
            this.addPersistentObjectQueryParams((InputParam)expression, abstractSchemaName.getPersDescriptor());
        }
    }

    public void visitOperatorExpression(OperatorExpression operatorExpression) {
        Operator operator = operatorExpression.getOperator();
        ListIterator listIterator = operatorExpression.getChildren(this.getTraversalType());
        boolean bl = false;
        if (operator.equals(BinaryOperator.EQUAL) || operator.equals(BinaryOperator.NOT_EQUAL)) {
            BinaryOperatorExpression binaryOperatorExpression = (BinaryOperatorExpression)operatorExpression;
            Expression expression = binaryOperatorExpression.getFirstExpression();
            Expression expression2 = binaryOperatorExpression.getSecondExpression();
            if (expression2.isInputParam()) {
                if (expression.isIdentificationVar()) {
                    IdentificationVar identificationVar = (IdentificationVar)expression;
                    AbstractSchemaName abstractSchemaName = identificationVar.getAbstractSchema();
                    this.addPersistentObjectQueryParams((InputParam)expression2, abstractSchemaName.getPersDescriptor());
                    bl = true;
                } else if (expression.isNavigationExpression() && ((NavigationExpression)expression).endsInCmrField()) {
                    NavigationExpression navigationExpression = (NavigationExpression)expression;
                    CmrField cmrField = navigationExpression.getLastExpressionCmr();
                    this.addPersistentObjectQueryParams((InputParam)expression2, cmrField.getSinkPersistenceDescriptor());
                    bl = true;
                }
            }
        }
        if (!bl) {
            super.visitOperatorExpression(operatorExpression);
        }
    }

    private void addPersistentObjectQueryParams(InputParam inputParam, PersistenceDescriptor persistenceDescriptor) {
        int n = inputParam.getParamIndex();
        PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPkeyFieldInfo();
        int n2 = 0;
        while (n2 < persistentFieldInfoArray.length) {
            QueryParam queryParam = new QueryParam(2);
            queryParam.setParamIndex(n);
            queryParam.setPersistenceDescriptor(persistenceDescriptor);
            if (!persistenceDescriptor.primaryKeyIsOneField()) {
                Field[] fieldArray = persistenceDescriptor.getPkeyClassFields();
                if (fieldArray != null) {
                    queryParam.setPkeyClassField(fieldArray[n2]);
                } else {
                    System.out.println("Warning -- pkey class pkey fields not available for " + persistenceDescriptor.getName());
                }
            }
            this.queryParams_.add(queryParam);
            ++n2;
        }
    }

    public void visitLiteral(Literal literal) {
        QueryParam queryParam = null;
        if (literal.isInputParam()) {
            InputParam inputParam = (InputParam)literal;
            queryParam = new QueryParam(1);
            queryParam.setParamIndex(inputParam.getParamIndex());
        } else if (literal instanceof BooleanLiteral) {
            BooleanLiteral booleanLiteral = (BooleanLiteral)literal;
            queryParam = new QueryParam(3);
            queryParam.setBooleanValue((Boolean)booleanLiteral.getLiteral());
        }
        if (queryParam != null) {
            this.queryParams_.add(queryParam);
        }
    }

    public void visitSelectClause(SelectClause selectClause) {
        Expression expression = selectClause.getExpression();
        NavigationExpression navigationExpression = null;
        if (expression.isNavigationExpression()) {
            navigationExpression = (NavigationExpression)expression;
            if (navigationExpression.endsInCmpField()) {
                CmpField cmpField = navigationExpression.getLastExpressionCmp();
                this.cmpFieldInfo_ = cmpField.getPersistentFieldInfo();
            } else {
                PersistenceDescriptor persistenceDescriptor;
                CmrField cmrField = navigationExpression.getLastExpressionCmr();
                this.ejbObjReturnDesc_ = persistenceDescriptor = cmrField.getSinkPersistenceDescriptor();
            }
        } else {
            IdentificationVar identificationVar = (IdentificationVar)expression;
            AbstractSchemaName abstractSchemaName = identificationVar.getAbstractSchema();
            this.ejbObjReturnDesc_ = abstractSchemaName.getPersDescriptor();
        }
    }
}

