/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.pool;

import com.iplanet.ias.util.threadpool.Servicable;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.util.ContainerWorkPool;
import com.sun.ejb.containers.util.pool.AbstractPool;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.containers.util.pool.PoolException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimerTask;
import java.util.logging.Level;

public class NonBlockingPool
extends AbstractPool {
    private String poolName;
    private TimerTask poolTimerTask;
    protected boolean addedResizeTask = false;
    protected boolean addedIdleBeanWork = false;
    protected boolean inResizing = false;
    private boolean maintainSteadySize = false;
    private int resizeTaskCount;
    private int timerTaskCount;

    protected NonBlockingPool() {
    }

    public NonBlockingPool(String string, ObjectFactory objectFactory, int n, int n2, int n3, int n4) {
        this.poolName = string;
        this.initializePool(objectFactory, n, n2, n3, n4);
    }

    protected void initializePool(ObjectFactory objectFactory, int n, int n2, int n3, int n4) {
        block4: {
            this.list = new ArrayList();
            this.factory = objectFactory;
            this.steadyPoolSize = n <= 0 ? 0 : n;
            this.resizeQuantity = n2 <= 0 ? 0 : n2;
            this.maxPoolSize = n3 <= 0 ? Integer.MAX_VALUE : n3;
            this.steadyPoolSize = this.steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : this.steadyPoolSize;
            int n5 = this.idleTimeoutInSeconds = n4 <= 0 ? 0 : n4;
            if (n > 0) {
                this.preload(n);
            }
            this.containerClassLoader = this.getClass().getClassLoader();
            boolean bl = this.maintainSteadySize = this.steadyPoolSize > 0;
            if (this.idleTimeoutInSeconds <= 0 || this.resizeQuantity <= 0) break block4;
            try {
                this.poolTimerTask = new PoolResizeTimerTask();
                ContainerFactoryImpl.getTimer().scheduleAtFixedRate(this.poolTimerTask, n4 * 1000, (long)(n4 * 1000));
                if (AbstractPool._logger.isLoggable(Level.FINE)) {
                    AbstractPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Added PoolResizeTimerTask...");
                }
            }
            catch (Throwable throwable) {
                if (!AbstractPool._logger.isLoggable(Level.WARNING)) break block4;
                AbstractPool._logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Could not add" + " PoolTimerTask. Continuing anyway...", throwable);
            }
        }
    }

    public void setContainerClassLoader(ClassLoader classLoader) {
        this.containerClassLoader = classLoader;
    }

    public Object getObject(boolean bl, Object object) throws PoolException {
        return this.getObject(object);
    }

    public Object getObject(long l, Object object) throws PoolException {
        return this.getObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object getObject(Object object) {
        Object var3_3;
        boolean bl;
        block13: {
            bl = false;
            var3_3 = null;
            ArrayList arrayList = this.list;
            // MONITORENTER : arrayList
            int n = this.list.size();
            if (n > this.steadyPoolSize) {
                ++this.poolSuccess;
                // MONITOREXIT : arrayList
                return this.list.remove(n - 1);
            }
            if (n > 0) {
                ++this.poolSuccess;
                if (this.maintainSteadySize && !this.addedResizeTask) {
                    this.addedResizeTask = true;
                    bl = true;
                    var3_3 = this.list.remove(n - 1);
                    break block13;
                } else {
                    // MONITOREXIT : arrayList
                    return this.list.remove(n - 1);
                }
            }
            if (this.maintainSteadySize && !this.addedResizeTask) {
                this.addedResizeTask = true;
                bl = true;
            }
            ++this.createdCount;
        }
        // MONITOREXIT : arrayList
        if (bl) {
            this.addResizeTaskForImmediateExecution();
        }
        if (var3_3 != null) {
            return var3_3;
        }
        try {
            return this.factory.create(object);
        }
        catch (RuntimeException runtimeException) {
            ArrayList arrayList = this.list;
            // MONITORENTER : arrayList
            --this.createdCount;
            // MONITOREXIT : arrayList
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResizeTaskForImmediateExecution() {
        block6: {
            try {
                ReSizeWork reSizeWork = new ReSizeWork();
                ContainerWorkPool.addLast(reSizeWork);
                if (AbstractPool._logger.isLoggable(Level.FINE)) {
                    AbstractPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Added PoolResizeTimerTask...");
                }
                ++this.resizeTaskCount;
            }
            catch (Exception exception) {
                ArrayList arrayList = this.list;
                synchronized (arrayList) {
                    this.addedResizeTask = false;
                }
                if (!AbstractPool._logger.isLoggable(Level.WARNING)) break block6;
                AbstractPool._logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Cannot perform " + " pool resize task", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.list.size() < this.maxPoolSize) {
                this.list.add(object);
                return;
            }
            ++this.destroyedCount;
        }
        try {
            this.factory.destroy(object);
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(Object object) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            ++this.destroyedCount;
        }
        try {
            this.factory.destroy(object);
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preload(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        try {
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(this.factory.create(null));
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n3 = arrayList.size();
        if (n3 == 0) {
            return;
        }
        ArrayList arrayList2 = this.list;
        synchronized (arrayList2) {
            int n4 = 0;
            while (n4 < n3) {
                this.list.add(arrayList.get(n4));
                ++n4;
            }
            this.createdCount += n3;
        }
    }

    public void prepopulate(int n) {
        this.steadyPoolSize = n <= 0 ? 0 : n;
        int n2 = this.steadyPoolSize = this.steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : this.steadyPoolSize;
        if (this.steadyPoolSize > 0) {
            this.preload(this.steadyPoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.poolTimerTask != null) {
                try {
                    this.poolTimerTask.cancel();
                    if (AbstractPool._logger.isLoggable(Level.FINE)) {
                        AbstractPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Cancelled pool timer task " + " at: " + new Date());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (AbstractPool._logger.isLoggable(Level.FINE)) {
                AbstractPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Destroying " + this.list.size() + " beans from the pool...");
            }
            Object[] objectArray = this.list.toArray();
            int n = 0;
            while (n < objectArray.length) {
                block14: {
                    try {
                        ++this.destroyedCount;
                        try {
                            this.factory.destroy(objectArray[n]);
                        }
                        catch (Throwable throwable) {}
                    }
                    catch (Throwable throwable) {
                        if (!AbstractPool._logger.isLoggable(Level.WARNING)) break block14;
                        AbstractPool._logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Error while destroying: " + throwable);
                    }
                }
                ++n;
            }
            if (AbstractPool._logger.isLoggable(Level.FINE)) {
                AbstractPool._logger.log(Level.FINE, "Pool-" + this.poolName + "]: Pool closed....");
            }
            this.list.clear();
        }
        this.list = null;
        this.factory = null;
        this.poolTimerTask = null;
        this.containerClassLoader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(int n) {
        int n2;
        int n3;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = this.list;
        synchronized (arrayList2) {
            n3 = this.list.size();
            n2 = 0;
            while (n2 < n && n3 > 0) {
                arrayList.add(this.list.remove(--n3));
                ++this.destroyedCount;
                ++n2;
            }
        }
        n3 = arrayList.size();
        n2 = 0;
        while (n2 < n3) {
            try {
                this.factory.destroy(arrayList.get(n2));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
    }

    protected void removeIdleObjects() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doResize() {
        block47: {
            block46: {
                block44: {
                    block42: {
                        var1_1 = Thread.currentThread();
                        var2_2 = var1_1.getContextClassLoader();
                        var3_3 = this.containerClassLoader;
                        var4_4 = 0L;
                        var6_5 = false;
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                var1_1.setContextClassLoader(var3_3);
                                return null;
                            }
                        });
                        if (AbstractPool._logger.isLoggable(Level.FINE)) {
                            AbstractPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize started at: " + new Date() + " steadyPoolSize ::" + this.steadyPoolSize + " resizeQuantity ::" + this.resizeQuantity + " maxPoolSize ::" + this.maxPoolSize);
                        }
                        var4_4 = System.currentTimeMillis();
                        var7_6 = new ArrayList();
                        var8_9 = 0;
                        var9_11 = this.list;
                        synchronized (var9_11) {
                            if (!this.inResizing) ** break block41
                            // MONITOREXIT @DISABLED, blocks:[0, 16, 1] lbl18 : MonitorExitStatement: MONITOREXIT : var9_11
                            if (!var6_5) break block42;
                            var10_12 = this.list;
                        }
                        synchronized (var10_12) {
                            this.inResizing = false;
                        }
                    }
                    AccessController.doPrivileged(new PrivilegedAction(var1_1, var2_2){
                        private final /* synthetic */ Thread val$currentThread;
                        private final /* synthetic */ ClassLoader val$previousClassLoader;
                        {
                            this.val$currentThread = thread;
                            this.val$previousClassLoader = classLoader;
                        }

                        public Object run() {
                            this.val$currentThread.setContextClassLoader(this.val$previousClassLoader);
                            return null;
                        }
                    });
                    return;
                    {
                        var6_5 = true;
                        this.inResizing = true;
                        var10_13 = this.list.size();
                        if (var10_13 <= this.steadyPoolSize) ** GOTO lbl68
                        if (this.idleTimeoutInSeconds > 0 && this.resizeQuantity > 0) ** break block43
                        // MONITOREXIT @DISABLED, blocks:[16, 3] lbl38 : MonitorExitStatement: MONITOREXIT : var9_11
                        if (!var6_5) break block44;
                        var11_15 = this.list;
                    }
                    synchronized (var11_15) {
                        this.inResizing = false;
                    }
                }
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                return;
                {
                    var11_16 = var10_13 > this.steadyPoolSize + this.resizeQuantity ? this.resizeQuantity : var10_13 - this.steadyPoolSize;
                    var12_19 = System.currentTimeMillis() - (long)(this.idleTimeoutInSeconds * 1000);
                    if (AbstractPool._logger.isLoggable(Level.FINE)) {
                        AbstractPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize:: reducing " + " pool size by: " + var11_16);
                    }
                    var14_21 = 0;
                    while (var14_21 < var11_16) {
                        var15_22 = (EJBContextImpl)this.list.get(0);
                        if (var15_22.getLastTimeUsed() <= var12_19) {
                            var7_6.add(this.list.remove(0));
                            ++this.destroyedCount;
                            ++var14_21;
                            continue;
                        }
                        ** GOTO lbl87
                    }
                    ** GOTO lbl87
lbl68:
                    // 1 sources

                    if (var10_13 >= this.steadyPoolSize) ** GOTO lbl87
                    if (this.maintainSteadySize) ** break block45
                    // MONITOREXIT @DISABLED, blocks:[16, 5] lbl70 : MonitorExitStatement: MONITOREXIT : var9_11
                    if (!var6_5) break block46;
                    var11_17 = this.list;
                }
                synchronized (var11_17) {
                    this.inResizing = false;
                }
            }
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            return;
            {
                var8_9 = var10_13 + this.resizeQuantity > this.maxPoolSize ? this.maxPoolSize - var10_13 : (this.resizeQuantity <= 0 ? this.steadyPoolSize - var10_13 : this.resizeQuantity);
lbl87:
                // 4 sources

                // MONITOREXIT @DISABLED, blocks:[16, 7, 8] lbl87 : MonitorExitStatement: MONITOREXIT : var9_11
                {
                    catch (Throwable var17_24) {
                        throw var17_24;
                    }
                }
                if (var7_6.size() > 0) {
                    var10_13 = var7_6.size();
                    var11_16 = 0;
                    while (var11_16 < var10_13) {
                        try {
                            this.factory.destroy(var7_6.get(var11_16));
                        }
                        catch (Throwable var12_20) {
                            // empty catch block
                        }
                        ++var11_16;
                    }
                }
                if (var8_9 > 0) {
                    this.preload(var8_9);
                }
                if (!var6_5) break block47;
                var7_6 = this.list;
            }
            synchronized (var7_6) {
                this.inResizing = false;
            }
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        ** GOTO lbl144
        {
            catch (Throwable var7_7) {
                block48: {
                    try {
                        if (AbstractPool._logger.isLoggable(Level.WARNING)) {
                            AbstractPool._logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Exception during reSize", var7_7);
                        }
                        if (!var6_5) break block48;
                        var8_10 = this.list;
                    }
                    catch (Throwable var20_27) {
                        if (var6_5) {
                            var21_28 = this.list;
                            synchronized (var21_28) {
                                this.inResizing = false;
                            }
                        }
                        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                        throw var20_27;
                    }
                    synchronized (var8_10) {
                        this.inResizing = false;
                    }
                }
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            }
            var7_8 = System.currentTimeMillis();
            if (AbstractPool._logger.isLoggable(Level.FINE)) {
                AbstractPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize completed at: " + new Date() + "; after reSize: " + this.getAllAttrValues());
                AbstractPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize took: " + (double)(var7_8 - var4_4) / 1000.0 + " seconds.");
            }
            return;
        }
    }

    public String getAllAttrValues() {
        StringBuffer stringBuffer = new StringBuffer("[Pool-" + this.poolName + "] ");
        stringBuffer.append("CC=").append(this.createdCount).append("; ").append("DC=").append(this.destroyedCount).append("; ").append("CS=").append(this.list.size()).append("; ").append("SS=").append(this.steadyPoolSize).append("; ").append("MS=").append(this.maxPoolSize).append(";");
        return stringBuffer.toString();
    }

    private class PoolResizeTimerTask
    extends TimerTask {
        Object lock;

        PoolResizeTimerTask() {
        }

        PoolResizeTimerTask(Object object) {
            this.lock = object;
        }

        public void run() {
            block3: {
                try {
                    if (NonBlockingPool.this.addedIdleBeanWork) {
                        return;
                    }
                    IdleBeanWork idleBeanWork = new IdleBeanWork();
                    ContainerWorkPool.addLast(idleBeanWork);
                    NonBlockingPool.this.addedIdleBeanWork = true;
                }
                catch (Exception exception) {
                    if (!AbstractPool._logger.isLoggable(Level.WARNING)) break block3;
                    AbstractPool._logger.log(Level.WARNING, "[Pool-" + NonBlockingPool.this.poolName + "]: Cannot perform " + " pool idle bean cleanup", exception);
                }
            }
        }
    }

    private class IdleBeanWork
    implements Servicable {
        private IdleBeanWork() {
        }

        public void prolog() {
        }

        public void service() {
            this.run();
        }

        public void epilog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    NonBlockingPool.this.doResize();
                }
                catch (Exception exception) {
                    Object var3_2 = null;
                    NonBlockingPool.this.addedIdleBeanWork = false;
                }
                Object var3_1 = null;
                NonBlockingPool.this.addedIdleBeanWork = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                NonBlockingPool.this.addedIdleBeanWork = false;
                throw throwable;
            }
        }
    }

    private class ReSizeWork
    implements Servicable {
        private ReSizeWork() {
        }

        public void prolog() {
        }

        public void service() {
            this.run();
        }

        public void epilog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ArrayList arrayList;
            try {
                try {
                    NonBlockingPool.this.doResize();
                }
                catch (Exception exception) {
                    if (AbstractPool._logger.isLoggable(Level.WARNING)) {
                        AbstractPool._logger.log(Level.WARNING, "[Pool-" + NonBlockingPool.this.poolName + "]: Exception during reSize", exception);
                    }
                    Object var3_2 = null;
                    ArrayList arrayList3 = NonBlockingPool.this.list;
                    synchronized (arrayList3) {
                        NonBlockingPool.this.addedResizeTask = false;
                        return;
                    }
                }
                Object var3_1 = null;
                arrayList = NonBlockingPool.this.list;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ArrayList arrayList2 = NonBlockingPool.this.list;
                synchronized (arrayList2) {
                    NonBlockingPool.this.addedResizeTask = false;
                    throw throwable;
                }
            }
            synchronized (arrayList) {
                NonBlockingPool.this.addedResizeTask = false;
                return;
            }
        }
    }
}

