/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb;

import com.sun.ejb.SerializableJNDIContext;
import com.sun.ejb.containers.EJBLocalHomeImpl;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.enterprise.Switch;
import com.sun.enterprise.util.ObjectInputStreamWithLoader;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.rmi.Remote;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;

final class EJBObjectInputStream
extends ObjectInputStreamWithLoader {
    private static Logger _logger = null;

    public EJBObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException, StreamCorruptedException {
        super(inputStream, classLoader);
        this.enableResolveObject(true);
    }

    public EJBObjectInputStream(InputStream inputStream, ClassLoader classLoader, boolean bl) throws IOException, StreamCorruptedException {
        super(inputStream, classLoader);
        if (bl) {
            this.enableResolveObject(bl);
        }
    }

    protected Object resolveObject(Object object) throws IOException {
        try {
            if (object instanceof Remote) {
                Switch.getSwitch().getProtocolManager().connectObject((Remote)object);
                return object;
            }
            if (object instanceof EJBLocalHomeImpl.SerializableLocalHome) {
                return EJBLocalHomeImpl.getLocalHome((EJBLocalHomeImpl.SerializableLocalHome)object);
            }
            if (object instanceof EJBLocalObjectImpl.SerializableLocalObject) {
                return EJBLocalObjectImpl.getLocalObject((EJBLocalObjectImpl.SerializableLocalObject)object);
            }
            if (object instanceof SerializableJNDIContext) {
                SerializableJNDIContext serializableJNDIContext = (SerializableJNDIContext)object;
                String string = serializableJNDIContext.name;
                InitialContext initialContext = new InitialContext();
                if (string == null || string.length() == 0) {
                    return initialContext;
                }
                return initialContext.lookup(((SerializableJNDIContext)object).name);
            }
            return object;
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "ejb.resolve_object_exception");
            throw new IOException(exception.toString());
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    }
}

