/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.core;

public final class OSFCodeSetRegistry {
    private static final int ISO_8859_1_VALUE = 65537;
    private static final int UTF_16_VALUE = 65801;
    private static final int UTF_8_VALUE = 0x5010001;
    private static final int UCS_2_VALUE = 65792;
    private static final int ISO_646_VALUE = 65568;
    public static final Entry ISO_8859_1 = new Entry("ISO-8859-1", 65537, true, 1);
    static final Entry UTF_16BE = new Entry("UTF-16BE", -1, true, 2);
    static final Entry UTF_16LE = new Entry("UTF-16LE", -2, true, 2);
    public static final Entry UTF_16 = new Entry("UTF-16", 65801, true, 4);
    public static final Entry UTF_8 = new Entry("UTF-8", 0x5010001, false, 6);
    public static final Entry UCS_2 = new Entry("UCS-2", 65792, true, 2);
    public static final Entry ISO_646 = new Entry("US-ASCII", 65568, true, 1);

    private OSFCodeSetRegistry() {
    }

    public static Entry lookupEntry(int n) {
        switch (n) {
            case 65537: {
                return ISO_8859_1;
            }
            case 65801: {
                return UTF_16;
            }
            case 0x5010001: {
                return UTF_8;
            }
            case 65568: {
                return ISO_646;
            }
            case 65792: {
                return UCS_2;
            }
        }
        return null;
    }

    public static final class Entry {
        private String javaName;
        private int encodingNum;
        private boolean isFixedWidth;
        private int maxBytesPerChar;

        private Entry(String string, int n, boolean bl, int n2) {
            this.javaName = string;
            this.encodingNum = n;
            this.isFixedWidth = bl;
            this.maxBytesPerChar = n2;
        }

        public String getName() {
            return this.javaName;
        }

        public int getNumber() {
            return this.encodingNum;
        }

        public boolean isFixedWidth() {
            return this.isFixedWidth;
        }

        public int getMaxBytesPerChar() {
            return this.maxBytesPerChar;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.javaName.equals(entry.javaName) && this.encodingNum == entry.encodingNum && this.isFixedWidth == entry.isFixedWidth && this.maxBytesPerChar == entry.maxBytesPerChar;
        }

        public int hashCode() {
            return this.encodingNum;
        }
    }
}

