/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.PCosNaming;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;

class CounterDB
implements Serializable {
    private Integer counter;
    private static String counterFileName = "counter";
    private transient File counterFile;
    public static final int rootCounter = 0;

    CounterDB(File file) {
        counterFileName = "counter";
        this.counterFile = new File(file, counterFileName);
        if (!this.counterFile.exists()) {
            this.counter = new Integer(0);
            this.writeCounter();
        } else {
            this.readCounter();
        }
    }

    private void readCounter() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.counterFile);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this.counter = (Integer)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.FINE, "", exception);
        }
    }

    private void writeCounter() {
        try {
            this.counterFile.delete();
            FileOutputStream fileOutputStream = new FileOutputStream(this.counterFile);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.counter);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.FINE, "", exception);
        }
    }

    public synchronized int getNextCounter() {
        int n = this.counter;
        this.counter = new Integer(++n);
        this.writeCounter();
        return n;
    }
}

