/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.ActivationIDL.BadServerDefinition;
import com.sun.corba.ee.ActivationIDL.RepositoryPackage.ServerDef;
import com.sun.corba.ee.ActivationIDL.ServerAlreadyInstalled;
import com.sun.corba.ee.ActivationIDL.ServerAlreadyRegistered;
import com.sun.corba.ee.ActivationIDL.ServerAlreadyUninstalled;
import com.sun.corba.ee.ActivationIDL.ServerNotRegistered;
import com.sun.corba.ee.ActivationIDL._RepositoryImplBase;
import com.sun.corba.ee.internal.Activation.ServerTableEntry;
import com.sun.corba.ee.internal.POA.POAORB;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;

public class RepositoryImpl
extends _RepositoryImplBase
implements Serializable {
    private static final long serialVersionUID = 8458417785209341858L;
    private transient boolean debug = false;
    static final int illegalServerId = -1;
    private transient RepositoryDB db = null;
    transient POAORB orb = null;

    RepositoryImpl(POAORB pOAORB, File file, boolean bl) {
        this.debug = bl;
        File file2 = new File(file, "servers.db");
        if (!file2.exists()) {
            this.db = new RepositoryDB(file2);
            this.db.flush();
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                this.db = (RepositoryDB)objectInputStream.readObject();
                objectInputStream.close();
            }
            catch (Exception exception) {
                LogWrap.logger.log(Level.FINE, "iiop.imr_db_error_read", exception);
                throw new INITIALIZE(1398079889, CompletionStatus.COMPLETED_NO);
            }
        }
        this.orb = pOAORB;
        pOAORB.connect(this);
    }

    private String printServerDef(ServerDef serverDef) {
        return "ServerDef[applicationName=" + serverDef.applicationName + " serverName=" + serverDef.serverName + " serverClassPath=" + serverDef.serverClassPath + " serverArgs=" + serverDef.serverArgs + " serverVmArgs=" + serverDef.serverVmArgs + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerServer(ServerDef serverDef, int n) throws ServerAlreadyRegistered {
        DBServerDef dBServerDef = null;
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            Enumeration enumeration = this.db.serverTable.elements();
            while (enumeration.hasMoreElements()) {
                dBServerDef = (DBServerDef)enumeration.nextElement();
                if (!serverDef.applicationName.equals(dBServerDef.applicationName)) continue;
                if (this.debug) {
                    System.out.println("RepositoryImpl: registerServer called to register ServerDef " + this.printServerDef(serverDef) + " with " + (n == -1 ? "a new server Id" : "server Id " + n) + " FAILED because it is already registered.");
                }
                throw new ServerAlreadyRegistered(dBServerDef.id);
            }
            int n2 = n == -1 ? this.db.incrementServerIdCounter() : n;
            dBServerDef = new DBServerDef(serverDef, n2);
            this.db.serverTable.put(new Integer(n2), dBServerDef);
            this.db.flush();
            if (this.debug) {
                if (n == -1) {
                    System.out.println("RepositoryImpl: registerServer called to register ServerDef " + this.printServerDef(serverDef) + " with new serverId " + n2);
                } else {
                    System.out.println("RepositoryImpl: registerServer called to register ServerDef " + this.printServerDef(serverDef) + " with assigned serverId " + n2);
                }
            }
            return n2;
        }
    }

    public int registerServer(ServerDef serverDef) throws ServerAlreadyRegistered, BadServerDefinition {
        int n = this.orb.getServerGIOP().getBootstrapEndpoint(0).getPort();
        ServerTableEntry serverTableEntry = new ServerTableEntry(-1, serverDef, n, "", true, this.debug);
        switch (serverTableEntry.verify()) {
            case 0: {
                break;
            }
            case 1: {
                throw new BadServerDefinition("main class not found.");
            }
            case 2: {
                throw new BadServerDefinition("no main method found.");
            }
            case 3: {
                throw new BadServerDefinition("server application error.");
            }
            default: {
                throw new BadServerDefinition("unknown Exception.");
            }
        }
        return this.registerServer(serverDef, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServer(int n) throws ServerNotRegistered {
        DBServerDef dBServerDef = null;
        Integer n2 = new Integer(n);
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            dBServerDef = (DBServerDef)this.db.serverTable.get(n2);
            if (dBServerDef == null) {
                if (this.debug) {
                    System.out.println("RepositoryImpl: unregisterServer for serverId " + n + " called: server not registered");
                }
                throw new ServerNotRegistered();
            }
            this.db.serverTable.remove(n2);
            this.db.flush();
        }
        if (this.debug) {
            System.out.println("RepositoryImpl: unregisterServer for serverId " + n + " called");
        }
    }

    private DBServerDef getDBServerDef(int n) throws ServerNotRegistered {
        Integer n2 = new Integer(n);
        DBServerDef dBServerDef = (DBServerDef)this.db.serverTable.get(n2);
        if (dBServerDef == null) {
            throw new ServerNotRegistered(n);
        }
        return dBServerDef;
    }

    public ServerDef getServer(int n) throws ServerNotRegistered {
        DBServerDef dBServerDef = this.getDBServerDef(n);
        ServerDef serverDef = new ServerDef(dBServerDef.applicationName, dBServerDef.name, dBServerDef.classPath, dBServerDef.args, dBServerDef.vmArgs);
        if (this.debug) {
            System.out.println("RepositoryImpl: getServer for serverId " + n + " returns " + this.printServerDef(serverDef));
        }
        return serverDef;
    }

    public boolean isInstalled(int n) throws ServerNotRegistered {
        DBServerDef dBServerDef = this.getDBServerDef(n);
        return dBServerDef.isInstalled;
    }

    public void install(int n) throws ServerNotRegistered, ServerAlreadyInstalled {
        DBServerDef dBServerDef = this.getDBServerDef(n);
        if (dBServerDef.isInstalled) {
            throw new ServerAlreadyInstalled(n);
        }
        dBServerDef.isInstalled = true;
        this.db.flush();
    }

    public void uninstall(int n) throws ServerNotRegistered, ServerAlreadyUninstalled {
        DBServerDef dBServerDef = this.getDBServerDef(n);
        if (!dBServerDef.isInstalled) {
            throw new ServerAlreadyUninstalled(n);
        }
        dBServerDef.isInstalled = false;
        this.db.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] listRegisteredServers() {
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            Serializable serializable;
            int n = 0;
            int[] nArray = new int[this.db.serverTable.size()];
            Enumeration enumeration = this.db.serverTable.elements();
            while (enumeration.hasMoreElements()) {
                serializable = (DBServerDef)enumeration.nextElement();
                nArray[n++] = ((DBServerDef)serializable).id;
            }
            if (this.debug) {
                serializable = new StringBuffer();
                int n2 = 0;
                while (n2 < nArray.length) {
                    ((StringBuffer)serializable).append(' ');
                    ((StringBuffer)serializable).append(nArray[n2]);
                    ++n2;
                }
                System.out.println("RepositoryImpl: listRegisteredServers returns" + ((StringBuffer)serializable).toString());
            }
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getServerID(String string) throws ServerNotRegistered {
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            int n = -1;
            Enumeration enumeration = this.db.serverTable.keys();
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                DBServerDef dBServerDef = (DBServerDef)this.db.serverTable.get(n2);
                if (!dBServerDef.applicationName.equals(string)) continue;
                n = n2;
                break;
            }
            if (this.debug) {
                System.out.println("RepositoryImpl: getServerID for " + string + " is " + n);
            }
            if (n == -1) {
                throw new ServerNotRegistered();
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getApplicationNames() {
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            String[] stringArray;
            Vector<String> vector = new Vector<String>();
            Enumeration enumeration = this.db.serverTable.keys();
            while (enumeration.hasMoreElements()) {
                stringArray = (Integer)enumeration.nextElement();
                DBServerDef dBServerDef = (DBServerDef)this.db.serverTable.get(stringArray);
                if (dBServerDef.applicationName.equals("")) continue;
                vector.addElement(dBServerDef.applicationName);
            }
            stringArray = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
            if (this.debug) {
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    stringBuffer.append(' ');
                    stringBuffer.append(stringArray[n2]);
                    ++n2;
                }
                System.out.println("RepositoryImpl: getApplicationNames returns " + stringBuffer.toString());
            }
            return stringArray;
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-debug")) {
                bl = true;
            }
            ++n;
        }
        try {
            Properties properties = new Properties();
            properties.put("org.omg.CORBA.ORBClass", "com.sun.corba.ee.internal.Interceptors.PIORB");
            POAORB pOAORB = (POAORB)ORB.init(stringArray, properties);
            String string = System.getProperty("com.sun.CORBA.activation.db", "db");
            RepositoryImpl repositoryImpl = new RepositoryImpl(pOAORB, new File(string), bl);
            pOAORB.run();
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, "", exception);
        }
    }

    class DBServerDef
    implements Serializable {
        String applicationName;
        String name;
        String classPath;
        String args;
        String vmArgs;
        boolean isInstalled;
        int id;

        public String toString() {
            return "DBServerDef(applicationName=" + this.applicationName + ", name=" + this.name + ", classPath=" + this.classPath + ", args=" + this.args + ", vmArgs=" + this.vmArgs + ", id=" + this.id + ", isInstalled=" + this.isInstalled + ")";
        }

        DBServerDef(ServerDef serverDef, int n) {
            this.applicationName = serverDef.applicationName;
            this.name = serverDef.serverName;
            this.classPath = serverDef.serverClassPath;
            this.args = serverDef.serverArgs;
            this.vmArgs = serverDef.serverVmArgs;
            this.id = n;
            this.isInstalled = false;
        }
    }

    class RepositoryDB
    implements Serializable {
        File db;
        Hashtable serverTable;
        Integer serverIdCounter;

        RepositoryDB(File file) {
            this.db = file;
            this.serverTable = new Hashtable(255);
            this.serverIdCounter = new Integer(256);
        }

        int incrementServerIdCounter() {
            int n = this.serverIdCounter;
            this.serverIdCounter = new Integer(++n);
            return n;
        }

        void flush() {
            try {
                this.db.delete();
                FileOutputStream fileOutputStream = new FileOutputStream(this.db);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this);
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (Exception exception) {
                LogWrap.logger.log(Level.FINE, "iiop.imr_db_error_write", exception);
                throw new INTERNAL(1398079889, CompletionStatus.COMPLETED_NO);
            }
        }
    }
}

