/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache;

import com.sun.appserv.web.cache.CacheHelper;
import com.sun.appserv.web.cache.CacheKeyGenerator;
import com.sun.appserv.web.cache.CacheManager;
import com.sun.appserv.web.cache.mapping.CacheMapping;
import com.sun.appserv.web.cache.mapping.Constants;
import com.sun.appserv.web.cache.mapping.ConstraintField;
import com.sun.appserv.web.cache.mapping.Field;
import com.sun.logging.LogDomains;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class DefaultCacheHelper
implements CacheHelper {
    public static final String ATTR_CACHING_FILTER_NAME = "com.sun.ias.web.cachingFilterName";
    public static final String PROP_KEY_GENERATOR_ATTR_NAME = "cacheKeyGeneratorAttrName";
    private static Logger _logger;
    private static boolean _isTraceEnabled;
    private static ResourceBundle _rb;
    ServletContext context;
    CacheManager manager;
    String attrKeyGenerator = null;
    boolean isKeyGeneratorChecked = false;
    CacheKeyGenerator keyGenerator;

    public void setCacheManager(CacheManager cacheManager) {
        this.manager = cacheManager;
    }

    public void init(ServletContext servletContext, Map map) {
        this.context = servletContext;
        this.attrKeyGenerator = (String)map.get(PROP_KEY_GENERATOR_ATTR_NAME);
        _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        _isTraceEnabled = _logger.isLoggable(Level.FINE);
        _rb = _logger.getResourceBundle();
    }

    private CacheMapping lookupCacheMapping(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute(ATTR_CACHING_FILTER_NAME);
        return this.manager.getCacheMapping(string);
    }

    public String getCacheKey(HttpServletRequest httpServletRequest) {
        CharSequence charSequence;
        CacheMapping cacheMapping = this.lookupCacheMapping(httpServletRequest);
        if (!this.isKeyGeneratorChecked && this.attrKeyGenerator != null) {
            try {
                this.keyGenerator = (CacheKeyGenerator)this.context.getAttribute(this.attrKeyGenerator);
            }
            catch (ClassCastException classCastException) {
                _logger.log(Level.WARNING, "cache.defaultHelp.illegalKeyGenerator", classCastException);
            }
            this.isKeyGeneratorChecked = true;
        }
        if (this.keyGenerator != null && (charSequence = this.keyGenerator.getCacheKey(this.context, httpServletRequest)) != null) {
            return charSequence;
        }
        charSequence = new StringBuffer(128);
        ((StringBuffer)charSequence).append(httpServletRequest.getServletPath());
        Field[] fieldArray = cacheMapping.getKeyFields();
        int n = 0;
        while (n < fieldArray.length) {
            Object object = fieldArray[n].getValue(this.context, httpServletRequest);
            if (object == null) {
                if (_isTraceEnabled) {
                    _logger.fine("DefaultCacheHelper: cannot find all the required key fields in the request " + httpServletRequest.getServletPath());
                }
                return null;
            }
            ((StringBuffer)charSequence).append(";");
            ((StringBuffer)charSequence).append(Constants.KEY_PREFIXES[fieldArray[n].getScope()]);
            ((StringBuffer)charSequence).append(fieldArray[n].getName());
            ((StringBuffer)charSequence).append("=");
            ((StringBuffer)charSequence).append(object);
            ++n;
        }
        return ((StringBuffer)charSequence).toString();
    }

    public boolean isCacheable(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        CacheMapping cacheMapping = this.lookupCacheMapping(httpServletRequest);
        if (cacheMapping.findMethod(httpServletRequest.getMethod())) {
            bl = true;
            ConstraintField[] constraintFieldArray = cacheMapping.getConstraintFields();
            int n = 0;
            while (n < constraintFieldArray.length) {
                if (!constraintFieldArray[n].applyConstraints(this.context, httpServletRequest)) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public boolean isRefreshNeeded(HttpServletRequest httpServletRequest) {
        Object object;
        boolean bl = false;
        CacheMapping cacheMapping = this.lookupCacheMapping(httpServletRequest);
        Field field = cacheMapping.getRefreshField();
        if (field != null && (object = field.getValue(this.context, httpServletRequest)) != null && "true".equals(object.toString())) {
            bl = true;
        }
        return bl;
    }

    public int getTimeout(HttpServletRequest httpServletRequest) {
        int n;
        block2: {
            Object object;
            CacheMapping cacheMapping = this.lookupCacheMapping(httpServletRequest);
            n = cacheMapping.getTimeout();
            Field field = cacheMapping.getTimeoutField();
            if (field == null || (object = field.getValue(this.context, httpServletRequest)) == null) break block2;
            try {
                Integer n2 = new Integer(object.toString());
                n = n2;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }

    public void destroy() throws Exception {
    }

    static {
        _isTraceEnabled = false;
        _rb = null;
    }
}

