/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.util.cache;

import com.sun.appserv.util.cache.Cache;
import com.sun.appserv.util.cache.CacheListener;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class BaseCache
implements Cache {
    protected static ResourceBundle _rb = null;
    static final int MAX_ENTRIES = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    int maxEntries;
    protected int entryCount;
    private Object entryCountLk = new Object();
    protected int threshold = 0;
    private int hitCount;
    private Object hitCountLk = new Object();
    private int missCount;
    private Object missCountLk = new Object();
    private int removalCount;
    private Object removalCountLk = new Object();
    private int refreshCount;
    private Object refreshCountLk = new Object();
    private int addCount;
    private Object addCountLk = new Object();
    private int overflowCount;
    private Object overflowCountLk = new Object();
    protected int maxBuckets;
    protected CacheItem[] buckets;
    protected Object[] bucketLocks;
    protected boolean[] refreshFlags;
    protected ArrayList listeners = new ArrayList();

    public void init(int n, Properties properties) throws Exception {
        this.init(n, 0.75f, properties);
    }

    public void init(int n, float f, Properties properties) {
        _rb = LogDomains.getLogger("javax.enterprise.system.util").getResourceBundle();
        if (n <= 0) {
            String string = _rb.getString("cache.BaseCache.illegalMaxEntries");
            Integer n2 = new Integer(n);
            Object[] objectArray = new Object[]{n2};
            string = MessageFormat.format(string, objectArray);
            throw new IllegalArgumentException(string);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        this.maxEntries = n;
        this.maxBuckets = 1;
        while (this.maxBuckets < n) {
            this.maxBuckets <<= 1;
        }
        if (n != 0) {
            this.threshold = (int)((float)n * f) + 1;
        }
        this.entryCount = 0;
        this.buckets = new CacheItem[this.maxBuckets];
        this.bucketLocks = new Object[this.maxBuckets];
        this.refreshFlags = new boolean[this.maxBuckets];
        int n3 = 0;
        while (n3 < this.maxBuckets) {
            this.buckets[n3] = null;
            this.bucketLocks[n3] = new Object();
            this.refreshFlags[n3] = false;
            ++n3;
        }
    }

    public void addCacheListener(CacheListener cacheListener) {
        this.listeners.add(cacheListener);
    }

    protected int hash(Object object) {
        int n = object.hashCode();
        return n - (n << 7);
    }

    protected boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    protected void handleOverflow() {
        this.threshold *= 2;
        this.incrementOverflowCount();
    }

    protected CacheItem itemAdded(CacheItem cacheItem) {
        if (this.isThresholdReached()) {
            this.handleOverflow();
        }
        return null;
    }

    protected void itemAccessed(CacheItem cacheItem) {
    }

    protected void itemRefreshed(CacheItem cacheItem, int n) {
    }

    protected void itemRemoved(CacheItem cacheItem) {
    }

    protected Object loadValue(Object object, int n) {
        return null;
    }

    protected CacheItem createItem(int n, Object object, Object object2, int n2) {
        return new CacheItem(n, object, object2, n2);
    }

    protected boolean isThresholdReached() {
        return this.entryCount > this.threshold;
    }

    protected final int getIndex(int n) {
        return n & this.maxBuckets - 1;
    }

    public final int getIndex(Object object) {
        return this.getIndex(this.hash(object));
    }

    public Object get(Object object) {
        int n = this.hash(object);
        return this.get(n, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int n, Object object) {
        Object object2;
        int n2 = this.getIndex(n);
        CacheItem cacheItem = null;
        Object object3 = this.bucketLocks[n2];
        synchronized (object3) {
            cacheItem = this.buckets[n2];
            while (cacheItem != null) {
                if (n == cacheItem.hashCode && this.eq(object, cacheItem.key)) break;
                cacheItem = cacheItem.next;
            }
            if (cacheItem != null) {
                object2 = cacheItem.getValue();
                this.itemAccessed(cacheItem);
            } else {
                object2 = this.loadValue(object, n);
            }
        }
        if (cacheItem != null) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
        return object2;
    }

    public boolean contains(Object object) {
        return this.get(object) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getAll(Object object) {
        int n = this.hash(object);
        int n2 = this.getIndex(n);
        ArrayList<Object> arrayList = new ArrayList<Object>(this.entryCount);
        Object object2 = this.bucketLocks[n2];
        synchronized (object2) {
            CacheItem cacheItem = this.buckets[n2];
            while (cacheItem != null) {
                if (n == cacheItem.hashCode && this.eq(object, cacheItem.key)) {
                    this.incrementHitCount();
                    arrayList.add(cacheItem.getValue());
                }
                cacheItem = cacheItem.next;
            }
        }
        return arrayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator keys() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.entryCount);
        int n = 0;
        while (n < this.maxBuckets) {
            Object object = this.bucketLocks[n];
            synchronized (object) {
                CacheItem cacheItem = this.buckets[n];
                while (cacheItem != null) {
                    arrayList.add(cacheItem.key);
                    cacheItem = cacheItem.next;
                }
            }
            ++n;
        }
        return arrayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration elements() {
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < this.maxBuckets) {
            Object object = this.bucketLocks[n];
            synchronized (object) {
                CacheItem cacheItem = this.buckets[n];
                while (cacheItem != null) {
                    vector.addElement(cacheItem.key);
                    cacheItem = cacheItem.next;
                }
            }
            ++n;
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator values() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.entryCount);
        int n = 0;
        while (n < this.maxBuckets) {
            Object object = this.bucketLocks[n];
            synchronized (object) {
                CacheItem cacheItem = this.buckets[n];
                while (cacheItem != null) {
                    arrayList.add(cacheItem.value);
                    cacheItem = cacheItem.next;
                }
            }
            ++n;
        }
        return arrayList.iterator();
    }

    public Object put(Object object, Object object2) {
        int n = this.hash(object);
        return this._put(n, object, object2, -1, false);
    }

    public Object put(Object object, Object object2, int n) {
        int n2 = this.hash(object);
        return this._put(n2, object, object2, n, false);
    }

    public void add(Object object, Object object2) {
        int n = this.hash(object);
        this._put(n, object, object2, -1, true);
    }

    public void add(Object object, Object object2, int n) {
        int n2 = this.hash(object);
        this._put(n2, object, object2, n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _put(int n, Object object, Object object2, int n2, boolean bl) {
        Object object3;
        int n3 = this.getIndex(n);
        CacheItem cacheItem = null;
        CacheItem cacheItem2 = null;
        CacheItem cacheItem3 = null;
        int n4 = 0;
        Object object4 = this.bucketLocks[n3];
        synchronized (object4) {
            CacheItem cacheItem4 = this.buckets[n3];
            while (cacheItem4 != null) {
                if (n == cacheItem4.hashCode && this.eq(object, cacheItem4.key)) {
                    cacheItem2 = cacheItem4;
                    break;
                }
                cacheItem4 = cacheItem4.next;
            }
            if (bl || cacheItem2 == null) {
                cacheItem = this.createItem(n, object, object2, n2);
                cacheItem.next = this.buckets[n3];
                this.buckets[n3] = cacheItem;
                object3 = null;
                cacheItem3 = this.itemAdded(cacheItem);
            } else {
                n4 = cacheItem2.getSize();
                object3 = cacheItem2.refreshValue(object2, n2);
                this.itemRefreshed(cacheItem2, n4);
            }
        }
        if (cacheItem != null) {
            this.incrementEntryCount();
            this.incrementAddCount();
            if (cacheItem3 != null) {
                this.trimItem(cacheItem3);
            }
        } else {
            this.incrementRefreshCount();
        }
        return object3;
    }

    public Object remove(Object object) {
        int n = this.hash(object);
        Object object2 = null;
        CacheItem cacheItem = this._remove(n, object, null);
        if (cacheItem != null) {
            object2 = cacheItem.getValue();
        }
        return object2;
    }

    public Object remove(int n, Object object) {
        Object object2 = null;
        CacheItem cacheItem = this._remove(n, object, null);
        if (cacheItem != null) {
            object2 = cacheItem.getValue();
        }
        return object2;
    }

    public Object remove(Object object, Object object2) {
        int n = this.hash(object);
        Object object3 = null;
        CacheItem cacheItem = this._remove(n, object, object2);
        if (cacheItem != null) {
            object3 = cacheItem.getValue();
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheItem _remove(int n, Object object, Object object2) {
        int n2 = this.getIndex(n);
        CacheItem cacheItem = null;
        CacheItem cacheItem2 = null;
        Object object3 = this.bucketLocks[n2];
        synchronized (object3) {
            cacheItem2 = this.buckets[n2];
            while (cacheItem2 != null) {
                if (n == cacheItem2.hashCode && object.equals(cacheItem2.key) && (object2 == null || object2 == cacheItem2.value)) {
                    if (cacheItem == null) {
                        this.buckets[n2] = cacheItem2.next;
                    } else {
                        cacheItem.next = cacheItem2.next;
                    }
                    cacheItem2.next = null;
                    this.itemRemoved(cacheItem2);
                    break;
                }
                cacheItem = cacheItem2;
                cacheItem2 = cacheItem2.next;
            }
        }
        if (cacheItem2 != null) {
            this.decrementEntryCount();
            this.incrementRemovalCount();
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
        return cacheItem2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheItem _removeItem(CacheItem cacheItem) {
        int n = this.getIndex(cacheItem.hashCode);
        CacheItem cacheItem2 = null;
        CacheItem cacheItem3 = null;
        Object object = this.bucketLocks[n];
        synchronized (object) {
            cacheItem3 = this.buckets[n];
            while (cacheItem3 != null) {
                if (cacheItem3 == cacheItem) {
                    if (cacheItem2 == null) {
                        this.buckets[n] = cacheItem3.next;
                    } else {
                        cacheItem2.next = cacheItem3.next;
                    }
                    cacheItem3.next = null;
                    break;
                }
                cacheItem2 = cacheItem3;
                cacheItem3 = cacheItem3.next;
            }
        }
        if (cacheItem3 != null) {
            this.decrementEntryCount();
        }
        return cacheItem3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Object object) {
        int n = this.hash(object);
        int n2 = this.getIndex(n);
        CacheItem cacheItem = null;
        CacheItem cacheItem2 = null;
        ArrayList<CacheItem> arrayList = new ArrayList<CacheItem>(this.entryCount);
        Object object2 = this.bucketLocks[n2];
        synchronized (object2) {
            cacheItem2 = this.buckets[n2];
            while (cacheItem2 != null) {
                if (n == cacheItem2.hashCode && object.equals(cacheItem2.key)) {
                    if (cacheItem == null) {
                        this.buckets[n2] = cacheItem2.next;
                    } else {
                        cacheItem.next = cacheItem2.next;
                    }
                    cacheItem2.next = null;
                    this.decrementEntryCount();
                    this.incrementRemovalCount();
                    arrayList.add(cacheItem2);
                }
                cacheItem = cacheItem2;
                cacheItem2 = cacheItem2.next;
            }
        }
        int n3 = 0;
        while (n3 < arrayList.size()) {
            this.itemRemoved((CacheItem)arrayList.get(n3));
            ++n3;
        }
    }

    protected void trimItem(CacheItem cacheItem) {
        CacheItem cacheItem2 = this._removeItem(cacheItem);
        if (cacheItem2 != null) {
            int n = 0;
            while (n < this.listeners.size()) {
                CacheListener cacheListener = (CacheListener)this.listeners.get(n);
                cacheListener.trimEvent(cacheItem2.key, cacheItem2.value);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitRefresh(int n) {
        Object object = this.bucketLocks[n];
        synchronized (object) {
            if (!this.refreshFlags[n]) {
                this.refreshFlags[n] = true;
                return false;
            }
            try {
                this.bucketLocks[n].wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRefresh(int n) {
        Object object = this.bucketLocks[n];
        synchronized (object) {
            this.refreshFlags[n] = false;
            this.bucketLocks[n].notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clear() {
        CacheItem cacheItem = null;
        CacheItem cacheItem2 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.maxBuckets) {
            Object object = this.bucketLocks[n2];
            synchronized (object) {
                cacheItem = this.buckets[n2];
                while (cacheItem != null) {
                    cacheItem2 = cacheItem.next;
                    cacheItem.next = null;
                    ++n;
                    this.decrementEntryCount();
                    this.itemRemoved(cacheItem);
                    if (this.entryCount == 0) break;
                    cacheItem = cacheItem.next;
                }
                this.buckets[n2] = null;
            }
            ++n2;
        }
        return n;
    }

    public void trimExpiredEntries(int n) {
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public boolean isEmpty() {
        return this.entryCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementEntryCount() {
        Object object = this.entryCountLk;
        synchronized (object) {
            ++this.entryCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void decrementEntryCount() {
        Object object = this.entryCountLk;
        synchronized (object) {
            --this.entryCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementHitCount() {
        Object object = this.hitCountLk;
        synchronized (object) {
            ++this.hitCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementMissCount() {
        Object object = this.missCountLk;
        synchronized (object) {
            ++this.missCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementRemovalCount() {
        Object object = this.removalCountLk;
        synchronized (object) {
            ++this.removalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementRefreshCount() {
        Object object = this.refreshCountLk;
        synchronized (object) {
            ++this.refreshCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementAddCount() {
        Object object = this.addCountLk;
        synchronized (object) {
            ++this.addCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementOverflowCount() {
        Object object = this.overflowCountLk;
        synchronized (object) {
            ++this.overflowCount;
        }
    }

    public Object getStatByName(String string) {
        Integer n = null;
        if (string == null) {
            return null;
        }
        if (string.equals("cache.BaseCache.stat_maxEntries")) {
            n = new Integer(this.maxEntries);
        } else if (string.equals("cache.BaseCache.stat_threshold")) {
            n = new Integer(this.threshold);
        } else if (string.equals("cache.BaseCache.stat_tableSize")) {
            n = new Integer(this.maxBuckets);
        } else if (string.equals("cache.BaseCache.stat_entryCount")) {
            n = new Integer(this.entryCount);
        } else if (string.equals("cache.BaseCache.stat_hitCount")) {
            n = new Integer(this.hitCount);
        } else if (string.equals("cache.BaseCache.stat_missCount")) {
            n = new Integer(this.missCount);
        } else if (string.equals("cache.BaseCache.stat_removalCount")) {
            n = new Integer(this.removalCount);
        } else if (string.equals("cache.BaseCache.stat_refreshCount")) {
            n = new Integer(this.refreshCount);
        } else if (string.equals("cache.BaseCache.stat_overflowCount")) {
            n = new Integer(this.overflowCount);
        } else if (string.equals("cache.BaseCache.stat_addCount")) {
            n = new Integer(this.addCount);
        }
        return n;
    }

    public Map getStats() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("cache.BaseCache.stat_maxEntries", new Integer(this.maxEntries));
        hashMap.put("cache.BaseCache.stat_threshold", new Integer(this.threshold));
        hashMap.put("cache.BaseCache.stat_tableSize", new Integer(this.maxBuckets));
        hashMap.put("cache.BaseCache.stat_entryCount", new Integer(this.entryCount));
        hashMap.put("cache.BaseCache.stat_hitCount", new Integer(this.hitCount));
        hashMap.put("cache.BaseCache.stat_missCount", new Integer(this.missCount));
        hashMap.put("cache.BaseCache.stat_removalCount", new Integer(this.removalCount));
        hashMap.put("cache.BaseCache.stat_refreshCount", new Integer(this.refreshCount));
        hashMap.put("cache.BaseCache.stat_overflowCount", new Integer(this.overflowCount));
        hashMap.put("cache.BaseCache.stat_addCount", new Integer(this.addCount));
        return hashMap;
    }

    public void destroy() {
        if (this.listeners != null && this.buckets != null && this.bucketLocks != null) {
            this.clear();
            this.listeners.clear();
        }
        this.entryCountLk = null;
        this.hitCountLk = null;
        this.missCountLk = null;
        this.removalCountLk = null;
        this.refreshCountLk = null;
        this.addCountLk = null;
        this.overflowCountLk = null;
        this.buckets = null;
        this.bucketLocks = null;
        this.refreshFlags = null;
        this.listeners = null;
    }

    public void clearStats() {
        this.hitCount = 0;
        this.missCount = 0;
        this.removalCount = 0;
        this.refreshCount = 0;
        this.overflowCount = 0;
        this.addCount = 0;
    }

    protected static class CacheItem {
        int hashCode;
        Object key;
        Object value;
        int size;
        CacheItem next;

        protected CacheItem(int n, Object object, Object object2, int n2) {
            this.hashCode = n;
            this.key = object;
            this.value = object2;
            this.size = n2;
        }

        protected int getHashCode() {
            return this.hashCode;
        }

        protected Object getKey() {
            return this.key;
        }

        protected Object getValue() {
            return this.value;
        }

        protected int getSize() {
            return this.size;
        }

        protected Object refreshValue(Object object, int n) {
            Object object2 = this.value;
            this.value = object;
            this.size = n;
            return object2;
        }

        public String toString() {
            return "key: " + this.key + "; value: " + this.value.toString();
        }
    }
}

