/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.config.serverbeans.WebModule;
import com.iplanet.ias.server.MonitorListener;
import com.iplanet.ias.server.MonitorableEntry;
import com.iplanet.ias.server.ReloadMonitor;
import java.io.File;
import java.util.ArrayList;

public final class StandaloneWebModulesManager
implements MonitorListener {
    private String _id = null;
    private String _modulesRoot = null;
    private ArrayList _reloadables = new ArrayList();

    public StandaloneWebModulesManager(String string, String string2) {
        this._id = string;
        this._modulesRoot = string2;
    }

    public void start(WebModule[] webModuleArray, long l) {
        ReloadMonitor reloadMonitor = ReloadMonitor.getInstance(l * 1000L);
        if (webModuleArray != null && webModuleArray.length > 0) {
            int n = 0;
            while (n < webModuleArray.length) {
                WebModule webModule = webModuleArray[n];
                String string = webModule.getName();
                String string2 = string + "[" + this._id + "]";
                String string3 = this.getReloadFilename(webModule);
                if (webModule.isEnabled()) {
                    MonitorableEntry monitorableEntry = new MonitorableEntry(string2, string, new File(string3), this);
                    this._reloadables.add(string2);
                    reloadMonitor.addMonitorableEntry(monitorableEntry);
                }
                ++n;
            }
        }
    }

    public void stop() {
        ReloadMonitor reloadMonitor = ReloadMonitor.getInstance(1L);
        int n = 0;
        while (n < this._reloadables.size()) {
            String string = (String)this._reloadables.get(n);
            reloadMonitor.removeMonitoredEntry(string);
            ++n;
        }
        this._reloadables.clear();
        this._reloadables = null;
    }

    public boolean reload(MonitorableEntry monitorableEntry) {
        return true;
    }

    public boolean deploy(MonitorableEntry monitorableEntry, File file) {
        return false;
    }

    private String getReloadFilename(WebModule webModule) {
        String string = webModule.getLocation();
        File file = new File(string);
        if (!file.isAbsolute()) {
            string = this._modulesRoot + "/" + string;
        }
        return string + "/" + ".reload";
    }
}

