/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.ejb.codegen;

import com.iplanet.ias.ejb.codegen.ProcessExecutor;
import com.iplanet.ias.ejb.codegen.ProcessExecutorException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class ProcessRunner
implements Runnable {
    static final Logger logger = ProcessExecutor.logger;
    long timeout;
    String[] cmd;
    StringBuffer stdout = new StringBuffer();
    StringBuffer stderr = new StringBuffer();
    int exitCode;
    boolean completed = false;
    boolean interrupted = false;
    ProcessExecutorException exception;
    private String cmdString = null;

    ProcessRunner(String[] stringArray, long l) {
        this.cmd = stringArray;
        this.timeout = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Process process = null;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            try {
                process = Runtime.getRuntime().exec(this.cmd);
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, "process.creation_failed", iOException);
                this.makeOtherException(iOException);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                    if (process != null) {
                        process.destroy();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            if (this.checkInterrupted()) {
                return;
            }
            inputStream = process.getInputStream();
            inputStream2 = process.getErrorStream();
            this.readFromStream(inputStream2, this.stderr);
            if (this.checkInterrupted()) {
                return;
            }
            this.readFromStream(inputStream, this.stdout);
            if (this.checkInterrupted()) {
                return;
            }
            try {
                inputStream.close();
                inputStream2.close();
                inputStream = null;
                inputStream2 = null;
            }
            catch (IOException iOException) {
                logger.log(Level.FINEST, "process.stream_close_error", iOException);
            }
            this.exitCode = process.waitFor();
            if (this.exitCode != 0) {
                this.makeAbnormalTerminationException();
            }
            process.destroy();
            process = null;
            this.completed = true;
        }
        catch (InterruptedException interruptedException) {
            logger.log(Level.FINEST, "process.interrupted");
            this.interrupted = true;
            this.makeTimeoutException();
        }
        catch (Exception exception) {
            logger.log(Level.FINEST, "process.execution_failed", exception);
            this.makeOtherException(exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (inputStream2 != null) {
                    inputStream2.close();
                }
                if (process != null) {
                    process.destroy();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    void readFromStream(InputStream inputStream, StringBuffer stringBuffer) {
        byte[] byArray = new byte[1024];
        try {
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                stringBuffer.append(new String(byArray, 0, n));
                if (!this.checkInterrupted()) continue;
                return;
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINEST, "process.stream_read_error", iOException);
        }
    }

    private boolean checkInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            this.interrupted = true;
            this.makeTimeoutException();
        }
        return this.interrupted;
    }

    void makeTimeoutException() {
        String string = this.stderr.toString() + "\n" + this.stdout.toString();
        this.exception = new ProcessExecutorException("process.timeout", "Process timed out.\nTimeout was {2} msecs\nAttempted command: {0}\nOutput from command: {1}", new Object[]{this.getCommandString(), string, new Long(this.timeout)});
    }

    void makeAbnormalTerminationException() {
        String string = this.stderr.toString() + "\n" + this.stdout.toString();
        this.exception = new ProcessExecutorException("process.abnormal_termination", "Abnormal process termination -- process returned: {0}\nAttempted command: {1}\nOutput from command: {2}", new Object[]{new Integer(this.exitCode), this.getCommandString(), string});
    }

    void makeOtherException(Throwable throwable) {
        String string = this.stderr.toString() + "\n" + this.stdout.toString();
        this.exception = new ProcessExecutorException("process.unknown_exception", "Abnormal process termination -- process threw an Exception.\nAttempted command: {0}\nOutput from command: {1}", new Object[]{this.getCommandString(), string}, throwable);
    }

    String getCommandString() {
        if (this.cmdString == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.cmd.length) {
                stringBuffer.append(this.cmd[n] + " ");
                ++n;
            }
            this.cmdString = stringBuffer.toString();
        }
        return this.cmdString;
    }
}

