/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.deployment.ClientJarArchivist;
import com.iplanet.ias.deployment.backend.ClientJarMaker;
import com.iplanet.ias.deployment.backend.Deployer;
import com.iplanet.ias.deployment.backend.DeploymentCommand;
import com.iplanet.ias.deployment.backend.DeploymentRequest;
import com.iplanet.ias.deployment.backend.DirNameManager;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.deployment.backend.ModuleInfo;
import com.iplanet.ias.instance.BaseManager;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.ModuleEnvironment;
import com.iplanet.ias.instance.WebModulesManager;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileSource;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipItem;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;

public abstract class ModuleDeployer
extends Deployer {
    private BaseManager modulesMgr = null;
    protected String moduleName = null;
    protected File moduleDir = null;
    protected File stubsDir = null;
    protected File jspDir = null;
    protected File clientJar = null;
    protected File oldModuleDir = null;
    protected File oldStubsDir = null;
    protected File oldJSPDir = null;
    protected ModuleEnvironment moduleEnv = null;
    protected ModuleInfo moduleInfo = null;
    protected String oldRegisteredLocation = null;
    protected boolean locationChangeWasRegisteredCold = false;
    private boolean locationChangeWasRegisteredHot = false;
    private boolean wasRegisteredThisSession = false;
    private boolean shouldRollback = false;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$deployment$backend$ModuleDeployer;

    protected abstract BaseManager createConfigManager(InstanceEnvironment var1, ModuleEnvironment var2) throws IASDeploymentException, ConfigException;

    protected abstract void preDeploy() throws IASDeploymentException;

    protected abstract void deploy() throws IASDeploymentException, ConfigException;

    protected abstract void preRedeploy() throws IASDeploymentException, ConfigException;

    protected abstract void postRedeploy() throws IASDeploymentException, ConfigException;

    protected abstract void rollbackRedeploy() throws IASDeploymentException;

    protected abstract String whatTypeAmI();

    protected ModuleDeployer(DeploymentRequest deploymentRequest) throws IASDeploymentException {
        super(deploymentRequest);
    }

    protected boolean needsStubs() {
        return false;
    }

    protected boolean needsJSPs() {
        return false;
    }

    public void doRequest() throws IASDeploymentException {
        try {
            block11: {
                try {
                    this.begin();
                    if (this.request.isDeploy()) {
                        this.preDeploy();
                        this.deploy();
                        this.postDeploy();
                        this.addToSummary("Successful " + this.whatTypeAmI() + " Deployment of " + this.moduleName + " to " + this.moduleDir.getPath());
                    } else if (this.request.isReDeploy()) {
                        this.preRedeploy();
                        this.redeploy();
                        this.postRedeploy();
                        this.addToSummary("Successful " + this.whatTypeAmI() + " Redeployment of " + this.moduleName + " to " + this.moduleDir.getPath());
                    } else if (this.request.isUnDeploy()) {
                        this.undeploy();
                        this.addToSummary("Successful " + this.whatTypeAmI() + " Undeployment of " + this.moduleName + " from " + this.moduleDir.getPath());
                    } else {
                        String string = localStrings.getString("enterprise.deployment.backend.unknown_deployment_command");
                        throw new IASDeploymentException(string);
                    }
                    if (this.request.isReDeploy()) break block11;
                    this.saveHotConfig();
                }
                catch (Exception exception) {
                    if (this.shouldRollback) {
                        this.rollback();
                    }
                    String string = localStrings.getString("enterprise.deployment.backend.dorequest_exception");
                    this.logger.log(Level.WARNING, string, exception);
                    throw new IASDeploymentException(string, exception);
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.finish();
            throw throwable;
        }
        this.finish();
    }

    protected void begin() throws IASDeploymentException {
        super.begin();
        InstanceEnvironment instanceEnvironment = this.getInstanceEnv();
        this.moduleEnv = this.request.getModuleEnv();
        this.moduleName = this.request.getName();
        if (this.moduleEnv == null) {
            String string = localStrings.getString("enterprise.deployment.backend.null_moduleenvironment");
            throw new IASDeploymentException(string);
        }
        try {
            this.moduleEnv.verify();
            this.modulesMgr = this.createConfigManager(instanceEnvironment, this.moduleEnv);
            this.setDeployCommand();
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception.getMessage());
        }
        this.shouldRollback = true;
        this.setDirs();
        this.createLockFile(this.moduleDir);
        this.clientJar = new File(this.moduleDir, this.moduleName + "Client.jar");
    }

    private void setDirs() throws IASDeploymentException {
        if (!$assertionsDisabled && this.modulesMgr == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.moduleName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.moduleEnv == null) {
            throw new AssertionError();
        }
        if (this.request.isDeploy()) {
            this.setDirsDeploy();
        } else if (this.request.isReDeploy()) {
            this.setDirsReDeploy();
        } else if (this.request.isUnDeploy()) {
            this.setDirsUnDeploy();
        } else {
            String string = localStrings.getString("enterprise.deployment.backend.deployment_type_error");
            throw new IASDeploymentException(string);
        }
        this.request.setDeployedDirectory(this.moduleDir);
        this.request.setJSPDirectory(this.jspDir);
        this.request.setStubsDirectory(this.stubsDir);
    }

    private void setDirsDeploy() throws IASDeploymentException {
        if (this.isRegistered()) {
            String string = localStrings.getString("enterprise.deployment.backend.deploy_error_module_exists");
            throw new IASDeploymentException(string);
        }
        this.stubsDir = this.needsStubs() ? new File(this.moduleEnv.getModuleStubPath()) : null;
        if (this.needsJSPs()) {
            if (!$assertionsDisabled && !(this.modulesMgr instanceof WebModulesManager)) {
                throw new AssertionError();
            }
            this.jspDir = new File(this.moduleEnv.getModuleJSPPath());
        }
        if (this.isArchive()) {
            File file = new File(this.getInstanceEnv().getModuleRepositoryPath());
            DirNameManager dirNameManager = new DirNameManager(file, null, this.moduleName);
            this.moduleDir = dirNameManager.getNewDir();
        } else if (this.isDirectory()) {
            FileSource fileSource = this.request.getFileSource();
            if (fileSource == null || !fileSource.exists()) {
                String string = localStrings.getString("enterprise.deployment.backend.file_source_does_not_exist", fileSource);
                throw new IASDeploymentException(string);
            }
            this.moduleDir = fileSource.getFile();
            if (!FileUtils.safeIsDirectory(this.moduleDir)) {
                String string = localStrings.getString("enterprise.deployment.backend.deployment_directory_does_not_exist", this.moduleDir.getPath());
                throw new IASDeploymentException(string);
            }
        } else {
            String string = localStrings.getString("enterprise.deployment.backend.deployment_not_dir_or_archive");
            throw new IASDeploymentException(string);
        }
    }

    private void setDirsUnDeploy() throws IASDeploymentException {
        try {
            if (!this.isRegistered()) {
                String string = localStrings.getString("enterprise.deployment.backend.undeploy_error_module_not_registered");
                throw new IASDeploymentException(string);
            }
            this.moduleDir = new File(this.modulesMgr.getLocation(this.moduleName));
            this.stubsDir = null;
            this.jspDir = null;
            if (this.needsStubs()) {
                this.stubsDir = new File(this.modulesMgr.getStubLocation(this.moduleName));
            }
            if (this.needsJSPs()) {
                if (!$assertionsDisabled && !(this.modulesMgr instanceof WebModulesManager)) {
                    throw new AssertionError();
                }
                WebModulesManager webModulesManager = (WebModulesManager)this.modulesMgr;
                this.jspDir = new File(webModulesManager.getJSPLocation(this.moduleName));
            }
        }
        catch (ConfigException configException) {
            String string = localStrings.getString("enterprise.deployment.backend.error_getting_module_directory", configException);
            throw new IASDeploymentException(string);
        }
    }

    private void setDirsReDeploy() throws IASDeploymentException {
        Object object;
        if (!this.isRegistered()) {
            String string = localStrings.getString("enterprise.deployment.backend.redeploy_error_module_not_registered");
            throw new IASDeploymentException(string);
        }
        this.stubsDir = null;
        this.jspDir = null;
        if (this.needsStubs()) {
            this.stubsDir = new File(this.modulesMgr.getStubLocation(this.moduleName));
        }
        if (this.needsJSPs()) {
            if (!$assertionsDisabled && !(this.modulesMgr instanceof WebModulesManager)) {
                throw new AssertionError();
            }
            object = (WebModulesManager)this.modulesMgr;
            this.jspDir = new File(((WebModulesManager)object).getJSPLocation(this.moduleName));
        }
        if (this.isArchive()) {
            try {
                this.oldModuleDir = new File(this.modulesMgr.getLocation(this.moduleName));
            }
            catch (ConfigException configException) {
                String string = localStrings.getString("enterprise.deployment.backend.modulesmanager_error_getting_module_location", this.moduleName);
                throw new IASDeploymentException(string, configException);
            }
            if (!FileUtils.safeIsDirectory(this.oldModuleDir)) {
                this.moduleDir = this.oldModuleDir;
                this.oldModuleDir = new File(this.moduleEnv.getModuleBackupPath());
                if (FileUtils.safeIsDirectory(this.oldModuleDir)) {
                    this.logger.fine("Module Archive Redploy: module must have been previously deployed as a directory.  Using the directory-deployment backup as the \"old-dirs\"");
                } else {
                    this.oldModuleDir = null;
                }
                this.logger.warning("Redeployment original directory doesn't exist: " + this.moduleDir.getPath());
            } else {
                object = new File(this.getInstanceEnv().getModuleRepositoryPath());
                DirNameManager dirNameManager = new DirNameManager((File)object, this.oldModuleDir, this.moduleName);
                this.moduleDir = dirNameManager.getNewDir();
            }
        } else if (this.isDirectory()) {
            object = this.request.getFileSource();
            if (!((FileSource)object).exists()) {
                String string = localStrings.getString("enterprise.deployment.backend.file_source_does_not_exist", object);
                throw new IASDeploymentException(string);
            }
            if (!$assertionsDisabled && !((FileSource)object).isDirectory()) {
                throw new AssertionError();
            }
            this.moduleDir = ((FileSource)object).getFile();
            this.oldModuleDir = new File(this.moduleEnv.getModuleBackupPath());
            if (!FileUtils.safeIsDirectory(this.oldModuleDir)) {
                this.oldModuleDir = null;
            }
        } else {
            object = localStrings.getString("enterprise.deployment.backend.redeployment_not_dir_or_archive");
            throw new IASDeploymentException((String)object);
        }
        this.moduleDir.mkdirs();
    }

    protected void liquidate() throws IASDeploymentException, ConfigException {
        if (!$assertionsDisabled && this.request.isReDeploy()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.moduleDir == null) {
            throw new AssertionError();
        }
        try {
            File file = new File(this.moduleEnv.getModuleBackupPath());
            if (FileUtils.safeIsDirectory(file)) {
                this.logger.finer("Deleting BackupDir: " + FileUtils.safeGetCanonicalPath(file) + ", isDir: " + FileUtils.safeIsDirectory(file));
                FileUtils.whack(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = false;
        if (this.request.isDeploy() && this.isArchive()) {
            bl = true;
        } else if (this.request.isUnDeploy() && this.getInstanceEnv().isIASOwned(this.moduleDir)) {
            bl = true;
        }
        if (bl) {
            if (FileUtils.safeIsDirectory(this.moduleDir)) {
                FileUtils.whack(this.moduleDir);
                this.logger.fine("Deleted module Directory: " + this.moduleDir.getPath());
            } else {
                this.logger.warning("Can't delete module Directory -- it isn't a directory: " + FileUtils.safeGetCanonicalPath(this.moduleDir));
            }
        } else {
            this.logger.fine("Did NOT delete module Directory (Directory-Deployment): " + this.moduleDir.getPath());
        }
        this.DeleteOrKeepFailedStubs(this.stubsDir);
        if (FileUtils.safeIsDirectory(this.jspDir)) {
            FileUtils.whack(this.jspDir);
        }
    }

    void redeployRegister() throws IASDeploymentException {
        if (!$assertionsDisabled && !this.request.isReDeploy()) {
            throw new AssertionError();
        }
        try {
            this.oldRegisteredLocation = this.modulesMgr.getLocation(this.moduleName);
            String string = this.moduleDir.getAbsolutePath();
            if (!this.oldRegisteredLocation.equals(string)) {
                this.modulesMgr.setLocation(this.moduleName, string);
                this.saveColdConfig();
                this.locationChangeWasRegisteredCold = true;
            }
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception);
        }
    }

    void rollbackRedeployRegister() {
        block4: {
            try {
                if (!$assertionsDisabled && !this.request.isReDeploy()) {
                    throw new AssertionError();
                }
                if (!this.locationChangeWasRegisteredCold || this.oldRegisteredLocation == null) break block4;
                this.modulesMgr.setLocation(this.moduleName, this.oldRegisteredLocation);
                if (this.locationChangeWasRegisteredHot) {
                    this.saveHotConfig();
                    break block4;
                }
                this.saveColdConfig();
            }
            catch (Throwable throwable) {
                this.logger.warning(throwable.toString());
            }
        }
    }

    void saveHotConfigRedeploy() throws IASDeploymentException {
        if (!$assertionsDisabled && !this.request.isReDeploy()) {
            throw new AssertionError();
        }
        try {
            if (this.locationChangeWasRegisteredCold) {
                this.saveHotConfig();
                this.locationChangeWasRegisteredHot = true;
            }
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception);
        }
    }

    private void undeploy() throws IASDeploymentException, ConfigException {
        if (!this.isRegistered()) {
            String string = localStrings.getString("enterprise.deployment.backend.undeploy_error_module_not_registered");
            throw new IASDeploymentException(string);
        }
        try {
            this.unregister();
            this.saveColdConfig();
        }
        catch (ConfigException configException) {
            String string = localStrings.getString("enterprise.deployment.backend.config_exception_on_remove", this.moduleName, configException);
            throw new IASDeploymentException(string, configException);
        }
    }

    private void rollbackUndeploy() throws ConfigException {
    }

    protected void postDeploy() throws IASDeploymentException, ConfigException {
        if (this.moduleInfo != null && this.isRegistered()) {
            Properties properties = this.request.getOptionalAttributes();
            if (properties != null) {
                this.modulesMgr.setOptionalAttributes(this.moduleName, properties);
            } else {
                this.setEnable(true);
            }
        } else {
            String string = localStrings.getString("enterprise.deployment.backend.module_not_registered");
            throw new IASDeploymentException(string);
        }
        this.saveColdConfig();
        this.backupFiles();
    }

    protected void updateOptionalParamForRedeploy() throws IASDeploymentException, ConfigException {
        if (this.moduleInfo != null && this.isRegistered()) {
            Properties properties = this.request.getOptionalAttributes();
            if (properties != null) {
                this.modulesMgr.setOptionalAttributes(this.moduleName, properties);
            } else {
                this.setEnable(true);
            }
            this.saveColdConfig();
        }
    }

    protected final void rollbackDeploy() throws IASDeploymentException {
        try {
            if (this.wasRegisteredThisSession) {
                this.unregister();
            }
            this.liquidate();
        }
        catch (ConfigException configException) {}
    }

    protected final void redeploy() throws IASDeploymentException, ConfigException {
        this.deploy();
    }

    private void rollback() {
        try {
            if (this.request.isDeploy()) {
                this.rollbackDeploy();
            } else if (this.request.isReDeploy()) {
                this.rollbackRedeploy();
            } else if (this.request.isUnDeploy()) {
                this.rollbackUndeploy();
            }
        }
        catch (Throwable throwable) {}
    }

    protected void register() throws IASDeploymentException, ConfigException {
        if (this.moduleInfo == null) {
            String string = localStrings.getString("enterprise.deployment.backend.null_moduleinfo");
            throw new IASDeploymentException(string);
        }
        this.modulesMgr.register(this.moduleInfo);
        this.wasRegisteredThisSession = true;
    }

    protected void createClientJar(ZipItem[] zipItemArray) throws IASDeploymentException {
        try {
            if (this.request.isDirectory()) {
                ClientJarMaker clientJarMaker = new ClientJarMaker(this.request.getFileSource().getFile(), this.clientJar);
                clientJarMaker.createModuleClient(zipItemArray);
            } else {
                File file = this.request.getFileSource().getFile();
                ClientJarArchivist clientJarArchivist = new ClientJarArchivist(file, this.clientJar);
                clientJarArchivist.createClientJar(zipItemArray);
            }
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception);
        }
    }

    protected void liquidateModuleDirAndStubsDirIfTheyHappenToExist() throws IASDeploymentException {
        if (this.request.isArchive() && FileUtils.safeIsDirectory(this.moduleDir)) {
            FileUtils.whack(this.moduleDir);
        }
        if (FileUtils.safeIsDirectory(this.stubsDir)) {
            FileUtils.whack(this.stubsDir);
        }
        if (FileUtils.safeIsDirectory(this.jspDir)) {
            FileUtils.whack(this.jspDir);
        }
    }

    protected void setOldDirs() throws IASDeploymentException {
        if (!$assertionsDisabled && this.moduleDir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.moduleEnv == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.request.isReDeploy()) {
            throw new AssertionError();
        }
        if (this.needsStubs() && this.stubsDir != null && this.stubsDir.exists() && this.stubsDir.isDirectory()) {
            this.oldStubsDir = new File(this.stubsDir.getPath() + "_old");
            if (this.oldStubsDir.exists()) {
                if (this.oldStubsDir.isDirectory()) {
                    FileUtils.whack(this.oldStubsDir);
                } else {
                    this.oldStubsDir.delete();
                }
            }
            if (!this.stubsDir.renameTo(this.oldStubsDir)) {
                String string = localStrings.getString("enterprise.deployment.backend.directory_rename_error", this.stubsDir.getPath(), this.oldStubsDir.getPath());
                throw new IASDeploymentException(string);
            }
        }
        if (this.needsJSPs() && FileUtils.safeIsDirectory(this.jspDir)) {
            this.oldJSPDir = new File(this.jspDir.getPath() + "_old");
            if (this.oldJSPDir.exists()) {
                if (this.oldJSPDir.isDirectory()) {
                    FileUtils.whack(this.oldJSPDir);
                } else {
                    this.oldJSPDir.delete();
                }
            }
            if (!this.jspDir.renameTo(this.oldJSPDir)) {
                String string = localStrings.getString("enterprise.deployment.backend.directory_rename_error", this.jspDir.getPath(), this.oldJSPDir.getPath());
                throw new IASDeploymentException(string);
            }
        }
    }

    protected boolean isRegistered() {
        return this.modulesMgr.isRegistered(this.moduleName);
    }

    protected void setShared(boolean bl) throws ConfigException {
    }

    protected void setEnable(boolean bl) throws ConfigException {
        this.modulesMgr.setEnable(this.moduleName, bl);
    }

    protected boolean isEnabled() throws ConfigException {
        return this.modulesMgr.isEnabled(this.moduleName);
    }

    protected void unregister() throws ConfigException {
        this.modulesMgr.remove(this.moduleName);
    }

    protected void saveColdConfig() throws ConfigException {
        this.modulesMgr.saveConfigContext();
    }

    protected void saveHotConfig() throws ConfigException {
        this.modulesMgr.applyServerXmlChanges();
    }

    protected void setContextRoot(String string) throws IASDeploymentException, ConfigException {
        if (!$assertionsDisabled && !this.request.isWebModule()) {
            throw new AssertionError((Object)"setContextRoot called on a non-web-module");
        }
        if (string == null) {
            String string2 = localStrings.getString("enterprise.deployment.backend.null_context_root");
            throw new IASDeploymentException(string2);
        }
        this.modulesMgr.setContextRoot(this.moduleName, string);
    }

    protected final void backupFiles() throws IASDeploymentException {
        if (this.request.isArchive()) {
            return;
        }
        File file = new File(this.moduleEnv.getModuleBackupPath());
        try {
            FileUtils.whack(file);
            FileUtils.copyTree(this.moduleDir, file);
        }
        catch (IOException iOException) {
            String string = localStrings.getString("enterprise.deployment.backend.error_making_module_backup", file.getPath());
            throw new IASDeploymentException(string);
        }
    }

    private void setDeployCommand() throws IASDeploymentException {
        boolean bl = this.isRegistered();
        if (this.request.isUnDeploy()) {
            if (!bl) {
                String string = localStrings.getString("enterprise.deployment.backend.undeploy_error_module_not_registered");
                throw new IASDeploymentException(string);
            }
        } else if (this.request.isDeploy() && bl) {
            if (this.request.isForced()) {
                this.request.setCommand(DeploymentCommand.REDEPLOY);
            } else {
                String string = localStrings.getString("enterprise.deployment.backend.deploy_error_module_exists");
                throw new IASDeploymentException(string);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$deployment$backend$ModuleDeployer == null ? (class$com$iplanet$ias$deployment$backend$ModuleDeployer = ModuleDeployer.class$("com.iplanet.ias.deployment.backend.ModuleDeployer")) : class$com$iplanet$ias$deployment$backend$ModuleDeployer).desiredAssertionStatus();
        localStrings = StringManager.getManager(class$com$iplanet$ias$deployment$backend$ModuleDeployer == null ? (class$com$iplanet$ias$deployment$backend$ModuleDeployer = ModuleDeployer.class$("com.iplanet.ias.deployment.backend.ModuleDeployer")) : class$com$iplanet$ias$deployment$backend$ModuleDeployer);
    }
}

