/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.admin.verifier.tests.StaticTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.WebModule;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebModuleTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext configContext) {
        Result result = super.getInitializedResult();
        try {
            Server server = (Server)configContext.getRootConfigBean();
            result.passed("Test Passed : ");
            Applications applications = server.getApplications();
            WebModule[] webModuleArray = applications.getWebModule();
            int n = 0;
            while (n < webModuleArray.length) {
                File file = new File(webModuleArray[n].getLocation());
                try {
                    if (file.exists()) {
                        result.passed("Test Passed ****");
                    } else {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidDir", "Web Module location directory for " + webModuleArray[n].getName() + " is not valid", new Object[]{webModuleArray[n].getName()}));
                    }
                }
                catch (SecurityException securityException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".SecurityManagerExist", "Security Manager Exists, not possible to access Web Module location"));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
            result.failed("Exception : " + exception.getMessage());
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Result result;
        block5: {
            Object object = configContextEvent.getObject();
            result = new Result();
            String string = configContextEvent.getBeanName();
            if (string != null) {
                String string2 = configContextEvent.getName();
                return this.testSave(string2, (String)object);
            }
            WebModule webModule = (WebModule)object;
            String string3 = webModule.getName();
            if (!StaticTest.checkObjectName(string3, result)) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidWebModule", "Web Module Name Invalid"));
                return result;
            }
            result.passed(this.smh.getLocalString(this.getClass().getName() + ".validObj", "Valid Object Name"));
            String string4 = webModule.getLocation();
            File file = new File(string4);
            try {
                if (file.exists()) {
                    result.passed("Test Passed ****");
                    break block5;
                }
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidDir1", "Web Module location directory is not valid"));
            }
            catch (SecurityException securityException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".SecurityManagerExist", "Security Manager Exists, not possible to access Web Module location"));
            }
        }
        return result;
    }

    public Result testSave(String string, String string2) {
        Result result = new Result();
        result.passed("Passed **");
        if (string.equals(ServerTags.LOCATION)) {
            File file = new File(string2);
            try {
                if (file.exists()) {
                    result.passed("Test Passed ****");
                } else {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidDir1", "Web Module location directory is not valid"));
                }
            }
            catch (SecurityException securityException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".SecurityManagerExist", "Security Manager Exists, not possible to access Web Module location"));
            }
            return result;
        }
        return result;
    }
}

