/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.TransactionService;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransactionServiceTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext configContext) {
        Result result = super.getInitializedResult();
        try {
            String string;
            Object object;
            Server server = (Server)configContext.getRootConfigBean();
            TransactionService transactionService = server.getTransactionService();
            String string2 = transactionService.getTxLogDir();
            if (string2 == null || string2.equals("")) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".nullFileName", "File Name cannot be Null"));
            } else {
                object = new File(string2);
                if (((File)object).exists()) {
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".validLog", "Transaction Log Dir valid"));
                } else {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidLog", "Invalid Transaction Log Directory - " + string2, new Object[]{string2}));
                }
            }
            object = transactionService.getHeuristicDecision();
            if (((String)object).equals("rollback") || ((String)object).equals("commit")) {
                result.passed(this.smh.getLocalString(this.getClass().getName() + ".validHeurisitic", "Heurisitic Decision Valid"));
            } else {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidHeurisitic", "Invalid Heuristic Decision - " + (String)object, new Object[]{object}));
            }
            try {
                string = transactionService.getTimeoutInSeconds();
                if (Integer.parseInt(string) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".resTimeoutNegative", "Response Timeout cannot be negative number"));
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".resTimeoutInvalid", "Response Timeout : invalid number"));
            }
            try {
                string = transactionService.getKeypointInterval();
                if (Integer.parseInt(string) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".keyPointNegative", "Key Point Interval cannot be negative number"));
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".keyPointInvalid", "Key Point Interval : invalid number"));
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
            result.failed("Exception : " + exception.getMessage());
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Result result = new Result();
        Object object = configContextEvent.getObject();
        String string = configContextEvent.getBeanName();
        if (string != null) {
            String string2 = configContextEvent.getName();
            return this.testSave(string2, (String)object);
        }
        TransactionService transactionService = (TransactionService)object;
        String string3 = transactionService.getTxLogDir();
        if (string3 == null || string3.equals("")) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".nullFileName", "File Name cannot be Null"));
            return result;
        }
        File file = new File(transactionService.getTxLogDir());
        if (file.exists()) {
            result.passed(this.smh.getLocalString(this.getClass().getName() + ".validLog", "Transaction Log Dir valid"));
        } else {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidLog", "Invalid Transaction Log Directory - " + transactionService.getTxLogDir(), new Object[]{transactionService.getTxLogDir()}));
        }
        String string4 = transactionService.getHeuristicDecision();
        if (string4.equals("rollback") || string4.equals("commit")) {
            result.passed(this.smh.getLocalString(this.getClass().getName() + ".validHeurisitic", "Heurisitic Decision Valid"));
        } else {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidHeurisitic", "Invalid Heuristic Decision - " + string4, new Object[]{string4}));
        }
        return result;
    }

    public Result testSave(String string, String string2) {
        Result result;
        block11: {
            block14: {
                block13: {
                    block12: {
                        result = new Result();
                        result.passed("Passed **");
                        if (!string.equals(ServerTags.TX_LOG_DIR)) break block12;
                        if (string2 == null || string2.equals("")) {
                            result.failed(this.smh.getLocalString(this.getClass().getName() + ".nullFileName", "File Name cannot be Null"));
                            return result;
                        }
                        File file = new File(string2);
                        if (file.exists()) {
                            result.passed(this.smh.getLocalString(this.getClass().getName() + ".validLog", "Transaction Log Dir valid"));
                        } else {
                            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidLog", "Invalid Transaction Log Directory - " + string2, new Object[]{string2}));
                        }
                        break block11;
                    }
                    if (!string.equals(ServerTags.HEURISTIC_DECISION)) break block13;
                    if (string2.equals("rollback") || string2.equals("commit")) {
                        result.passed(this.smh.getLocalString(this.getClass().getName() + ".validHeurisitic", "Heurisitic Decision Valid"));
                    } else {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidHeurisitic", "Invalid Heuristic Decision - " + string2, new Object[]{string2}));
                    }
                    break block11;
                }
                if (!string.equals(ServerTags.TIMEOUT_IN_SECONDS)) break block14;
                try {
                    if (Integer.parseInt(string2) < 0) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".resTimeoutNegative", "Response Timeout cannot be negative number"));
                        break block11;
                    }
                    result.passed("Passed ***");
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".resTimeoutInvalid", "Response Timeout : invalid number"));
                }
                break block11;
            }
            if (!string.equals(ServerTags.KEYPOINT_INTERVAL)) break block11;
            try {
                if (Integer.parseInt(string2) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".keyPointNegative", "Key Point Interval cannot be negative number"));
                    break block11;
                }
                result.passed("Passed ***");
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".keyPointInvalid", "Key Point Interval : invalid number"));
            }
        }
        return result;
    }
}

