/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.admin.verifier.tests.StaticTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.JdbcConnectionPool;
import com.iplanet.ias.config.serverbeans.JdbcResource;
import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.config.serverbeans.Server;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdbcResourceTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext configContext) {
        Result result = super.getInitializedResult();
        try {
            Server server = (Server)configContext.getRootConfigBean();
            Resources resources = server.getResources();
            JdbcResource[] jdbcResourceArray = resources.getJdbcResource();
            JdbcConnectionPool[] jdbcConnectionPoolArray = resources.getJdbcConnectionPool();
            String string = null;
            boolean bl = false;
            int n = 0;
            while (n < jdbcResourceArray.length) {
                string = jdbcResourceArray[n].getPoolName();
                int n2 = 0;
                while (n2 < jdbcConnectionPoolArray.length) {
                    if (jdbcConnectionPoolArray[n2].getName().equals(string)) {
                        bl = true;
                    }
                    ++n2;
                }
                if (bl) {
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".valiConndPool", "Valid Connection Pool"));
                    bl = false;
                } else {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".poolNotAvailable", "Connection Pool " + string + " Not Available for jdbc resource " + jdbcResourceArray[n].getJndiName(), new Object[]{string, jdbcResourceArray[n].getJndiName()}));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
            result.failed("Exception : " + exception.getMessage());
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Result result;
        block7: {
            result = new Result();
            String string = configContextEvent.getBeanName();
            if (string != null) {
                result.passed(this.smh.getLocalString(this.getClass().getName() + ".saveImpl", "Save to be implemented"));
                return result;
            }
            ConfigContext configContext = configContextEvent.getConfigContext();
            Object object = configContextEvent.getObject();
            JdbcResource jdbcResource = (JdbcResource)object;
            boolean bl = false;
            String string2 = jdbcResource.getPoolName();
            if (!StaticTest.checkObjectName(jdbcResource.getJndiName(), result)) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidresource", "JDBC Resource Jndi Name Invalid"));
                return result;
            }
            result.passed(this.smh.getLocalString(this.getClass().getName() + ".validObj", "Valid Object Name"));
            try {
                Server server = (Server)configContext.getRootConfigBean();
                Resources resources = server.getResources();
                JdbcConnectionPool[] jdbcConnectionPoolArray = resources.getJdbcConnectionPool();
                int n = 0;
                while (n < jdbcConnectionPoolArray.length) {
                    if (jdbcConnectionPoolArray[n].getName().equals(string2)) {
                        bl = true;
                    }
                    ++n;
                }
                if (bl) {
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".valiConndPool", "Valid Connection Pool"));
                    break block7;
                }
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".poolNotAvail", "Connection Pool Not Available"));
            }
            catch (Exception exception) {
                _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
                result.failed("Exception : " + exception.getMessage());
            }
        }
        return result;
    }
}

