/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.VirtualServer;
import com.iplanet.ias.admin.servermodel.beans.VirtualServerClass;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;

public class DeleteVirtualServerCommand
extends BaseOtherCommand {
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            VirtualServer virtualServer;
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            String string = ((Operand)this.getOperands().get(0)).getName();
            AppServerInstance appServerInstance = serverInstanceManager.getServerInstance(this.getInstanceOption());
            HttpServiceComponentBean httpServiceComponentBean = appServerInstance.getHttpService();
            VirtualServerClass virtualServerClass = httpServiceComponentBean.getVirtualServerClass("defaultclass");
            ServerModelIterator serverModelIterator = virtualServerClass.getVirtualServers();
            if (serverModelIterator.hasNext() && (virtualServer = (VirtualServer)serverModelIterator.next()).getDisplayName().equals(string) && !serverModelIterator.hasNext()) {
                throw new CommandException(this.getLocalizedString("CannotDeleteAllVirtualServers", new Object[]{string}));
            }
            virtualServerClass.removeVirtualServer(string);
            this.printMessage(this.getLocalizedString("DeletedVirtualServer", new Object[]{string}));
            Debug.println(this.getClass().getName() + " : Command executed");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotDeleteVirtualServer"));
            throw new CommandException(exception.getLocalizedMessage());
        }
    }

    private String getVirtualServerClassOption() {
        Option option = this.findOption("virtualserverclass");
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        return string;
    }
}

