/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.HttpListener;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.IiopListener;
import com.iplanet.ias.admin.servermodel.beans.ORBComponentBean;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;

public class DeleteSSLCommand
extends BaseOtherCommand {
    private static final String HTTP_LISTENER = "http-listener";
    private static final String IIOP_LISTENER = "iiop-listener";
    private static final String IIOP_SERVICE = "iiop-service";

    public boolean validateOptions() throws CommandValidationException {
        if (!super.validateOptions()) {
            return false;
        }
        Option option = this.findOption("type");
        if (option != null && option.getValue().equals("all")) {
            throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{option.getName()}));
        }
        String string = option.getValue();
        if (!(string.equals(HTTP_LISTENER) || string.equals(IIOP_LISTENER) || string.equals(IIOP_SERVICE))) {
            throw new CommandValidationException(this.getLocalizedString("InvalidListenerType"));
        }
        if (string.equals(HTTP_LISTENER) || string.equals(IIOP_LISTENER) ? this.getOperands().size() != 1 : string.equals(IIOP_SERVICE) && this.getOperands().size() != 0) {
            throw new CommandValidationException(this.getLocalizedString("InvalidNumberOfOperands"));
        }
        return true;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        Object object;
        if (!this.validateOptions()) {
            return;
        }
        AppServerInstance appServerInstance = null;
        try {
            object = this.getServerInstanceManager();
            appServerInstance = ((ServerInstanceManager)object).getServerInstance(this.getInstanceOption());
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotDeleteSSL"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        object = this.findOption("type").getValue();
        if (((String)object).equals(HTTP_LISTENER)) {
            String string = ((Operand)this.getOperands().get(0)).getName();
            try {
                HttpServiceComponentBean httpServiceComponentBean = appServerInstance.getHttpService();
                HttpListener httpListener = httpServiceComponentBean.getHttpListener(string);
                if (!httpListener.isSSLCreated()) {
                    throw new CommandException(this.getLocalizedString("SSLDoesNotExist"));
                }
                httpListener.deleteSSL();
                this.printMessage(this.getLocalizedString("DeletedSSLInHTTPListener"));
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                this.printError(this.getLocalizedString("CannotDeleteSSLInHTTPListener"));
                throw new CommandException(exception.getLocalizedMessage());
            }
        }
        if (((String)object).equals(IIOP_LISTENER)) {
            String string = ((Operand)this.getOperands().get(0)).getName();
            try {
                ORBComponentBean oRBComponentBean = appServerInstance.getORBComponent();
                IiopListener iiopListener = oRBComponentBean.getIiopListener(string);
                if (!iiopListener.isSSLCreated()) {
                    throw new CommandException(this.getLocalizedString("SSLDoesNotExist"));
                }
                iiopListener.deleteSSL();
                this.printMessage(this.getLocalizedString("DeletedSSLInIIOPListener"));
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                this.printError(this.getLocalizedString("CannotDeleteSSLInIIOPListener"));
                throw new CommandException(exception.getLocalizedMessage());
            }
        }
        if (((String)object).equals(IIOP_SERVICE)) {
            try {
                ORBComponentBean oRBComponentBean = appServerInstance.getORBComponent();
                if (!oRBComponentBean.isSSLCreated()) {
                    throw new CommandException(this.getLocalizedString("SSLDoesNotExist"));
                }
                oRBComponentBean.deleteSSL();
                this.printMessage(this.getLocalizedString("DeletedSSLInIIOPService"));
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                this.printError(this.getLocalizedString("CannotDeleteSSLInIIOPService"));
                throw new CommandException(exception.getLocalizedMessage());
            }
        }
    }
}

