/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.installer.core.ServerConfig;
import com.iplanet.ias.installer.core.installConfig;
import com.iplanet.ias.license.IASLicense;
import com.iplanet.ias.tools.cli.BaseLifeCycleCommand;
import com.iplanet.ias.tools.cli.IasCommand;
import com.iplanet.ias.tools.cli.PromptStream;
import com.iplanet.ias.tools.cli.framework.CliUtil;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.net.NetUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class CreateDomainCommand
extends BaseLifeCycleCommand {
    private static final String DOMAIN_PATH = "path";
    private static final String SYS_USER = "sysuser";
    private static final String ADMIN_PORT = "adminport";
    private static final String ADMIN_USER = "adminuser";
    private static final String ADMIN_PASSWD = "adminpassword";
    private static final String ADMIN_ID = "admin-server";
    private static final String DOCROOT = "docroot";

    public CreateDomainCommand() {
    }

    public CreateDomainCommand(String string) {
        this.setName(string);
    }

    public boolean validateOptions() throws CommandValidationException {
        Object object;
        Object object2;
        Object object3;
        if (!super.validateOptions()) {
            return false;
        }
        int n = this.convertPortStr(this.getOptionValue(ADMIN_PORT));
        if (!NetUtils.isPortFree((int)n)) {
            throw new CommandValidationException(this.getLocalizedString("AdminPortInUse"));
        }
        String string = this.getOptionValue(ADMIN_PASSWD);
        if (string == null) {
            if (this.isInteractive()) {
                try {
                    object3 = new CliUtil();
                    this.printPrompt(ADMIN_PASSWD);
                    string = ((CliUtil)object3).getPassword();
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    String string2 = unsatisfiedLinkError.getLocalizedMessage();
                    if (string2 != null) {
                        Debug.println(string2);
                    }
                    object2 = new PromptStream(System.in, System.out);
                    string = ((PromptStream)object2).readln(ADMIN_PASSWD);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    object2 = noClassDefFoundError.getLocalizedMessage();
                    if (object2 != null) {
                        Debug.println(object2);
                    }
                    object = new PromptStream(System.in, System.out);
                    string = ((PromptStream)object).readln(ADMIN_PASSWD);
                }
                this.removeOption(ADMIN_PASSWD);
                this.addOption(new Option(ADMIN_PASSWD, string));
            } else {
                throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{ADMIN_PASSWD}));
            }
        }
        if (string.length() < 8) {
            object3 = this.getLocalizedString("InvalidAdminPassword");
            if (this.isInteractive()) {
                int n2 = 1;
                while (string.length() < 8) {
                    Object object4;
                    if (n2 > 3) {
                        throw new CommandValidationException((String)object3);
                    }
                    this.printMessage(object3);
                    try {
                        object2 = new CliUtil();
                        this.printPrompt(ADMIN_PASSWD);
                        string = ((CliUtil)object2).getPassword();
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        object = unsatisfiedLinkError.getLocalizedMessage();
                        if (object != null) {
                            Debug.println(object);
                        }
                        object4 = new PromptStream(System.in, System.out);
                        string = ((PromptStream)object4).readln(ADMIN_PASSWD);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        object4 = noClassDefFoundError.getLocalizedMessage();
                        if (object4 != null) {
                            Debug.println(object4);
                        }
                        PromptStream promptStream = new PromptStream(System.in, System.out);
                        string = promptStream.readln(ADMIN_PASSWD);
                    }
                    ++n2;
                }
                this.removeOption(ADMIN_PASSWD);
                this.addOption(new Option(ADMIN_PASSWD, string));
            } else {
                throw new CommandValidationException((String)object3);
            }
        }
        return true;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        String string = ((Operand)this.operands.get(0)).getName();
        try {
            Object object;
            IasCommand.exceptionIfShellChar(string);
            this.unsetLicenseLogger();
            IASLicense.checkCurrent((boolean)false);
            String string2 = this.getOptionValue(DOMAIN_PATH);
            if (string2 == null && (string2 = System.getProperty("com.sun.aas.domainsRoot")) == null) {
                throw new CommandException(this.getLocalizedString("InvalidDomainPath"));
            }
            ServerConfig serverConfig = new ServerConfig();
            String string3 = System.getProperty("com.sun.aas.configRoot");
            String string4 = this.getOptionValue(SYS_USER);
            int n = this.convertPortStr(this.getOptionValue(ADMIN_PORT));
            String string5 = this.getOptionValue(ADMIN_USER);
            String string6 = this.getOptionValue(ADMIN_PASSWD);
            File file = new File(System.getProperty("com.sun.aas.installRoot"));
            File file2 = new File(System.getProperty("com.sun.aas.javaRoot"));
            File file3 = new File(string2, string);
            String[] stringArray = new String[]{ADMIN_ID, DOCROOT};
            File file4 = new File(file3, StringUtils.makeFilePath(stringArray, false));
            File file5 = new File(System.getProperty("com.sun.aas.imqBin"));
            File file6 = new File(System.getProperty("com.sun.aas.imqLib"));
            serverConfig.configRoot = string3;
            serverConfig.serverRoot = FileUtils.makeForwardSlashes(file.getAbsolutePath());
            serverConfig.serverID = serverConfig.serverName = this.createLocalHostName();
            serverConfig.serverUser = string4 != null ? string4 : System.getProperty("user.name");
            serverConfig.domainName = string;
            serverConfig.domainRoot = FileUtils.makeForwardSlashes(file3.getAbsolutePath());
            serverConfig.serverPort = n;
            serverConfig.adminName = string5;
            serverConfig.adminPasswd = string6;
            serverConfig.docRoot = FileUtils.makeForwardSlashes(file4.getAbsolutePath());
            serverConfig.javaHome = FileUtils.makeForwardSlashes(file2.getAbsolutePath());
            serverConfig.jmsPort = NetUtils.getFreePort();
            serverConfig.orbListenerPort = NetUtils.getFreePort();
            serverConfig.imqBin = FileUtils.makeForwardSlashes(file5.getAbsolutePath());
            serverConfig.imqLib = FileUtils.makeForwardSlashes(file6.getAbsolutePath());
            if (string2 != null && !((File)(object = new File(string2))).exists()) {
                boolean bl = false;
                try {
                    bl = ((File)object).mkdirs();
                }
                catch (Exception exception) {
                    Debug.printStackTrace(exception);
                    throw new CommandException(this.getLocalizedString("MkdirFailed", new Object[]{string2}));
                }
                if (!bl) {
                    throw new CommandException(this.getLocalizedString("MkdirFailed", new Object[]{string2}));
                }
            }
            object = new installConfig();
            String string7 = object.createDomain(serverConfig);
            Debug.println("Error in create-domain: " + string7);
            if (string7 != null) {
                throw new CommandException(string7);
            }
            this.printMessage(this.getLocalizedString("DomainCreated", new Object[]{string}));
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printMessage(this.getLocalizedString("CannotCreateDomain", new Object[]{string}));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private int convertPortStr(String string) throws CommandValidationException {
        int n = 0;
        try {
            Debug.println("Port = '" + string + "'");
            n = Integer.parseInt(string);
            return n;
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            throw new CommandValidationException(this.getLocalizedString("InvalidPortNumber"));
        }
    }

    private String createLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }
}

