/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.IasCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Option;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;

public abstract class BaseResourceCommand
extends IasCommand {
    protected static final String SHORTHAND_DELIMETER = ":";
    protected static final char ESCAPE_CHAR = '\\';
    protected static final String APPEND_WITH_DELIMETER = ".";
    protected static final String QUOTE_CHAR = "\"";
    protected static final String SET_DELIMETER = "=";

    protected Properties getProperties() throws CommandValidationException {
        String string;
        String string2;
        Option option = this.findOption("property");
        Properties properties = new Properties();
        if (option == null) {
            return properties;
        }
        String string3 = option.getValue();
        if (this.isShorthandNotation(string3, 0)) {
            this.getPropertiesFromShorthandNotation(properties, string3);
        } else {
            int n = this.getSinglePropertyValueIndex(string3);
            if (n == -1) {
                throw new CommandValidationException(this.getLocalizedString("NoValueForProperty"));
            }
            string2 = string3.substring(0, n);
            if (string2.indexOf(92) != -1 || string2.indexOf(SET_DELIMETER) != -1) {
                throw new CommandValidationException(this.getLocalizedString("InvalidPropertyName"));
            }
            if (string3.length() <= n) {
                throw new CommandValidationException(this.getLocalizedString("InvalidAttributeSyntax"));
            }
            string = string3.substring(n + 1);
            string = this.removeEscapeChars(string);
            properties.put(string2, string);
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string = (String)properties.get(string2);
            Debug.println("Property(name,value) = " + string2 + " , " + string);
        }
        return properties;
    }

    protected int getSinglePropertyValueIndex(String string) {
        int n = -1;
        int n2 = 0;
        boolean bl = false;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\"') {
                if ((n2 = string.indexOf(34, n2 + 1)) == -1) {
                    return n2;
                }
                if (string.length() == n2) {
                    return -1;
                }
            } else if (string.charAt(n2) == '=' && string.charAt(n2 - 1) != '\\') {
                if (n2 == 0) {
                    return -1;
                }
                return n2;
            }
            ++n2;
        }
        return n2;
    }

    protected void getPropertiesFromShorthandNotation(Properties properties, String string) throws CommandValidationException {
        if (!this.isShorthandNotation(string, 0)) {
            return;
        }
        int n = 0;
        String string2 = string;
        while (string2.length() > 0) {
            String string3;
            n = this.getDelimeterIndex(string2, SHORTHAND_DELIMETER, 0);
            if (n == -1) {
                int n2 = string2.indexOf(SET_DELIMETER);
                if (n2 == -1) {
                    throw new CommandValidationException(this.getLocalizedString("InvalidShorthandNotationForProperty"));
                }
                String string4 = string2.substring(n2 + 1);
                string4 = this.removeEscapeChars(string4);
                string3 = string2.substring(0, n2);
                if (string3.indexOf(92) != -1 || string3.indexOf(SET_DELIMETER) != -1) {
                    throw new CommandValidationException(this.getLocalizedString("InvalidPropertyName"));
                }
                properties.put(string3, string4);
                break;
            }
            String string5 = string2.substring(0, n);
            if (n + 1 >= string2.length()) {
                throw new CommandValidationException(this.getLocalizedString("InvalidShorthandNotationForProperty"));
            }
            string2 = string2.substring(n + 1);
            int n3 = string5.indexOf(SET_DELIMETER);
            if (n3 == -1) {
                throw new CommandValidationException(this.getLocalizedString("InvalidShorthandNotationForProperty"));
            }
            string3 = string5.substring(n3 + 1);
            string3 = this.removeEscapeChars(string3);
            String string6 = string5.substring(0, n3);
            if (string6.indexOf(92) != -1 || string6.indexOf(SET_DELIMETER) != -1) {
                throw new CommandValidationException(this.getLocalizedString("InvalidPropertyName"));
            }
            properties.put(string6, string3);
        }
    }

    protected String removeEscapeChars(String string) throws CommandValidationException {
        int n = 0;
        String string2 = string;
        String string3 = "";
        while (n < string2.length()) {
            int n2 = this.getDelimeterIndex(string2, String.valueOf('\\'), n);
            if (n2 == -1) {
                string3 = string3 + string2.substring(n);
                break;
            }
            string3 = string3 + string2.substring(n, n2);
            n = n2 + 1;
        }
        return string3;
    }

    protected boolean isShorthandNotation(String string, int n) throws CommandValidationException {
        int n2 = this.getDelimeterIndex(string, SHORTHAND_DELIMETER, n);
        return n2 != -1;
    }

    protected int getDelimeterIndex(String string, String string2, int n) throws CommandValidationException {
        int n2 = string.indexOf(string2, n);
        int n3 = string.indexOf(QUOTE_CHAR, n);
        if (n3 != -1 && n2 != -1 && n3 < n2) {
            int n4 = string.indexOf(QUOTE_CHAR, n3 + 1);
            if (n4 == -1) {
                throw new CommandValidationException(this.getLocalizedString("UnclosedString"));
            }
            if (n4 != string.length() - 1) {
                return this.getDelimeterIndex(string, string2, n4 + 1);
            }
            return -1;
        }
        if (n2 > 0 && string.charAt(n2 - 1) == '\\') {
            return this.getDelimeterIndex(string, string2, n2 + 1);
        }
        return n2;
    }

    protected void validateAttributeList(AttributeList attributeList, AttributeList attributeList2) throws CommandException {
        if (attributeList2 != null) {
            int n = 0;
            while (n < attributeList.size()) {
                Attribute attribute = (Attribute)attributeList.get(n);
                String string = this.getAttributeValueByName(attributeList2, attribute.getName());
                if (string == null) {
                    throw new CommandException(this.getLocalizedString("CannotSetAttribute"));
                }
                if (!string.equals(attribute.getValue().toString())) {
                    throw new CommandException(this.getLocalizedString("UnableToSetAttribute", new Object[]{attribute.getName(), attribute.getValue().toString()}));
                }
                ++n;
            }
        } else {
            throw new CommandException(this.getLocalizedString("CannotSetAttribute"));
        }
    }

    private String getAttributeValueByName(AttributeList attributeList, String string) {
        int n = 0;
        while (n < attributeList.size()) {
            Attribute attribute = (Attribute)attributeList.get(n);
            if (attribute.getName().equals(string)) {
                return attribute.getValue().toString();
            }
            ++n;
        }
        return null;
    }
}

