/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.util;

import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.IStringSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesStringSource
implements IStringSource {
    private Properties mProperties;

    public PropertiesStringSource(Properties properties) {
        this.initialize(properties);
    }

    public PropertiesStringSource(InputStream inputStream) throws IOException {
        this.initialize(inputStream);
    }

    public PropertiesStringSource(File file) throws IOException {
        this.initialize(file);
    }

    public PropertiesStringSource(String string) throws IOException {
        this.initialize(string);
    }

    public String getString(String string) {
        Assert.assertit(this.mProperties != null, "invalid state:  mProperties is null");
        return this.mProperties.getProperty(string);
    }

    protected PropertiesStringSource() {
    }

    protected void initialize(Properties properties) {
        this.mProperties = properties;
    }

    protected void initialize(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.initialize(fileInputStream);
    }

    protected void initialize(String string) throws IOException {
        this.initialize(new File(string));
    }

    protected void initialize(InputStream inputStream) throws IOException {
        this.mProperties = new Properties();
        this.mProperties.load(inputStream);
    }
}

