/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.JVMComponentBean;
import com.iplanet.ias.admin.servermodel.beans.Profiler;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.StringValidator;
import javax.management.ObjectName;

public class JVMComponentController
implements Controller {
    private static final String GET_JVM_OPTIONS = "getJvmOptions";
    private static final String SET_JVM_OPTIONS = "setJvmOptions";
    private static final String CREATE_PROFILER = "createProfiler";
    private static final String DELETE_PROFILER = "deleteProfiler";
    private static final String PROFILER_EXISTS = "isProfilerExist";
    private static final String GET_PROFILER = "getProfiler";
    private JVMComponentBean jvm;

    public JVMComponentController(JVMComponentBean jVMComponentBean) {
        this.jvm = jVMComponentBean;
    }

    public String[] getJvmOptions() throws AFException {
        String[] stringArray = (String[])this.invoke(GET_JVM_OPTIONS, null, null);
        return stringArray;
    }

    public void setJvmOptions(String[] stringArray) throws AFException {
        ArgChecker.checkValid(stringArray, "options");
        String[] stringArray2 = new String[]{stringArray.getClass().getName()};
        Object[] objectArray = new Object[]{stringArray};
        this.invoke(SET_JVM_OPTIONS, objectArray, stringArray2);
    }

    public void createProfiler(String string) throws AFException {
        ArgChecker.checkValid(string, "name", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Boolean"};
        Object[] objectArray = new Object[]{string, null, null, null};
        this.invoke(CREATE_PROFILER, objectArray, stringArray);
    }

    public boolean isProfilerExists() throws AFException {
        Object var1_1 = null;
        Boolean bl = (Boolean)this.invoke(PROFILER_EXISTS, null, null);
        Assert.assertit(bl != null, "null value returned");
        return bl;
    }

    public Profiler getProfiler() throws AFException {
        Profiler profiler = null;
        String string = (String)this.invoke(GET_PROFILER, null, null);
        if (string != null) {
            ObjectName objectName = ObjectNames.getProfilerObjectName(this.jvm.getInstanceName());
            Assert.assertit(objectName != null, "null value returned");
            profiler = new Profiler(objectName.toString(), string);
            profiler.setContextHolder(this.jvm.getContextHolder());
        }
        return profiler;
    }

    public void deleteProfiler() throws AFException {
        this.invoke(DELETE_PROFILER, null, null);
    }

    private Object invoke(String string, Object[] objectArray, String[] stringArray) throws AFException {
        try {
            ContextHolder contextHolder = this.jvm.getContextHolder();
            ObjectName objectName = new ObjectName(this.jvm.getIdentifier());
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            return sOMRequestDispatcher.invoke(objectName, string, objectArray, stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof AFException) {
                throw (AFException)exception;
            }
            throw new AFException(exception.getLocalizedMessage());
        }
    }
}

