/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.taglibs.cache;

import com.sun.appserv.util.cache.Cache;
import com.sun.appserv.web.taglibs.cache.CacheEntry;
import com.sun.appserv.web.taglibs.cache.CacheUtil;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.Writer;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class CacheTag
extends BodyTagSupport {
    private static final int SECOND = 1;
    private static final int MINUTE = 60;
    private static final int HOUR = 3600;
    private static final int DAY = 86400;
    private String _keyExpr;
    private String _key;
    private int _timeout = 60;
    private boolean _refreshCache = false;
    private boolean _useCachedResponse = true;
    private int _scope = 4;
    private Cache _cache;
    private static Logger _logger = null;
    private static boolean _debugLog;
    private static ResourceBundle _rb;

    public CacheTag() {
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
            _rb = _logger.getResourceBundle();
            _debugLog = _logger.isLoggable(Level.FINE);
        }
    }

    public int doStartTag() throws JspException {
        int n = 2;
        this._key = CacheUtil.generateKey(this._keyExpr, this.pageContext);
        if (_debugLog) {
            _logger.fine("CacheTag[" + this._key + "]: Timeout = " + this._timeout);
        }
        if (this._useCachedResponse) {
            CacheEntry cacheEntry;
            this._cache = CacheUtil.getCache(this.pageContext, this._scope);
            if (this._cache == null) {
                throw new JspException(_rb.getString("taglibs.cache.nocache"));
            }
            if (!this._refreshCache && (cacheEntry = (CacheEntry)this._cache.get((Object)this._key)) != null && cacheEntry.isValid()) {
                String string = cacheEntry.getContent();
                try {
                    this.pageContext.getOut().write(string);
                }
                catch (IOException iOException) {
                    throw new JspException((Throwable)iOException);
                }
                n = 0;
            }
        } else {
            n = 1;
        }
        return n;
    }

    public int doAfterBody() throws JspException {
        if (this._useCachedResponse && this.bodyContent != null) {
            String string = this.bodyContent.getString().trim();
            CacheEntry cacheEntry = new CacheEntry(string, this._timeout);
            this._cache.put((Object)this._key, (Object)cacheEntry);
            try {
                this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
            }
            catch (IOException iOException) {
                throw new JspException((Throwable)iOException);
            }
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        this._key = null;
        this._keyExpr = null;
        this._timeout = 60;
        this._refreshCache = false;
        this._useCachedResponse = true;
        this._scope = 4;
        this._cache = null;
        return 6;
    }

    public void setKey(String string) {
        if (string != null && string.length() > 0) {
            this._keyExpr = string;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setTimeout(String var1_1) {
        block10: {
            if (var1_1 == null) break block10;
            try {
                this._timeout = Integer.parseInt(var1_1);
                break block10;
            }
            catch (NumberFormatException var2_2) {
                var3_3 = 0;
                ** while (var3_3 < var1_1.length() && Character.isDigit((char)var1_1.charAt((int)var3_3)))
            }
lbl-1000:
            // 1 sources

            {
                ++var3_3;
                continue;
            }
lbl10:
            // 1 sources

            if (var3_3 > 0) {
                this._timeout = Integer.parseInt(var1_1.substring(0, var3_3));
                var4_4 = var1_1.charAt(var3_3);
                switch (var4_4) {
                    case 's': {
                        this._timeout *= 1;
                        ** break;
                    }
                    case 'm': {
                        this._timeout *= 60;
                        ** break;
                    }
                    case 'h': {
                        this._timeout *= 3600;
                        ** break;
                    }
                    case 'd': {
                        this._timeout *= 86400;
                        ** break;
                    }
                }
            }
        }
    }

    public void setNocache(boolean bl) {
        if (bl) {
            this._useCachedResponse = false;
        }
    }

    public void setRefresh(boolean bl) {
        this._refreshCache = bl;
    }

    public void setScope(String string) {
    }

    static {
        _rb = null;
    }
}

