/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Main;
import sun.rmi.rmic.iiop.ArrayType;
import sun.rmi.rmic.iiop.ClassType;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.Constants;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.Generator;
import sun.rmi.rmic.iiop.ImplementationType;
import sun.rmi.rmic.iiop.InterfaceType;
import sun.rmi.rmic.iiop.RemoteType;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.ValueType;
import sun.tools.java.ClassDefinition;
import sun.tools.java.CompilerError;
import sun.tools.java.Identifier;

public class IDLGenerator
extends Generator {
    private boolean valueMethods = true;
    private boolean factory = true;
    private Hashtable ifHash = new Hashtable();
    private Hashtable imHash = new Hashtable();
    private boolean isThrown = true;
    private boolean isException = true;
    private boolean isForward = true;
    private boolean forValuetype = true;

    protected boolean requireNewInstance() {
        return false;
    }

    protected boolean parseNonConforming(ContextStack contextStack) {
        return this.valueMethods;
    }

    protected CompoundType getTopType(ClassDefinition classDefinition, ContextStack contextStack) {
        return CompoundType.forCompound(classDefinition, contextStack);
    }

    protected Identifier getOutputId(Generator.OutputType outputType) {
        Identifier identifier = super.getOutputId(outputType);
        Type type = outputType.getType();
        String string = outputType.getName();
        if (identifier == sun.tools.java.Constants.idJavaLangClass) {
            if (type.isArray()) {
                return Identifier.lookup((String)("org.omg.boxedRMI.javax.rmi.CORBA." + string));
            }
            return Constants.idClassDesc;
        }
        if (identifier == sun.tools.java.Constants.idJavaLangString && type.isArray()) {
            return Identifier.lookup((String)("org.omg.boxedRMI.CORBA." + string));
        }
        if ("org.omg.CORBA.Object".equals(type.getQualifiedName()) && type.isArray()) {
            return Identifier.lookup((String)("org.omg.boxedRMI." + string));
        }
        if (type.isArray()) {
            ArrayType arrayType = (ArrayType)type;
            Type type2 = arrayType.getElementType();
            if (type2.isCompound()) {
                CompoundType compoundType = (CompoundType)type2;
                String string2 = compoundType.getQualifiedName();
                if (compoundType.isIDLEntity()) {
                    return Identifier.lookup((String)this.getQualifiedName(arrayType));
                }
            }
            return Identifier.lookup((Identifier)Constants.idBoxedRMI, (Identifier)identifier);
        }
        if (type.isCompound()) {
            CompoundType compoundType = (CompoundType)type;
            String string3 = compoundType.getQualifiedName();
            if (compoundType.isBoxed()) {
                return Identifier.lookup((String)this.getQualifiedName(compoundType));
            }
        }
        return identifier;
    }

    protected String getFileNameExtensionFor(Generator.OutputType outputType) {
        return ".idl";
    }

    /*
     * Unable to fully structure code
     */
    public boolean parseArgs(String[] var1_1, Main var2_2) {
        block5: {
            var3_3 = super.parseArgs(var1_1, var2_2);
            if (!var3_3) break block5;
            var6_4 = 0;
            while (var6_4 < var1_1.length) {
                block6: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            if (var1_1[var6_4] == null) break block6;
                                            if (!var1_1[var6_4].equalsIgnoreCase("-idl")) break block7;
                                            this.idl = true;
                                            var1_1[var6_4] = null;
                                            break block6;
                                        }
                                        if (!var1_1[var6_4].equalsIgnoreCase("-valueMethods")) break block8;
                                        this.valueMethods = true;
                                        var1_1[var6_4] = null;
                                        break block6;
                                    }
                                    if (!var1_1[var6_4].equalsIgnoreCase("-noValueMethods")) break block9;
                                    this.valueMethods = false;
                                    var1_1[var6_4] = null;
                                    break block6;
                                }
                                if (!var1_1[var6_4].equalsIgnoreCase("-init")) break block10;
                                this.factory = false;
                                var1_1[var6_4] = null;
                                break block6;
                            }
                            if (!var1_1[var6_4].equalsIgnoreCase("-factory")) break block11;
                            this.factory = true;
                            var1_1[var6_4] = null;
                            break block6;
                        }
                        if (!var1_1[var6_4].equalsIgnoreCase("-idlfile")) break block12;
                        var1_1[var6_4] = null;
                        if (++var6_4 >= var1_1.length || var1_1[var6_4] == null || var1_1[var6_4].startsWith("-")) ** GOTO lbl-1000
                        var4_5 = var1_1[var6_4];
                        var1_1[var6_4] = null;
                        if (++var6_4 < var1_1.length && var1_1[var6_4] != null && !var1_1[var6_4].startsWith("-")) {
                            var5_6 = var1_1[var6_4];
                            var1_1[var6_4] = null;
                            this.ifHash.put(var4_5, var5_6);
                        } else lbl-1000:
                        // 2 sources

                        {
                            var2_2.error("rmic.option.requires.argument", "-idlfile");
                            var3_3 = false;
                        }
                        break block6;
                    }
                    if (!var1_1[var6_4].equalsIgnoreCase("-idlmodule")) break block6;
                    var1_1[var6_4] = null;
                    if (++var6_4 >= var1_1.length || var1_1[var6_4] == null || var1_1[var6_4].startsWith("-")) ** GOTO lbl-1000
                    var4_5 = var1_1[var6_4];
                    var1_1[var6_4] = null;
                    if (++var6_4 < var1_1.length && var1_1[var6_4] != null && !var1_1[var6_4].startsWith("-")) {
                        var5_6 = var1_1[var6_4];
                        var1_1[var6_4] = null;
                        this.imHash.put(var4_5, var5_6);
                    } else lbl-1000:
                    // 2 sources

                    {
                        var2_2.error("rmic.option.requires.argument", "-idlmodule");
                        var3_3 = false;
                    }
                }
                ++var6_4;
            }
        }
        return var3_3;
    }

    protected Generator.OutputType[] getOutputTypesFor(CompoundType compoundType, HashSet hashSet) {
        Object object;
        Vector vector = this.getAllReferencesFor(compoundType);
        Vector<Generator.OutputType> vector2 = new Vector<Generator.OutputType>();
        int n = 0;
        while (n < vector.size()) {
            Object object2;
            object = (Type)vector.elementAt(n);
            if (object.isArray()) {
                object2 = (ArrayType)object;
                int n2 = ((ArrayType)object2).getArrayDimension();
                Type type = ((ArrayType)object2).getElementType();
                String string = this.unEsc(type.getIDLName()).replace(' ', '_');
                int n3 = 0;
                while (n3 < n2) {
                    String string2 = "seq" + (n3 + 1) + "_" + string;
                    vector2.addElement(new Generator.OutputType(string2, (Type)object2));
                    ++n3;
                }
            } else if (object.isCompound()) {
                ClassType classType;
                object2 = this.unEsc(object.getIDLName());
                vector2.addElement(new Generator.OutputType(((String)object2).replace(' ', '_'), (Type)object));
                if (object.isClass() && (classType = (ClassType)object).isException()) {
                    object2 = this.unEsc(classType.getIDLExceptionName());
                    vector2.addElement(new Generator.OutputType(((String)object2).replace(' ', '_'), (Type)object));
                }
            }
            ++n;
        }
        object = new Generator.OutputType[vector2.size()];
        vector2.copyInto((Object[])object);
        return object;
    }

    protected Vector getAllReferencesFor(CompoundType compoundType) {
        Type type;
        int n;
        Hashtable<String, CompoundType> hashtable = new Hashtable<String, CompoundType>();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        hashtable.put(compoundType.getQualifiedName(), compoundType);
        this.accumulateReferences(hashtable, hashtable2, hashtable3);
        do {
            n = hashtable.size();
            this.accumulateReferences(hashtable, hashtable2, hashtable3);
        } while (n < hashtable.size());
        Vector<Type> vector = new Vector<Type>();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            type = (CompoundType)enumeration.nextElement();
            vector.addElement(type);
        }
        enumeration = hashtable2.elements();
        while (enumeration.hasMoreElements()) {
            type = (CompoundType)enumeration.nextElement();
            vector.addElement(type);
        }
        enumeration = hashtable3.elements();
        block3: while (enumeration.hasMoreElements()) {
            type = (ArrayType)enumeration.nextElement();
            int n2 = ((ArrayType)type).getArrayDimension();
            Type type2 = ((ArrayType)type).getElementType();
            Enumeration enumeration2 = hashtable3.elements();
            while (enumeration2.hasMoreElements()) {
                ArrayType arrayType = (ArrayType)enumeration2.nextElement();
                if (type2 == arrayType.getElementType() && n2 < arrayType.getArrayDimension()) continue block3;
            }
            vector.addElement(type);
        }
        return vector;
    }

    protected void accumulateReferences(Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        Cloneable cloneable;
        Type type;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            type = (CompoundType)enumeration.nextElement();
            cloneable = this.getData((CompoundType)type);
            Vector vector = this.getMethods((CompoundType)type);
            this.getInterfaces((CompoundType)type, hashtable);
            this.getInheritance((CompoundType)type, hashtable);
            this.getMethodReferences(vector, hashtable, hashtable2, hashtable3, hashtable);
            this.getMemberReferences((Vector)cloneable, hashtable, hashtable2, hashtable3);
        }
        enumeration = hashtable3.elements();
        while (enumeration.hasMoreElements()) {
            type = (ArrayType)enumeration.nextElement();
            cloneable = ((ArrayType)type).getElementType();
            this.addReference((Type)cloneable, hashtable, hashtable2, hashtable3);
        }
        enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            type = (CompoundType)enumeration.nextElement();
            if (this.isIDLGeneratedFor((CompoundType)type)) continue;
            hashtable.remove(type.getQualifiedName());
        }
    }

    protected boolean isIDLGeneratedFor(CompoundType compoundType) {
        if (compoundType.isCORBAObject()) {
            return false;
        }
        if (compoundType.isIDLEntity()) {
            if (compoundType.isBoxed()) {
                return true;
            }
            if ("org.omg.CORBA.portable.IDLEntity".equals(compoundType.getQualifiedName())) {
                return true;
            }
            return compoundType.isCORBAUserException();
        }
        Hashtable hashtable = new Hashtable();
        this.getInterfaces(compoundType, hashtable);
        if (compoundType.getTypeCode() == 65536) {
            return hashtable.size() >= 2;
        }
        return true;
    }

    protected void writeOutputFor(Generator.OutputType outputType, HashSet hashSet, IndentingWriter indentingWriter) throws IOException {
        CompoundType compoundType;
        Type type = outputType.getType();
        if (type.isArray()) {
            this.writeSequence(outputType, indentingWriter);
            return;
        }
        if (this.isSpecialReference(type)) {
            this.writeSpecial(type, indentingWriter);
            return;
        }
        if (type.isCompound() && (compoundType = (CompoundType)type).isIDLEntity() && compoundType.isBoxed()) {
            this.writeBoxedIDL(compoundType, indentingWriter);
            return;
        }
        if (type.isClass() && (compoundType = (ClassType)type).isException()) {
            String string = this.unEsc(compoundType.getIDLExceptionName());
            String string2 = outputType.getName();
            if (string2.equals(string.replace(' ', '_'))) {
                this.writeException((ClassType)compoundType, indentingWriter);
                return;
            }
        }
        switch (type.getTypeCode()) {
            case 65536: {
                this.writeImplementation((ImplementationType)type, indentingWriter);
                break;
            }
            case 16384: 
            case 131072: {
                this.writeNCType((CompoundType)type, indentingWriter);
                break;
            }
            case 4096: 
            case 8192: {
                this.writeRemote((RemoteType)type, indentingWriter);
                break;
            }
            case 32768: {
                this.writeValue((ValueType)type, indentingWriter);
                break;
            }
            default: {
                throw new CompilerError("IDLGenerator got unexpected type code: " + type.getTypeCode());
            }
        }
    }

    protected void writeImplementation(ImplementationType implementationType, IndentingWriter indentingWriter) throws IOException {
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        this.getInterfaces(implementationType, hashtable);
        this.writeBanner(implementationType, 0, !this.isException, indentingWriter);
        this.writeInheritedIncludes(hashtable, indentingWriter);
        this.writeIfndef(implementationType, 0, !this.isException, !this.isForward, indentingWriter);
        this.writeIncOrb(indentingWriter);
        this.writeModule1(implementationType, indentingWriter);
        indentingWriter.pln();
        indentingWriter.pI();
        indentingWriter.p("interface " + implementationType.getIDLName());
        this.writeInherits(hashtable, !this.forValuetype, indentingWriter);
        indentingWriter.pln(" {");
        indentingWriter.pln("};");
        indentingWriter.pO();
        indentingWriter.pln();
        this.writeModule2(implementationType, indentingWriter);
        this.writeEpilog(implementationType, hashtable2, indentingWriter);
    }

    protected void writeNCType(CompoundType compoundType, IndentingWriter indentingWriter) throws IOException {
        Vector vector = this.getConstants(compoundType);
        Vector vector2 = this.getMethods(compoundType);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        Hashtable hashtable5 = new Hashtable();
        this.getInterfaces(compoundType, hashtable);
        this.getInheritance(compoundType, hashtable);
        this.getMethodReferences(vector2, hashtable2, hashtable3, hashtable4, hashtable5);
        this.writeProlog(compoundType, hashtable2, hashtable3, hashtable4, hashtable5, hashtable, indentingWriter);
        this.writeModule1(compoundType, indentingWriter);
        indentingWriter.pln();
        indentingWriter.pI();
        indentingWriter.p("abstract valuetype " + compoundType.getIDLName());
        this.writeInherits(hashtable, !this.forValuetype, indentingWriter);
        indentingWriter.pln(" {");
        if (vector.size() + vector2.size() > 0) {
            indentingWriter.pln();
            indentingWriter.pI();
            int n = 0;
            while (n < vector.size()) {
                this.writeConstant((CompoundType.Member)vector.elementAt(n), indentingWriter);
                ++n;
            }
            int n2 = 0;
            while (n2 < vector2.size()) {
                this.writeMethod((CompoundType.Method)vector2.elementAt(n2), indentingWriter);
                ++n2;
            }
            indentingWriter.pO();
            indentingWriter.pln();
        }
        indentingWriter.pln("};");
        indentingWriter.pO();
        indentingWriter.pln();
        this.writeModule2(compoundType, indentingWriter);
        this.writeEpilog(compoundType, hashtable2, indentingWriter);
    }

    protected void writeRemote(RemoteType remoteType, IndentingWriter indentingWriter) throws IOException {
        Vector vector = this.getConstants(remoteType);
        Vector vector2 = this.getMethods(remoteType);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        Hashtable hashtable5 = new Hashtable();
        this.getInterfaces(remoteType, hashtable);
        this.getMethodReferences(vector2, hashtable2, hashtable3, hashtable4, hashtable5);
        this.writeProlog(remoteType, hashtable2, hashtable3, hashtable4, hashtable5, hashtable, indentingWriter);
        this.writeModule1(remoteType, indentingWriter);
        indentingWriter.pln();
        indentingWriter.pI();
        if (remoteType.getTypeCode() == 8192) {
            indentingWriter.p("abstract ");
        }
        indentingWriter.p("interface " + remoteType.getIDLName());
        this.writeInherits(hashtable, !this.forValuetype, indentingWriter);
        indentingWriter.pln(" {");
        if (vector.size() + vector2.size() > 0) {
            indentingWriter.pln();
            indentingWriter.pI();
            int n = 0;
            while (n < vector.size()) {
                this.writeConstant((CompoundType.Member)vector.elementAt(n), indentingWriter);
                ++n;
            }
            int n2 = 0;
            while (n2 < vector2.size()) {
                this.writeMethod((CompoundType.Method)vector2.elementAt(n2), indentingWriter);
                ++n2;
            }
            indentingWriter.pO();
            indentingWriter.pln();
        }
        indentingWriter.pln("};");
        indentingWriter.pO();
        indentingWriter.pln();
        this.writeRepositoryID(remoteType, indentingWriter);
        indentingWriter.pln();
        this.writeModule2(remoteType, indentingWriter);
        this.writeEpilog(remoteType, hashtable2, indentingWriter);
    }

    protected void writeValue(ValueType valueType, IndentingWriter indentingWriter) throws IOException {
        Vector vector = this.getData(valueType);
        Vector vector2 = this.getConstants(valueType);
        Vector vector3 = this.getMethods(valueType);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        Hashtable hashtable5 = new Hashtable();
        this.getInterfaces(valueType, hashtable);
        this.getInheritance(valueType, hashtable);
        this.getMethodReferences(vector3, hashtable2, hashtable3, hashtable4, hashtable5);
        this.getMemberReferences(vector, hashtable2, hashtable3, hashtable4);
        this.writeProlog(valueType, hashtable2, hashtable3, hashtable4, hashtable5, hashtable, indentingWriter);
        this.writeModule1(valueType, indentingWriter);
        indentingWriter.pln();
        indentingWriter.pI();
        if (valueType.isCustom()) {
            indentingWriter.p("custom ");
        }
        indentingWriter.p("valuetype " + valueType.getIDLName());
        this.writeInherits(hashtable, this.forValuetype, indentingWriter);
        indentingWriter.pln(" {");
        if (vector2.size() + vector.size() + vector3.size() > 0) {
            indentingWriter.pln();
            indentingWriter.pI();
            int n = 0;
            while (n < vector2.size()) {
                this.writeConstant((CompoundType.Member)vector2.elementAt(n), indentingWriter);
                ++n;
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                CompoundType.Member member = (CompoundType.Member)vector.elementAt(n2);
                if (member.getType().isPrimitive()) {
                    this.writeData(member, indentingWriter);
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < vector.size()) {
                CompoundType.Member member = (CompoundType.Member)vector.elementAt(n3);
                if (!member.getType().isPrimitive()) {
                    this.writeData(member, indentingWriter);
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < vector3.size()) {
                this.writeMethod((CompoundType.Method)vector3.elementAt(n4), indentingWriter);
                ++n4;
            }
            indentingWriter.pO();
            indentingWriter.pln();
        }
        indentingWriter.pln("};");
        indentingWriter.pO();
        indentingWriter.pln();
        this.writeRepositoryID(valueType, indentingWriter);
        indentingWriter.pln();
        this.writeModule2(valueType, indentingWriter);
        this.writeEpilog(valueType, hashtable2, indentingWriter);
    }

    protected void writeProlog(CompoundType compoundType, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, Hashtable hashtable4, Hashtable hashtable5, IndentingWriter indentingWriter) throws IOException {
        this.writeBanner(compoundType, 0, !this.isException, indentingWriter);
        this.writeForwardReferences(hashtable, indentingWriter);
        this.writeIncludes(hashtable4, this.isThrown, indentingWriter);
        this.writeInheritedIncludes(hashtable5, indentingWriter);
        this.writeIncludes(hashtable2, !this.isThrown, indentingWriter);
        this.writeBoxedRMIIncludes(hashtable3, indentingWriter);
        this.writeIDLEntityIncludes(hashtable, indentingWriter);
        this.writeIncOrb(indentingWriter);
        this.writeIfndef(compoundType, 0, !this.isException, !this.isForward, indentingWriter);
    }

    protected void writeEpilog(CompoundType compoundType, Hashtable hashtable, IndentingWriter indentingWriter) throws IOException {
        this.writeIncludes(hashtable, !this.isThrown, indentingWriter);
        this.writeEndif(indentingWriter);
    }

    protected void writeSpecial(Type type, IndentingWriter indentingWriter) throws IOException {
        String string = type.getQualifiedName();
        if ("java.io.Serializable".equals(string)) {
            this.writeJavaIoSerializable(type, indentingWriter);
        } else if ("java.io.Externalizable".equals(string)) {
            this.writeJavaIoExternalizable(type, indentingWriter);
        } else if ("java.lang.Object".equals(string)) {
            this.writeJavaLangObject(type, indentingWriter);
        } else if ("java.rmi.Remote".equals(string)) {
            this.writeJavaRmiRemote(type, indentingWriter);
        } else if ("org.omg.CORBA.portable.IDLEntity".equals(string)) {
            this.writeIDLEntity(type, indentingWriter);
        }
    }

    protected void writeJavaIoSerializable(Type type, IndentingWriter indentingWriter) throws IOException {
        this.writeBanner(type, 0, !this.isException, indentingWriter);
        this.writeIfndef(type, 0, !this.isException, !this.isForward, indentingWriter);
        this.writeModule1(type, indentingWriter);
        indentingWriter.pln();
        indentingWriter.pI();
        indentingWriter.pln("typedef any Serializable;");
        indentingWriter.pO();
        indentingWriter.pln();
        this.writeModule2(type, indentingWriter);
        this.writeEndif(indentingWriter);
    }

    protected void writeJavaIoExternalizable(Type type, IndentingWriter indentingWriter) throws IOException {
        this.writeBanner(type, 0, !this.isException, indentingWriter);
        this.writeIfndef(type, 0, !this.isException, !this.isForward, indentingWriter);
        this.writeModule1(type, indentingWriter);
        indentingWriter.pln();
        indentingWriter.pI();
        indentingWriter.pln("typedef any Externalizable;");
        indentingWriter.pO();
        indentingWriter.pln();
        this.writeModule2(type, indentingWriter);
        this.writeEndif(indentingWriter);
    }

    protected void writeJavaLangObject(Type type, IndentingWriter indentingWriter) throws IOException {
        this.writeBanner(type, 0, !this.isException, indentingWriter);
        this.writeIfndef(type, 0, !this.isException, !this.isForward, indentingWriter);
        this.writeModule1(type, indentingWriter);
        indentingWriter.pln();
        indentingWriter.pI();
        indentingWriter.pln("typedef any _Object;");
        indentingWriter.pO();
        indentingWriter.pln();
        this.writeModule2(type, indentingWriter);
        this.writeEndif(indentingWriter);
    }

    protected void writeJavaRmiRemote(Type type, IndentingWriter indentingWriter) throws IOException {
        this.writeBanner(type, 0, !this.isException, indentingWriter);
        this.writeIfndef(type, 0, !this.isException, !this.isForward, indentingWriter);
        this.writeModule1(type, indentingWriter);
        indentingWriter.pln();
        indentingWriter.pI();
        indentingWriter.pln("typedef Object Remote;");
        indentingWriter.pO();
        indentingWriter.pln();
        this.writeModule2(type, indentingWriter);
        this.writeEndif(indentingWriter);
    }

    protected void writeIDLEntity(Type type, IndentingWriter indentingWriter) throws IOException {
        this.writeBanner(type, 0, !this.isException, indentingWriter);
        this.writeIfndef(type, 0, !this.isException, !this.isForward, indentingWriter);
        this.writeModule1(type, indentingWriter);
        indentingWriter.pln();
        indentingWriter.pI();
        indentingWriter.pln("typedef any IDLEntity;");
        indentingWriter.pO();
        indentingWriter.pln();
        this.writeModule2(type, indentingWriter);
        this.writeEndif(indentingWriter);
    }

    protected void getInterfaces(CompoundType compoundType, Hashtable hashtable) {
        InterfaceType[] interfaceTypeArray = compoundType.getInterfaces();
        int n = 0;
        while (n < interfaceTypeArray.length) {
            block4: {
                String string = interfaceTypeArray[n].getQualifiedName();
                switch (compoundType.getTypeCode()) {
                    case 32768: 
                    case 131072: {
                        if (!"java.io.Externalizable".equals(string) && !"java.io.Serializable".equals(string) && !"org.omg.CORBA.portable.IDLEntity".equals(string)) break;
                        break block4;
                    }
                    default: {
                        if ("java.rmi.Remote".equals(string)) break block4;
                    }
                }
                hashtable.put(string, interfaceTypeArray[n]);
            }
            ++n;
        }
    }

    protected void getInheritance(CompoundType compoundType, Hashtable hashtable) {
        ClassType classType = compoundType.getSuperclass();
        if (classType == null) {
            return;
        }
        String string = classType.getQualifiedName();
        switch (compoundType.getTypeCode()) {
            case 32768: 
            case 131072: {
                if (!"java.lang.Object".equals(string)) break;
                return;
            }
            default: {
                return;
            }
        }
        hashtable.put(string, classType);
    }

    protected void getMethodReferences(Vector vector, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, Hashtable hashtable4) {
        int n = 0;
        while (n < vector.size()) {
            CompoundType.Method method = (CompoundType.Method)vector.elementAt(n);
            Type[] typeArray = method.getArguments();
            Type type = method.getReturnType();
            this.getExceptions(method, hashtable4);
            int n2 = 0;
            while (n2 < typeArray.length) {
                this.addReference(typeArray[n2], hashtable, hashtable2, hashtable3);
                ++n2;
            }
            this.addReference(type, hashtable, hashtable2, hashtable3);
            ++n;
        }
    }

    protected void getMemberReferences(Vector vector, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        int n = 0;
        while (n < vector.size()) {
            CompoundType.Member member = (CompoundType.Member)vector.elementAt(n);
            Type type = member.getType();
            this.addReference(type, hashtable, hashtable2, hashtable3);
            ++n;
        }
    }

    protected void addReference(Type type, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        String string = type.getQualifiedName();
        switch (type.getTypeCode()) {
            case 4096: 
            case 8192: 
            case 16384: 
            case 32768: 
            case 131072: {
                hashtable.put(string, type);
                return;
            }
            case 2048: {
                if ("org.omg.CORBA.Object".equals(string)) {
                    return;
                }
                hashtable.put(string, type);
                return;
            }
            case 262144: {
                hashtable3.put(string + type.getArrayDimension(), type);
                return;
            }
        }
        if (this.isSpecialReference(type)) {
            hashtable2.put(string, type);
        }
    }

    protected boolean isSpecialReference(Type type) {
        String string = type.getQualifiedName();
        if ("java.io.Serializable".equals(string)) {
            return true;
        }
        if ("java.io.Externalizable".equals(string)) {
            return true;
        }
        if ("java.lang.Object".equals(string)) {
            return true;
        }
        if ("java.rmi.Remote".equals(string)) {
            return true;
        }
        return "org.omg.CORBA.portable.IDLEntity".equals(string);
    }

    protected void getExceptions(CompoundType.Method method, Hashtable hashtable) {
        ValueType[] valueTypeArray = method.getExceptions();
        int n = 0;
        while (n < valueTypeArray.length) {
            ValueType valueType = valueTypeArray[n];
            if (valueType.isCheckedException() && !valueType.isRemoteExceptionOrSubclass()) {
                hashtable.put(valueType.getQualifiedName(), valueType);
            }
            ++n;
        }
    }

    protected Vector getMethods(CompoundType compoundType) {
        Vector<CompoundType.Method> vector = new Vector<CompoundType.Method>();
        int n = compoundType.getTypeCode();
        switch (n) {
            case 4096: 
            case 8192: {
                break;
            }
            case 16384: 
            case 32768: 
            case 131072: {
                if (this.valueMethods) break;
            }
            default: {
                return vector;
            }
        }
        Identifier identifier = compoundType.getIdentifier();
        CompoundType.Method[] methodArray = compoundType.getMethods();
        int n2 = 0;
        while (n2 < methodArray.length) {
            String string;
            if (!(methodArray[n2].isPrivate() || methodArray[n2].isInherited() || n == 32768 && ("readObject".equals(string = methodArray[n2].getName()) || "writeObject".equals(string) || "readExternal".equals(string) || "writeExternal".equals(string)) || (n == 131072 || n == 16384) && methodArray[n2].isConstructor())) {
                vector.addElement(methodArray[n2]);
            }
            ++n2;
        }
        return vector;
    }

    protected Vector getConstants(CompoundType compoundType) {
        Vector<CompoundType.Member> vector = new Vector<CompoundType.Member>();
        CompoundType.Member[] memberArray = compoundType.getMembers();
        int n = 0;
        while (n < memberArray.length) {
            Type type = memberArray[n].getType();
            String string = memberArray[n].getValue();
            if (memberArray[n].isPublic() && memberArray[n].isFinal() && memberArray[n].isStatic() && (type.isPrimitive() || "String".equals(type.getName())) && string != null) {
                vector.addElement(memberArray[n]);
            }
            ++n;
        }
        return vector;
    }

    protected Vector getData(CompoundType compoundType) {
        Vector<CompoundType.Member> vector = new Vector<CompoundType.Member>();
        if (compoundType.getTypeCode() != 32768) {
            return vector;
        }
        ValueType valueType = (ValueType)compoundType;
        CompoundType.Member[] memberArray = valueType.getMembers();
        boolean bl = !valueType.isCustom();
        int n = 0;
        while (n < memberArray.length) {
            if (!memberArray[n].isStatic() && !memberArray[n].isTransient() && (memberArray[n].isPublic() || bl)) {
                String string = memberArray[n].getName();
                int n2 = 0;
                while (n2 < vector.size()) {
                    CompoundType.Member member = (CompoundType.Member)vector.elementAt(n2);
                    if (string.compareTo(member.getName()) < 0) break;
                    ++n2;
                }
                vector.insertElementAt(memberArray[n], n2);
            }
            ++n;
        }
        return vector;
    }

    protected void writeForwardReferences(Hashtable hashtable, IndentingWriter indentingWriter) throws IOException {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            CompoundType compoundType;
            Type type = (Type)enumeration.nextElement();
            if (type.isCompound() && (compoundType = (CompoundType)type).isIDLEntity()) continue;
            this.writeForwardReference(type, indentingWriter);
        }
    }

    protected void writeForwardReference(Type type, IndentingWriter indentingWriter) throws IOException {
        String string = type.getQualifiedName();
        if (!"java.lang.String".equals(string) && "org.omg.CORBA.Object".equals(string)) {
            return;
        }
        this.writeIfndef(type, 0, !this.isException, this.isForward, indentingWriter);
        this.writeModule1(type, indentingWriter);
        indentingWriter.pln();
        indentingWriter.pI();
        switch (type.getTypeCode()) {
            case 16384: 
            case 131072: {
                indentingWriter.p("abstract valuetype ");
                break;
            }
            case 8192: {
                indentingWriter.p("abstract interface ");
                break;
            }
            case 32768: {
                indentingWriter.p("valuetype ");
                break;
            }
            case 2048: 
            case 4096: {
                indentingWriter.p("interface ");
                break;
            }
        }
        indentingWriter.pln(type.getIDLName() + ";");
        indentingWriter.pO();
        indentingWriter.pln();
        this.writeModule2(type, indentingWriter);
        this.writeEndif(indentingWriter);
    }

    protected void writeForwardReference(ArrayType arrayType, int n, IndentingWriter indentingWriter) throws IOException {
        Type type = arrayType.getElementType();
        if (n < 1) {
            if (type.isCompound()) {
                CompoundType compoundType = (CompoundType)type;
                this.writeForwardReference(type, indentingWriter);
            }
            return;
        }
        String string = this.unEsc(type.getIDLName()).replace(' ', '_');
        this.writeIfndef(arrayType, n, !this.isException, this.isForward, indentingWriter);
        this.writeModule1(arrayType, indentingWriter);
        indentingWriter.pln();
        indentingWriter.pI();
        switch (type.getTypeCode()) {
            case 16384: 
            case 131072: {
                indentingWriter.p("abstract valuetype ");
                break;
            }
            case 8192: {
                indentingWriter.p("abstract interface ");
                break;
            }
            case 32768: {
                indentingWriter.p("valuetype ");
                break;
            }
            case 2048: 
            case 4096: {
                indentingWriter.p("interface ");
                break;
            }
        }
        indentingWriter.pln("seq" + n + "_" + string + ";");
        indentingWriter.pO();
        indentingWriter.pln();
        this.writeModule2(arrayType, indentingWriter);
        this.writeEndif(indentingWriter);
    }

    protected void writeIDLEntityIncludes(Hashtable hashtable, IndentingWriter indentingWriter) throws IOException {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            CompoundType compoundType;
            Type type = (Type)enumeration.nextElement();
            if (!type.isCompound() || !(compoundType = (CompoundType)type).isIDLEntity()) continue;
            this.writeInclude((Type)compoundType, 0, !this.isThrown, indentingWriter);
            hashtable.remove(compoundType.getQualifiedName());
        }
    }

    protected void writeIncludes(Hashtable hashtable, boolean bl, IndentingWriter indentingWriter) throws IOException {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            CompoundType compoundType = (CompoundType)enumeration.nextElement();
            this.writeInclude((Type)compoundType, 0, bl, indentingWriter);
        }
    }

    protected void writeBoxedRMIIncludes(Hashtable hashtable, IndentingWriter indentingWriter) throws IOException {
        Enumeration enumeration = hashtable.elements();
        block0: while (enumeration.hasMoreElements()) {
            ArrayType arrayType = (ArrayType)enumeration.nextElement();
            int n = arrayType.getArrayDimension();
            Type type = arrayType.getElementType();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                ArrayType arrayType2 = (ArrayType)enumeration2.nextElement();
                if (type == arrayType2.getElementType() && n < arrayType2.getArrayDimension()) continue block0;
            }
            this.writeInclude((Type)arrayType, n, !this.isThrown, indentingWriter);
        }
    }

    protected void writeInheritedIncludes(Hashtable hashtable, IndentingWriter indentingWriter) throws IOException {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            CompoundType compoundType = (CompoundType)enumeration.nextElement();
            this.writeInclude((Type)compoundType, 0, !this.isThrown, indentingWriter);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeInclude(Type type, int n, boolean bl, IndentingWriter indentingWriter) throws IOException {
        String string;
        String[] stringArray;
        if (type.isCompound()) {
            CompoundType compoundType = (CompoundType)type;
            String string2 = compoundType.getQualifiedName();
            if ("java.lang.String".equals(string2)) {
                this.writeIncOrb(indentingWriter);
                return;
            }
            if ("org.omg.CORBA.Object".equals(string2)) {
                return;
            }
            stringArray = this.getIDLModuleNames(compoundType);
            string = this.unEsc(compoundType.getIDLName());
            if (compoundType.isException()) {
                if (compoundType.isIDLEntityException()) {
                    if (compoundType.isCORBAUserException()) {
                        if (bl) {
                            string = this.unEsc(compoundType.getIDLExceptionName());
                        }
                    } else {
                        string = compoundType.getName();
                    }
                } else if (bl) {
                    string = this.unEsc(compoundType.getIDLExceptionName());
                }
            }
        } else {
            if (!type.isArray()) return;
            Type type2 = type.getElementType();
            if (n > 0) {
                stringArray = this.getIDLModuleNames(type);
                string = "seq" + n + "_" + this.unEsc(type2.getIDLName().replace(' ', '_'));
            } else {
                if (!type2.isCompound()) {
                    return;
                }
                CompoundType compoundType = (CompoundType)type2;
                String[] stringArray2 = this.getIDLModuleNames(compoundType);
                String string3 = this.unEsc(compoundType.getIDLName());
                this.writeInclude((Type)compoundType, stringArray2, string3, indentingWriter);
                return;
            }
        }
        this.writeInclude(type, stringArray, string, indentingWriter);
    }

    protected void writeInclude(Type type, String[] stringArray, String string, IndentingWriter indentingWriter) throws IOException {
        if (type.isCompound()) {
            CompoundType compoundType = (CompoundType)type;
            if (this.ifHash.size() > 0 && compoundType.isIDLEntity()) {
                String string2 = type.getQualifiedName();
                Enumeration enumeration = this.ifHash.keys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    if (!string2.startsWith(string3)) continue;
                    String string4 = (String)this.ifHash.get(string3);
                    indentingWriter.pln("#include \"" + string4 + "\"");
                    return;
                }
            }
        } else if (!type.isArray()) {
            return;
        }
        indentingWriter.p("#include \"");
        int n = 0;
        while (n < stringArray.length) {
            indentingWriter.p(stringArray[n] + "/");
            ++n;
        }
        indentingWriter.p(string + ".idl\"");
        indentingWriter.pln();
    }

    protected String getQualifiedName(Type type) {
        String[] stringArray = this.getIDLModuleNames(type);
        int n = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(stringArray[n2] + ".");
            ++n2;
        }
        stringBuffer.append(type.getIDLName());
        return stringBuffer.toString();
    }

    protected String getQualifiedIDLName(Type type) {
        if (type.isPrimitive()) {
            return type.getIDLName();
        }
        if (!type.isArray() && "org.omg.CORBA.Object".equals(type.getQualifiedName())) {
            return type.getIDLName();
        }
        String[] stringArray = this.getIDLModuleNames(type);
        int n = stringArray.length;
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append("::" + stringArray[n2]);
                ++n2;
            }
            stringBuffer.append("::" + type.getIDLName());
            return stringBuffer.toString();
        }
        return type.getIDLName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String[] getIDLModuleNames(Type type) {
        Cloneable cloneable;
        CompoundType compoundType;
        String[] stringArray = type.getIDLModuleNames();
        if (type.isCompound()) {
            compoundType = (CompoundType)type;
            if (!compoundType.isIDLEntity) {
                return stringArray;
            }
            if ("org.omg.CORBA.portable.IDLEntity".equals(type.getQualifiedName())) {
                return stringArray;
            }
        } else {
            if (!type.isArray()) return stringArray;
            cloneable = type.getElementType();
            if (!((Type)cloneable).isCompound()) return stringArray;
            compoundType = (CompoundType)cloneable;
            if (!compoundType.isIDLEntity) {
                return stringArray;
            }
            if ("org.omg.CORBA.portable.IDLEntity".equals(type.getQualifiedName())) {
                return stringArray;
            }
        }
        if (!this.translateJavaPackage(compoundType, (Vector)(cloneable = new Vector()))) {
            this.stripJavaPackage(compoundType, (Vector)cloneable);
        }
        if (compoundType.isBoxed()) {
            ((Vector)cloneable).insertElementAt("org", 0);
            ((Vector)cloneable).insertElementAt("omg", 1);
            ((Vector)cloneable).insertElementAt("boxedIDL", 2);
        }
        if (type.isArray()) {
            ((Vector)cloneable).insertElementAt("org", 0);
            ((Vector)cloneable).insertElementAt("omg", 1);
            ((Vector)cloneable).insertElementAt("boxedRMI", 2);
        }
        Object[] objectArray = new String[((Vector)cloneable).size()];
        ((Vector)cloneable).copyInto(objectArray);
        return objectArray;
    }

    protected boolean translateJavaPackage(CompoundType compoundType, Vector vector) {
        vector.removeAllElements();
        boolean bl = false;
        String string = null;
        if (!compoundType.isIDLEntity()) {
            return bl;
        }
        String string2 = compoundType.getPackageName();
        if (string2 == null) {
            return bl;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        if (this.imHash.size() > 0) {
            Enumeration enumeration = this.imHash.keys();
            block1: while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ".");
                int n = vector.size();
                int n2 = 0;
                while (n2 < n && stringTokenizer2.hasMoreTokens()) {
                    if (!vector.elementAt(n2).equals(stringTokenizer2.nextToken())) continue block1;
                    ++n2;
                }
                if (stringTokenizer2.hasMoreTokens()) {
                    string = stringTokenizer2.nextToken();
                    if (!compoundType.getName().equals(string) || stringTokenizer2.hasMoreTokens()) continue;
                }
                bl = true;
                int n3 = 0;
                while (n3 < n2) {
                    vector.removeElementAt(0);
                    ++n3;
                }
                String string4 = (String)this.imHash.get(string3);
                StringTokenizer stringTokenizer3 = new StringTokenizer(string4, "::");
                int n4 = stringTokenizer3.countTokens();
                int n5 = 0;
                if (string != null) {
                    --n4;
                }
                n5 = 0;
                while (n5 < n4) {
                    vector.insertElementAt(stringTokenizer3.nextToken(), n5);
                    ++n5;
                }
                if (string == null) continue;
                String string5 = stringTokenizer3.nextToken();
                if (compoundType.getName().equals(string5)) continue;
                vector.insertElementAt(string5, n5);
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    protected void stripJavaPackage(CompoundType var1_1, Vector var2_2) {
        var2_2.removeAllElements();
        if (!var1_1.isIDLEntity()) {
            return;
        }
        var3_3 = var1_1.getRepositoryID().substring(4);
        var4_4 = new StringTokenizer(var3_3, "/");
        if (var4_4.countTokens() >= 2) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            var2_2.addElement(var4_4.nextToken());
lbl9:
            // 2 sources

            ** while (var4_4.hasMoreTokens())
        }
lbl10:
        // 1 sources

        var2_2.removeElementAt(var2_2.size() - 1);
        var5_5 = var1_1.getPackageName();
        if (var5_5 == null) {
            return;
        }
        var6_6 = new Vector<String>();
        var7_7 = new StringTokenizer(var5_5, ".");
        while (var7_7.hasMoreTokens()) {
            var6_6.addElement(var7_7.nextToken());
        }
        var8_8 = var2_2.size() - 1;
        var9_9 = var6_6.size() - 1;
        while (var8_8 >= 0 && var9_9 >= 0) {
            var10_10 = (String)var2_2.elementAt(var8_8);
            var11_12 = (String)var6_6.elementAt(var9_9);
            if (!var11_12.equals(var10_10)) break;
            --var8_8;
            --var9_9;
        }
        var10_11 = 0;
        while (var10_11 <= var8_8) {
            var2_2.removeElementAt(0);
            ++var10_11;
        }
    }

    protected void writeSequence(Generator.OutputType outputType, IndentingWriter indentingWriter) throws IOException {
        ArrayType arrayType = (ArrayType)outputType.getType();
        Type type = arrayType.getElementType();
        String string = outputType.getName();
        int n = Integer.parseInt(string.substring(3, string.indexOf("_")));
        String string2 = this.unEsc(type.getIDLName()).replace(' ', '_');
        String string3 = this.getQualifiedIDLName(type);
        String string4 = type.getQualifiedName();
        String string5 = arrayType.getRepositoryID();
        int n2 = string5.indexOf(91);
        int n3 = string5.lastIndexOf(91) + 1;
        StringBuffer stringBuffer = new StringBuffer(string5.substring(0, n2) + string5.substring(n3));
        int n4 = 0;
        while (n4 < n) {
            stringBuffer.insert(n2, '[');
            ++n4;
        }
        String string6 = "seq" + n + "_" + string2;
        boolean bl = false;
        if (type.isCompound()) {
            CompoundType compoundType = (CompoundType)type;
            bl = compoundType.isIDLEntity() || compoundType.isCORBAObject();
        }
        boolean bl2 = type.isCompound() && !this.isSpecialReference(type) && n == 1 && !bl && !"org.omg.CORBA.Object".equals(string4) && !"java.lang.String".equals(string4);
        this.writeBanner(arrayType, n, !this.isException, indentingWriter);
        if (n == 1 && "java.lang.String".equals(string4)) {
            this.writeIncOrb(indentingWriter);
        }
        if (!(n == 1 && "org.omg.CORBA.Object".equals(string4) || !this.isSpecialReference(type) && n <= 1 && !bl)) {
            this.writeInclude((Type)arrayType, n - 1, !this.isThrown, indentingWriter);
        }
        this.writeIfndef(arrayType, n, !this.isException, !this.isForward, indentingWriter);
        if (bl2) {
            this.writeForwardReference(arrayType, n - 1, indentingWriter);
        }
        this.writeModule1(arrayType, indentingWriter);
        indentingWriter.pln();
        indentingWriter.pI();
        indentingWriter.p("valuetype " + string6);
        indentingWriter.p(" sequence<");
        if (n == 1) {
            indentingWriter.p(string3);
        } else {
            indentingWriter.p("seq" + (n - 1) + "_");
            indentingWriter.p(string2);
        }
        indentingWriter.pln(">;");
        indentingWriter.pO();
        indentingWriter.pln();
        indentingWriter.pln("#pragma ID " + string6 + " \"" + stringBuffer + "\"");
        indentingWriter.pln();
        this.writeModule2(arrayType, indentingWriter);
        if (bl2) {
            this.writeInclude((Type)arrayType, n - 1, !this.isThrown, indentingWriter);
        }
        this.writeEndif(indentingWriter);
    }

    protected void writeBoxedIDL(CompoundType compoundType, IndentingWriter indentingWriter) throws IOException {
        String[] stringArray = this.getIDLModuleNames(compoundType);
        int n = stringArray.length;
        String[] stringArray2 = new String[n - 3];
        int n2 = 0;
        while (n2 < n - 3) {
            stringArray2[n2] = stringArray[n2 + 3];
            ++n2;
        }
        String string = this.unEsc(compoundType.getIDLName());
        this.writeBanner(compoundType, 0, !this.isException, indentingWriter);
        this.writeInclude((Type)compoundType, stringArray2, string, indentingWriter);
        this.writeIfndef(compoundType, 0, !this.isException, !this.isForward, indentingWriter);
        this.writeModule1(compoundType, indentingWriter);
        indentingWriter.pln();
        indentingWriter.pI();
        indentingWriter.p("valuetype " + string + " ");
        int n3 = 0;
        while (n3 < stringArray2.length) {
            indentingWriter.p("::" + stringArray2[n3]);
            ++n3;
        }
        indentingWriter.pln("::" + string + ";");
        indentingWriter.pO();
        indentingWriter.pln();
        this.writeRepositoryID(compoundType, indentingWriter);
        indentingWriter.pln();
        this.writeModule2(compoundType, indentingWriter);
        this.writeEndif(indentingWriter);
    }

    protected void writeException(ClassType classType, IndentingWriter indentingWriter) throws IOException {
        this.writeBanner(classType, 0, this.isException, indentingWriter);
        this.writeIfndef(classType, 0, this.isException, !this.isForward, indentingWriter);
        this.writeForwardReference(classType, indentingWriter);
        this.writeModule1(classType, indentingWriter);
        indentingWriter.pln();
        indentingWriter.pI();
        indentingWriter.pln("exception " + classType.getIDLExceptionName() + " {");
        indentingWriter.pln();
        indentingWriter.pI();
        indentingWriter.pln(classType.getIDLName() + " value;");
        indentingWriter.pO();
        indentingWriter.pln();
        indentingWriter.pln("};");
        indentingWriter.pO();
        indentingWriter.pln();
        this.writeModule2(classType, indentingWriter);
        this.writeInclude((Type)classType, 0, !this.isThrown, indentingWriter);
        this.writeEndif(indentingWriter);
    }

    protected void writeRepositoryID(Type type, IndentingWriter indentingWriter) throws IOException {
        CompoundType compoundType;
        String string = type.getRepositoryID();
        if (type.isCompound() && (compoundType = (CompoundType)type).isBoxed()) {
            string = compoundType.getBoxedRepositoryID();
        }
        indentingWriter.pln("#pragma ID " + type.getIDLName() + " \"" + string + "\"");
    }

    protected void writeInherits(Hashtable hashtable, boolean bl, IndentingWriter indentingWriter) throws IOException {
        int n;
        CompoundType compoundType;
        int n2 = hashtable.size();
        int n3 = 0;
        int n4 = 0;
        if (n2 < 1) {
            return;
        }
        Enumeration enumeration = hashtable.elements();
        if (bl) {
            while (enumeration.hasMoreElements()) {
                compoundType = (CompoundType)enumeration.nextElement();
                if (compoundType.getTypeCode() != 8192) continue;
                ++n4;
            }
        }
        if ((n3 = n2 - n4) > 0) {
            indentingWriter.p(": ");
            enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                compoundType = (CompoundType)enumeration.nextElement();
                if (!compoundType.isClass()) continue;
                indentingWriter.p(this.getQualifiedIDLName(compoundType));
                if (n3 > 1) {
                    indentingWriter.p(", ");
                    break;
                }
                if (n2 <= 1) break;
                indentingWriter.p(" ");
                break;
            }
            n = 0;
            enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                compoundType = (CompoundType)enumeration.nextElement();
                if (compoundType.isClass() || compoundType.getTypeCode() == 8192) continue;
                if (n++ > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(this.getQualifiedIDLName(compoundType));
            }
        }
        if (n4 > 0) {
            indentingWriter.p(" supports ");
            n = 0;
            enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                compoundType = (CompoundType)enumeration.nextElement();
                if (compoundType.getTypeCode() != 8192) continue;
                if (n++ > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(this.getQualifiedIDLName(compoundType));
            }
        }
    }

    protected void writeConstant(CompoundType.Member member, IndentingWriter indentingWriter) throws IOException {
        Type type = member.getType();
        indentingWriter.p("const ");
        indentingWriter.p(this.getQualifiedIDLName(type));
        indentingWriter.p(" " + member.getIDLName() + " = " + member.getValue());
        indentingWriter.pln(";");
    }

    protected void writeData(CompoundType.Member member, IndentingWriter indentingWriter) throws IOException {
        if (member.isInnerClassDeclaration()) {
            return;
        }
        Type type = member.getType();
        if (member.isPublic()) {
            indentingWriter.p("public ");
        } else {
            indentingWriter.p("private ");
        }
        indentingWriter.pln(this.getQualifiedIDLName(type) + " " + member.getIDLName() + ";");
    }

    protected void writeAttribute(CompoundType.Method method, IndentingWriter indentingWriter) throws IOException {
        if (method.getAttributeKind() == 5) {
            return;
        }
        Type type = method.getReturnType();
        if (!method.isReadWriteAttribute()) {
            indentingWriter.p("readonly ");
        }
        indentingWriter.p("attribute " + this.getQualifiedIDLName(type) + " ");
        indentingWriter.pln(method.getAttributeName() + ";");
    }

    protected void writeMethod(CompoundType.Method method, IndentingWriter indentingWriter) throws IOException {
        if (method.isAttribute()) {
            this.writeAttribute(method, indentingWriter);
            return;
        }
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        Type type = method.getReturnType();
        Hashtable hashtable = new Hashtable();
        this.getExceptions(method, hashtable);
        if (method.isConstructor()) {
            if (this.factory) {
                indentingWriter.p("factory " + method.getIDLName() + "(");
            } else {
                indentingWriter.p("init(");
            }
        } else {
            indentingWriter.p(this.getQualifiedIDLName(type));
            indentingWriter.p(" " + method.getIDLName() + "(");
        }
        indentingWriter.pI();
        int n = 0;
        while (n < typeArray.length) {
            if (n > 0) {
                indentingWriter.pln(",");
            } else {
                indentingWriter.pln();
            }
            indentingWriter.p("in ");
            indentingWriter.p(this.getQualifiedIDLName(typeArray[n]));
            indentingWriter.p(" " + stringArray[n]);
            ++n;
        }
        indentingWriter.pO();
        indentingWriter.p(" )");
        if (hashtable.size() > 0) {
            indentingWriter.pln(" raises (");
            indentingWriter.pI();
            int n2 = 0;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                ValueType valueType = (ValueType)enumeration.nextElement();
                if (n2 > 0) {
                    indentingWriter.pln(",");
                }
                if (valueType.isIDLEntityException()) {
                    if (valueType.isCORBAUserException()) {
                        indentingWriter.p("::org::omg::CORBA::UserEx");
                    } else {
                        String[] stringArray2 = this.getIDLModuleNames(valueType);
                        int n3 = 0;
                        while (n3 < stringArray2.length) {
                            indentingWriter.p("::" + stringArray2[n3]);
                            ++n3;
                        }
                        indentingWriter.p("::" + valueType.getName());
                    }
                } else {
                    indentingWriter.p(valueType.getQualifiedIDLExceptionName(true));
                }
                ++n2;
            }
            indentingWriter.pO();
            indentingWriter.p(" )");
        }
        indentingWriter.pln(";");
    }

    protected String unEsc(String string) {
        if (string.startsWith("_")) {
            return string.substring(1);
        }
        return string;
    }

    protected void writeBanner(Type type, int n, boolean bl, IndentingWriter indentingWriter) throws IOException {
        Type type2;
        String[] stringArray = this.getIDLModuleNames(type);
        String string = this.unEsc(type.getIDLName());
        if (bl && type.isClass()) {
            type2 = (ClassType)type;
            string = this.unEsc(((CompoundType)type2).getIDLExceptionName());
        }
        if (n > 0 && type.isArray()) {
            type2 = type.getElementType();
            string = "seq" + n + "_" + this.unEsc(type2.getIDLName().replace(' ', '_'));
        }
        indentingWriter.pln("/**");
        indentingWriter.p(" * ");
        int n2 = 0;
        while (n2 < stringArray.length) {
            indentingWriter.p(stringArray[n2] + "/");
            ++n2;
        }
        indentingWriter.pln(string + ".idl");
        indentingWriter.pln(" * Generated by rmic -idl. Do not edit");
        String string2 = DateFormat.getDateTimeInstance(0, 0, Locale.getDefault()).format(new Date());
        String string3 = "o'clock";
        int n3 = string2.indexOf(string3);
        indentingWriter.p(" * ");
        if (n3 > -1) {
            indentingWriter.pln(string2.substring(0, n3) + string2.substring(n3 + string3.length()));
        } else {
            indentingWriter.pln(string2);
        }
        indentingWriter.pln(" */");
        indentingWriter.pln();
    }

    protected void writeIncOrb(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("#include \"orb.idl\"");
    }

    protected void writeIfndef(Type type, int n, boolean bl, boolean bl2, IndentingWriter indentingWriter) throws IOException {
        Type type2;
        String[] stringArray = this.getIDLModuleNames(type);
        String string = this.unEsc(type.getIDLName());
        if (bl && type.isClass()) {
            type2 = (ClassType)type;
            string = this.unEsc(((CompoundType)type2).getIDLExceptionName());
        }
        if (n > 0 && type.isArray()) {
            type2 = type.getElementType();
            string = "seq" + n + "_" + this.unEsc(type2.getIDLName().replace(' ', '_'));
        }
        indentingWriter.pln();
        indentingWriter.p("#ifndef __");
        int n2 = 0;
        while (n2 < stringArray.length) {
            indentingWriter.p(stringArray[n2] + "_");
            ++n2;
        }
        indentingWriter.pln(string + "__");
        if (!bl2) {
            indentingWriter.p("#define __");
            int n3 = 0;
            while (n3 < stringArray.length) {
                indentingWriter.p(stringArray[n3] + "_");
                ++n3;
            }
            indentingWriter.pln(string + "__");
            indentingWriter.pln();
        }
    }

    protected void writeEndif(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("#endif");
        indentingWriter.pln();
    }

    protected void writeModule1(Type type, IndentingWriter indentingWriter) throws IOException {
        String[] stringArray = this.getIDLModuleNames(type);
        indentingWriter.pln();
        int n = 0;
        while (n < stringArray.length) {
            indentingWriter.pln("module " + stringArray[n] + " {");
            ++n;
        }
    }

    protected void writeModule2(Type type, IndentingWriter indentingWriter) throws IOException {
        String[] stringArray = this.getIDLModuleNames(type);
        int n = 0;
        while (n < stringArray.length) {
            indentingWriter.pln("};");
            ++n;
        }
        indentingWriter.pln();
    }
}

