/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.rmic.BatchEnvironment;
import sun.rmi.rmic.Constants;
import sun.rmi.rmic.Names;
import sun.rmi.rmic.RMIConstants;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;

public class RemoteClass
implements RMIConstants {
    private BatchEnvironment env;
    private ClassDefinition implClassDef;
    private ClassDefinition[] remoteInterfaces;
    private Method[] remoteMethods;
    private long interfaceHash;
    private ClassDefinition defRemote;
    private ClassDefinition defException;
    private ClassDefinition defRemoteException;

    public static RemoteClass forClass(BatchEnvironment batchEnvironment, ClassDefinition classDefinition) {
        RemoteClass remoteClass = new RemoteClass(batchEnvironment, classDefinition);
        if (remoteClass.initialize()) {
            return remoteClass;
        }
        return null;
    }

    public ClassDefinition getClassDefinition() {
        return this.implClassDef;
    }

    public Identifier getName() {
        return this.implClassDef.getName();
    }

    public ClassDefinition[] getRemoteInterfaces() {
        return (ClassDefinition[])this.remoteInterfaces.clone();
    }

    public Method[] getRemoteMethods() {
        return (Method[])this.remoteMethods.clone();
    }

    public long getInterfaceHash() {
        return this.interfaceHash;
    }

    public String toString() {
        return "remote class " + this.implClassDef.getName().toString();
    }

    private RemoteClass(BatchEnvironment batchEnvironment, ClassDefinition classDefinition) {
        this.env = batchEnvironment;
        this.implClassDef = classDefinition;
    }

    private boolean initialize() {
        int n;
        ClassDeclaration[] classDeclarationArray;
        String[] stringArray;
        ClassDefinition classDefinition;
        int n2;
        ClassDeclaration[] classDeclarationArray2;
        if (this.implClassDef.isInterface()) {
            this.env.error(0L, "rmic.cant.make.stubs.for.interface", this.implClassDef.getName());
            return false;
        }
        try {
            this.defRemote = this.env.getClassDeclaration(Constants.idRemote).getClassDefinition((Environment)this.env);
            this.defException = this.env.getClassDeclaration(sun.tools.java.Constants.idJavaLangException).getClassDefinition((Environment)this.env);
            this.defRemoteException = this.env.getClassDeclaration(Constants.idRemoteException).getClassDefinition((Environment)this.env);
        }
        catch (ClassNotFound classNotFound) {
            this.env.error(0L, "rmic.class.not.found", classNotFound.name);
            return false;
        }
        Vector<ClassDefinition> vector = new Vector<ClassDefinition>();
        ClassDefinition classDefinition2 = this.implClassDef;
        while (classDefinition2 != null) {
            try {
                classDeclarationArray2 = classDefinition2.getInterfaces();
                n2 = 0;
                while (n2 < classDeclarationArray2.length) {
                    classDefinition = classDeclarationArray2[n2].getClassDefinition((Environment)this.env);
                    if (!vector.contains(classDefinition) && this.defRemote.implementedBy((Environment)this.env, classDeclarationArray2[n2])) {
                        vector.addElement(classDefinition);
                        if (this.env.verbose()) {
                            System.out.println("[found remote interface: " + classDefinition.getName() + "]");
                        }
                    }
                    ++n2;
                }
                if (classDefinition2 == this.implClassDef && vector.isEmpty()) {
                    if (this.defRemote.implementedBy((Environment)this.env, this.implClassDef.getClassDeclaration())) {
                        this.env.error(0L, "rmic.must.implement.remote.directly", this.implClassDef.getName());
                    } else {
                        this.env.error(0L, "rmic.must.implement.remote", this.implClassDef.getName());
                    }
                    return false;
                }
                classDefinition2 = classDefinition2.getSuperClass() != null ? classDefinition2.getSuperClass().getClassDefinition((Environment)this.env) : null;
            }
            catch (ClassNotFound classNotFound) {
                this.env.error(0L, "class.not.found", classNotFound.name, classDefinition2.getName());
                return false;
            }
        }
        classDeclarationArray2 = new Hashtable();
        n2 = 0;
        classDefinition = vector.elements();
        while (classDefinition.hasMoreElements()) {
            stringArray = (String[])classDefinition.nextElement();
            if (this.collectRemoteMethods((ClassDefinition)stringArray, (Hashtable)classDeclarationArray2)) continue;
            n2 = 1;
        }
        if (n2 != 0) {
            return false;
        }
        this.remoteInterfaces = new ClassDefinition[vector.size()];
        vector.copyInto(this.remoteInterfaces);
        stringArray = new String[classDeclarationArray2.size()];
        int n3 = 0;
        Enumeration enumeration = classDeclarationArray2.elements();
        while (enumeration.hasMoreElements()) {
            Method method = (Method)enumeration.nextElement();
            classDeclarationArray = method.getNameAndDescriptor();
            n = n3;
            while (n > 0) {
                if (classDeclarationArray.compareTo(stringArray[n - 1]) >= 0) break;
                stringArray[n] = stringArray[n - 1];
                --n;
            }
            stringArray[n] = classDeclarationArray;
            ++n3;
        }
        this.remoteMethods = new Method[classDeclarationArray2.size()];
        int n4 = 0;
        while (n4 < this.remoteMethods.length) {
            this.remoteMethods[n4] = (Method)classDeclarationArray2.get(stringArray[n4]);
            if (this.env.verbose()) {
                System.out.print("[found remote method <" + n4 + ">: " + this.remoteMethods[n4].getOperationString());
                classDeclarationArray = this.remoteMethods[n4].getExceptions();
                if (classDeclarationArray.length > 0) {
                    System.out.print(" throws ");
                }
                n = 0;
                while (n < classDeclarationArray.length) {
                    if (n > 0) {
                        System.out.print(", ");
                    }
                    System.out.print(classDeclarationArray[n].getName());
                    ++n;
                }
                System.out.println("]");
            }
            ++n4;
        }
        this.interfaceHash = this.computeInterfaceHash();
        return true;
    }

    private boolean collectRemoteMethods(ClassDefinition classDefinition, Hashtable hashtable) {
        int n;
        ClassDeclaration[] classDeclarationArray;
        if (!classDefinition.isInterface()) {
            throw new Error("expected interface, not class: " + classDefinition.getName());
        }
        boolean bl = false;
        MemberDefinition memberDefinition = classDefinition.getFirstMember();
        while (memberDefinition != null) {
            block19: {
                if (memberDefinition.isMethod() && !memberDefinition.isConstructor() && !memberDefinition.isInitializer()) {
                    classDeclarationArray = memberDefinition.getExceptions((Environment)this.env);
                    n = 0;
                    int n2 = 0;
                    while (n2 < classDeclarationArray.length) {
                        try {
                            if (this.defRemoteException.subClassOf((Environment)this.env, classDeclarationArray[n2])) {
                                n = 1;
                                break;
                            }
                        }
                        catch (ClassNotFound classNotFound) {
                            this.env.error(0L, "class.not.found", classNotFound.name, classDefinition.getName());
                            break block19;
                        }
                        ++n2;
                    }
                    if (n == 0) {
                        this.env.error(0L, "rmic.must.throw.remoteexception", classDefinition.getName(), memberDefinition.toString());
                        bl = true;
                    } else {
                        Object object;
                        block20: {
                            try {
                                object = this.implClassDef.findMethod((Environment)this.env, memberDefinition.getName(), memberDefinition.getType());
                                if (object == null) break block20;
                                classDeclarationArray = object.getExceptions((Environment)this.env);
                                int n3 = 0;
                                while (n3 < classDeclarationArray.length) {
                                    if (!this.defException.superClassOf((Environment)this.env, classDeclarationArray[n3])) {
                                        this.env.error(0L, "rmic.must.only.throw.exception", object.toString(), classDeclarationArray[n3].getName());
                                        bl = true;
                                        break block19;
                                    }
                                    ++n3;
                                }
                            }
                            catch (ClassNotFound classNotFound) {
                                this.env.error(0L, "class.not.found", classNotFound.name, this.implClassDef.getName());
                                break block19;
                            }
                        }
                        object = new Method(memberDefinition);
                        String string = ((Method)object).getNameAndDescriptor();
                        Method method = (Method)hashtable.get(string);
                        if (method != null && (object = ((Method)object).mergeWith(method)) == null) {
                            bl = true;
                        } else {
                            hashtable.put(string, object);
                        }
                    }
                }
            }
            memberDefinition = memberDefinition.getNextMember();
        }
        try {
            classDeclarationArray = classDefinition.getInterfaces();
            n = 0;
            while (n < classDeclarationArray.length) {
                ClassDefinition classDefinition2 = classDeclarationArray[n].getClassDefinition((Environment)this.env);
                if (!this.collectRemoteMethods(classDefinition2, hashtable)) {
                    bl = true;
                }
                ++n;
            }
        }
        catch (ClassNotFound classNotFound) {
            this.env.error(0L, "class.not.found", classNotFound.name, classDefinition.getName());
            return false;
        }
        return !bl;
    }

    private long computeInterfaceHash() {
        long l = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        try {
            Object object;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(byteArrayOutputStream, messageDigest));
            dataOutputStream.writeInt(1);
            int n = 0;
            while (n < this.remoteMethods.length) {
                object = this.remoteMethods[n].getMemberDefinition();
                Identifier identifier = object.getName();
                Type type = object.getType();
                dataOutputStream.writeUTF(identifier.toString());
                dataOutputStream.writeUTF(type.getTypeSignature());
                ClassDeclaration[] classDeclarationArray = object.getExceptions((Environment)this.env);
                this.sortClassDeclarations(classDeclarationArray);
                int n2 = 0;
                while (n2 < classDeclarationArray.length) {
                    dataOutputStream.writeUTF(Names.mangleClass(classDeclarationArray[n2].getName()).toString());
                    ++n2;
                }
                ++n;
            }
            dataOutputStream.flush();
            object = messageDigest.digest();
            int n3 = 0;
            while (n3 < Math.min(8, ((byte[])object).length)) {
                l += (long)(object[n3] & 0xFF) << n3 * 8;
                ++n3;
            }
        }
        catch (IOException iOException) {
            throw new Error("unexpected exception computing intetrface hash: " + iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("unexpected exception computing intetrface hash: " + noSuchAlgorithmException);
        }
        return l;
    }

    private void sortClassDeclarations(ClassDeclaration[] classDeclarationArray) {
        int n = 1;
        while (n < classDeclarationArray.length) {
            ClassDeclaration classDeclaration = classDeclarationArray[n];
            String string = Names.mangleClass(classDeclaration.getName()).toString();
            int n2 = n;
            while (n2 > 0) {
                if (string.compareTo(Names.mangleClass(classDeclarationArray[n2 - 1].getName()).toString()) >= 0) break;
                classDeclarationArray[n2] = classDeclarationArray[n2 - 1];
                --n2;
            }
            classDeclarationArray[n2] = classDeclaration;
            ++n;
        }
    }

    public class Method
    implements Cloneable {
        private MemberDefinition memberDef;
        private long methodHash;
        private ClassDeclaration[] exceptions;

        public MemberDefinition getMemberDefinition() {
            return this.memberDef;
        }

        public Identifier getName() {
            return this.memberDef.getName();
        }

        public Type getType() {
            return this.memberDef.getType();
        }

        public ClassDeclaration[] getExceptions() {
            return (ClassDeclaration[])this.exceptions.clone();
        }

        public long getMethodHash() {
            return this.methodHash;
        }

        public String toString() {
            return this.memberDef.toString();
        }

        public String getOperationString() {
            return this.memberDef.toString();
        }

        public String getNameAndDescriptor() {
            return this.memberDef.getName().toString() + this.memberDef.getType().getTypeSignature();
        }

        Method(MemberDefinition memberDefinition) {
            this.memberDef = memberDefinition;
            this.exceptions = memberDefinition.getExceptions((Environment)RemoteClass.this.env);
            this.methodHash = this.computeMethodHash();
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("clone failed");
            }
        }

        private Method mergeWith(Method method) {
            if (!this.getName().equals(method.getName()) || !this.getType().equals(method.getType())) {
                throw new Error("attempt to merge method \"" + method.getNameAndDescriptor() + "\" with \"" + this.getNameAndDescriptor());
            }
            Vector vector = new Vector();
            try {
                this.collectCompatibleExceptions(method.exceptions, this.exceptions, vector);
                this.collectCompatibleExceptions(this.exceptions, method.exceptions, vector);
            }
            catch (ClassNotFound classNotFound) {
                RemoteClass.this.env.error(0L, "class.not.found", classNotFound.name, RemoteClass.this.getClassDefinition().getName());
                return null;
            }
            Method method2 = (Method)this.clone();
            method2.exceptions = new ClassDeclaration[vector.size()];
            vector.copyInto(method2.exceptions);
            return method2;
        }

        private void collectCompatibleExceptions(ClassDeclaration[] classDeclarationArray, ClassDeclaration[] classDeclarationArray2, Vector vector) throws ClassNotFound {
            int n = 0;
            while (n < classDeclarationArray.length) {
                ClassDefinition classDefinition = classDeclarationArray[n].getClassDefinition((Environment)RemoteClass.this.env);
                if (!vector.contains(classDeclarationArray[n])) {
                    int n2 = 0;
                    while (n2 < classDeclarationArray2.length) {
                        if (classDefinition.subClassOf((Environment)RemoteClass.this.env, classDeclarationArray2[n2])) {
                            vector.addElement(classDeclarationArray[n]);
                            break;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }

        private long computeMethodHash() {
            long l = 0L;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(byteArrayOutputStream, messageDigest));
                String string = this.getNameAndDescriptor();
                if (RemoteClass.this.env.verbose()) {
                    System.out.println("[string used for method hash: \"" + string + "\"]");
                }
                dataOutputStream.writeUTF(string);
                dataOutputStream.flush();
                byte[] byArray = messageDigest.digest();
                int n = 0;
                while (n < Math.min(8, byArray.length)) {
                    l += (long)(byArray[n] & 0xFF) << n * 8;
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw new Error("unexpected exception computing intetrface hash: " + iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new Error("unexpected exception computing intetrface hash: " + noSuchAlgorithmException);
            }
            return l;
        }
    }
}

