/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class Attribute
implements ASN1Value {
    private OBJECT_IDENTIFIER type;
    private SET values;
    public static final Tag TAG = SEQUENCE.TAG;
    private static Template templateInstance = new Template();

    private Attribute() {
    }

    public Attribute(OBJECT_IDENTIFIER oBJECT_IDENTIFIER, ASN1Value aSN1Value) {
        this.type = oBJECT_IDENTIFIER;
        this.values = new SET();
        this.values.addElement(aSN1Value);
    }

    public Attribute(OBJECT_IDENTIFIER oBJECT_IDENTIFIER, SET sET) {
        this.type = oBJECT_IDENTIFIER;
        this.values = sET;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(this.type);
        sEQUENCE.addElement(this.values);
        sEQUENCE.encode(tag, outputStream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public OBJECT_IDENTIFIER getType() {
        return this.type;
    }

    public SET getValues() {
        return this.values;
    }

    public static class Template
    implements ASN1Template {
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE.Template template = new SEQUENCE.Template();
            template.addElement(new OBJECT_IDENTIFIER.Template());
            template.addElement(new SET.OF_Template(new ANY.Template()));
            SEQUENCE sEQUENCE = (SEQUENCE)template.decode(tag, inputStream);
            Assert.assert(sEQUENCE.size() == 2);
            return new Attribute((OBJECT_IDENTIFIER)sEQUENCE.elementAt(0), (SET)sEQUENCE.elementAt(1));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }
    }
}

