/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkcs10.CertificationRequest;
import org.mozilla.jss.util.Assert;

public class TaggedCertificationRequest
implements ASN1Value {
    public static final INTEGER BODYIDMAX = new INTEGER("4294967295");
    private SEQUENCE sequence;
    private INTEGER bodyPartID;
    private CertificationRequest certificationRequest;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private TaggedCertificationRequest() {
    }

    public TaggedCertificationRequest(INTEGER iNTEGER, CertificationRequest certificationRequest) {
        this.sequence = new SEQUENCE();
        Assert.assert(iNTEGER.compareTo(BODYIDMAX) <= 0);
        this.bodyPartID = iNTEGER;
        this.sequence.addElement(iNTEGER);
        this.certificationRequest = certificationRequest;
        this.sequence.addElement(certificationRequest);
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public INTEGER getBodyPartID() {
        return this.bodyPartID;
    }

    public CertificationRequest getCertificationRequest() {
        return this.certificationRequest;
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(CertificationRequest.getTemplate());
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            Assert.assert(sEQUENCE.size() == 2);
            return new TaggedCertificationRequest((INTEGER)sEQUENCE.elementAt(0), (CertificationRequest)sEQUENCE.elementAt(1));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }
    }
}

