/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.DigestAlgorithm;

public class SignatureAlgorithm
extends Algorithm {
    private static Hashtable oidMap = new Hashtable();
    private SignatureAlgorithm signingAlg;
    private DigestAlgorithm digestAlg;
    public static final SignatureAlgorithm RSASignature = new SignatureAlgorithm(4, "RSA", null, null, OBJECT_IDENTIFIER.PKCS1.subBranch(1L));
    public static final SignatureAlgorithm DSASignature = new SignatureAlgorithm(7, "DSA", null, null, Algorithm.ANSI_X9_ALGORITHM.subBranch(1L));
    public static final SignatureAlgorithm RSASignatureWithMD2Digest = new SignatureAlgorithm(0, "RSASignatureWithMD2Digest", RSASignature, DigestAlgorithm.MD2, OBJECT_IDENTIFIER.PKCS1.subBranch(2L));
    public static final SignatureAlgorithm RSASignatureWithMD5Digest = new SignatureAlgorithm(1, "RSASignatureWithMD5Digest", RSASignature, DigestAlgorithm.MD5, OBJECT_IDENTIFIER.PKCS1.subBranch(4L));
    public static final SignatureAlgorithm RSASignatureWithSHA1Digest = new SignatureAlgorithm(2, "RSASignatureWithSHA1Digest", RSASignature, DigestAlgorithm.SHA1, OBJECT_IDENTIFIER.PKCS1.subBranch(5L));
    public static final SignatureAlgorithm DSASignatureWithSHA1Digest = new SignatureAlgorithm(3, "DSASignatureWithSHA1Digest", DSASignature, DigestAlgorithm.SHA1, Algorithm.ANSI_X9_ALGORITHM.subBranch(3L));

    protected SignatureAlgorithm(int n, String string, SignatureAlgorithm signatureAlgorithm, DigestAlgorithm digestAlgorithm, OBJECT_IDENTIFIER oBJECT_IDENTIFIER) {
        super(n, string, oBJECT_IDENTIFIER);
        this.signingAlg = signatureAlgorithm == null ? this : signatureAlgorithm;
        this.digestAlg = digestAlgorithm;
        oidMap.put(oBJECT_IDENTIFIER, this);
    }

    public static SignatureAlgorithm fromOID(OBJECT_IDENTIFIER oBJECT_IDENTIFIER) throws NoSuchAlgorithmException {
        Object v = oidMap.get(oBJECT_IDENTIFIER);
        if (v == null) {
            throw new NoSuchAlgorithmException();
        }
        return (SignatureAlgorithm)v;
    }

    public DigestAlgorithm getDigestAlg() throws NoSuchAlgorithmException {
        if (this.digestAlg == null) {
            throw new NoSuchAlgorithmException();
        }
        return this.digestAlg;
    }

    public SignatureAlgorithm getRawAlg() {
        return this.signingAlg;
    }

    public Algorithm getSigningAlg() {
        return this.signingAlg;
    }
}

