/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CharConverter;
import org.mozilla.jss.asn1.CharacterString;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class UTF8String
extends CharacterString
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.UNIVERSAL, 12L);
    public static final Form FORM = Form.PRIMITIVE;
    private static final Template templateInstance = new Template();

    public UTF8String(String string) throws CharConversionException {
        super(string);
    }

    public UTF8String(char[] cArray) throws CharConversionException {
        super(cArray);
    }

    CharConverter getCharConverter() {
        return new UTF8Converter();
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    extends CharacterString.Template
    implements ASN1Template {
        protected CharacterString generateInstance(char[] cArray) throws CharConversionException {
            return new UTF8String(cArray);
        }

        protected CharConverter getCharConverter() {
            return new UTF8Converter();
        }

        protected Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        protected String typeName() {
            return "UTF8String";
        }
    }

    private static class UTF8Converter
    implements CharConverter {
        UTF8Converter() {
        }

        public char[] byteToChar(byte[] byArray, int n, int n2) throws CharConversionException {
            try {
                String string = new String(byArray, n, n2, "UTF8");
                return string.toCharArray();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string = "Unable to find UTF8 encoding mechanism";
                Assert.notReached(string);
                throw new CharConversionException(string);
            }
        }

        public byte[] charToByte(char[] cArray, int n, int n2) throws CharConversionException {
            try {
                String string = new String(cArray, n, n2);
                return string.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string = "Unable to find UTF8 encoding mechanism";
                Assert.notReached(string);
                throw new CharConversionException(string);
            }
        }
    }
}

