/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletException;
import org.apache.jasper.core.JasperException;
import org.apache.jasper.logging.DefaultLogger;
import org.apache.jasper.logging.LogAware;
import org.apache.jasper.util.FastDateFormat;
import org.xml.sax.SAXException;

public abstract class Logger {
    public static final int FATAL = Integer.MIN_VALUE;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFORMATION = 3;
    public static final int DEBUG = 4;
    protected static Writer defaultSink = new OutputStreamWriter(System.err);
    protected static Hashtable loggers = new Hashtable(5);
    protected static Logger defaultLogger = new DefaultLogger();
    protected boolean custom = true;
    protected Writer sink = defaultSink;
    String path;
    protected String name;
    private int level = 2;
    protected boolean timestamp = true;
    protected boolean timestampRaw = false;
    protected String timestampFormat = "yyyy-MM-dd hh:mm:ss";
    protected DateFormat timestampFormatter = new FastDateFormat(new SimpleDateFormat(this.timestampFormat));
    private static FieldPosition position;

    public static void setDefaultSink(Writer writer) {
        defaultSink = writer;
    }

    public static Logger getLogger(String string) {
        return (Logger)loggers.get(string);
    }

    public static Logger getDefaultLogger() {
        return defaultLogger;
    }

    public static Enumeration getLoggerNames() {
        return loggers.keys();
    }

    public static void putLogger(Logger logger) {
        loggers.put(logger.getName(), logger);
    }

    public static void removeLogger(Logger logger) {
        loggers.remove(logger.getName());
    }

    public static String throwableToString(Throwable throwable) {
        return Logger.throwableToString(throwable, "Root cause:");
    }

    public static String throwableToString(Throwable throwable, String string) {
        if (string == null) {
            string = "Root Cause:";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Logger.printThrowable(printWriter, throwable, string);
        printWriter.flush();
        return stringWriter.toString();
    }

    private static void printThrowable(PrintWriter printWriter, Throwable throwable, String string) {
        if (throwable != null) {
            Exception exception;
            throwable.printStackTrace(printWriter);
            if (throwable instanceof ServletException) {
                Throwable throwable2 = ((ServletException)throwable).getRootCause();
                if (throwable2 != null) {
                    printWriter.println(string);
                    Logger.printThrowable(printWriter, throwable2, string);
                }
            } else if (throwable instanceof JasperException) {
                Throwable throwable3 = ((JasperException)throwable).getRootCause();
                if (throwable3 != null) {
                    printWriter.println(string);
                    Logger.printThrowable(printWriter, throwable3, string);
                }
            } else if (throwable instanceof SQLException) {
                SQLException sQLException = ((SQLException)throwable).getNextException();
                if (sQLException != null) {
                    printWriter.println("Next SQL Exception:");
                    Logger.printThrowable(printWriter, sQLException, string);
                }
            } else if (throwable instanceof SAXException && (exception = ((SAXException)throwable).getException()) != null) {
                printWriter.println("Embedded SAX Exception:");
                Logger.printThrowable(printWriter, exception, string);
            }
        }
    }

    public static boolean canIgnore(Throwable throwable) {
        String string = throwable.getMessage();
        if (throwable instanceof InterruptedIOException) {
            return true;
        }
        return throwable instanceof IOException ? "Broken pipe".equals(string) : throwable instanceof SocketException;
    }

    public boolean isOpen() {
        return this.sink != null;
    }

    public final void log(String string) {
        this.log(string, 3);
    }

    public final void log(String string, int n) {
        this.log(string, null, n);
    }

    public final void log(String string, Throwable throwable) {
        this.log(string, throwable, 1);
    }

    public final void log(String string, Throwable throwable, int n) {
        if (this.matchVerbosityLevel(n)) {
            if (throwable == null) {
                this.realLog(string);
            } else {
                this.realLog(string, throwable);
            }
        }
    }

    public boolean matchVerbosityLevel(int n) {
        return n <= this.getVerbosityLevel();
    }

    protected abstract void realLog(String var1);

    protected abstract void realLog(String var1, Throwable var2);

    public abstract void flush();

    public synchronized void close() {
        this.sink = null;
        loggers.remove(this.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        Logger.putLogger(this);
    }

    public void setPath(String string) {
        if (File.separatorChar == '/') {
            this.path = string.replace('\\', '/');
        } else if (File.separatorChar == '\\') {
            this.path = string.replace('/', '\\');
        }
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return "Logger(" + this.getName() + ", " + this.getPath() + ")";
    }

    public void open() {
        if (this.path == null) {
            return;
        }
        try {
            File file = new File(this.path);
            if (!file.exists()) {
                new File(file.getParent()).mkdirs();
            }
            this.sink = new FileWriter(this.path);
        }
        catch (IOException iOException) {
            System.err.print("Unable to open log file: " + this.path + "! ");
            System.err.println(" Using stderr as the default.");
            this.sink = defaultSink;
        }
    }

    public void setVerbosityLevel(String string) {
        if ("warning".equalsIgnoreCase(string)) {
            this.level = 2;
        } else if ("fatal".equalsIgnoreCase(string)) {
            this.level = Integer.MIN_VALUE;
        } else if ("error".equalsIgnoreCase(string)) {
            this.level = 1;
        } else if ("information".equalsIgnoreCase(string)) {
            this.level = 3;
        } else if ("debug".equalsIgnoreCase(string)) {
            this.level = 4;
        }
    }

    public void setVerbosityLevel(int n) {
        this.level = n;
    }

    public int getVerbosityLevel() {
        return this.level;
    }

    public void setTimestamp(String string) {
        if ("true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string)) {
            this.timestamp = true;
        } else if ("false".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string)) {
            this.timestamp = false;
        }
    }

    public boolean isTimestamp() {
        return this.timestamp;
    }

    public void setTimestampFormat(String string) {
        if (string.equalsIgnoreCase("msec")) {
            this.timestampRaw = true;
        } else {
            this.timestampRaw = false;
            this.timestampFormat = string;
            this.timestampFormatter = new FastDateFormat(new SimpleDateFormat(this.timestampFormat));
        }
    }

    public String getTimestampFormat() {
        if (this.timestampRaw) {
            return "msec";
        }
        return this.timestampFormat;
    }

    public void setCustomOutput(String string) {
        if ("true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string)) {
            this.custom = true;
        } else if ("false".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string)) {
            this.custom = false;
        }
    }

    protected String formatTimestamp(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        this.formatTimestamp(l, stringBuffer);
        return stringBuffer.toString();
    }

    protected void formatTimestamp(long l, StringBuffer stringBuffer) {
        if (!this.timestamp) {
            return;
        }
        if (this.timestampRaw) {
            stringBuffer.append(Long.toString(l));
            return;
        }
        Date date = new Date(l);
        this.timestampFormatter.format(date, stringBuffer, position);
    }

    static {
        defaultLogger.setVerbosityLevel(4);
        position = new FieldPosition(1);
    }

    public static class Helper
    implements LogAware {
        private String logname;
        private String prefix;
        private Logger logger;
        private Helper proxy;

        protected Helper(String string) {
            this.logname = string;
            String string2 = this.getClass().getName();
            this.prefix = string2.substring(string2.lastIndexOf(".") + 1);
        }

        public Helper(String string, Object object) {
            this.logname = string;
            String string2 = object.getClass().getName();
            this.prefix = string2.substring(string2.lastIndexOf(".") + 1);
        }

        public Helper(String string, String string2) {
            this.logname = string;
            this.prefix = string2;
        }

        public Logger getLogger() {
            if (this.proxy != null) {
                this.logger = this.proxy.getLogger();
            }
            return this.logger;
        }

        public void setLogger(Logger logger) {
            if (logger != null) {
                this.setLogname(logger.getName());
            }
            this.logger = logger;
        }

        public void setLogname(String string) {
            this.logger = null;
            this.logname = string;
        }

        public void setLogPrefix(String string) {
            this.prefix = string;
        }

        public void setProxy(Helper helper) {
            this.proxy = helper;
        }

        public Helper getLoggerHelper() {
            return this;
        }

        public void log(String string) {
            this.log(string, null, 3);
        }

        public void log(String string, Throwable throwable) {
            this.log(string, throwable, 1);
        }

        public void log(String string, int n) {
            this.log(string, null, n);
        }

        public void log(String string, Throwable throwable, int n) {
            Logger logger;
            if (this.prefix != null) {
                string = this.prefix + ": " + string;
            }
            if (this.proxy != null) {
                this.logger = this.proxy.getLogger();
            }
            if (this.logger == null && this.logname != null) {
                this.logger = Logger.getLogger(this.logname);
            }
            if ((logger = this.logger) == null) {
                logger = defaultLogger;
            }
            logger.log(string, throwable, n);
        }
    }
}

