/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.IOException;
import java.io.InputStreamReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.ParserXJspSaxHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ParserXJspSax {
    private InputSource is;
    private String filePath;
    private ParseEventListener jspHandler;
    private static final boolean validate = false;
    static final String[] lexicalHandlerPropNames = new String[]{"http://xml.org/sax/handlers/LexicalHandler", "http://xml.org/sax/properties/lexical-handler"};

    public ParserXJspSax(String string, InputStreamReader inputStreamReader, ParseEventListener parseEventListener) {
        this.filePath = string;
        this.is = new InputSource(inputStreamReader);
        this.jspHandler = parseEventListener;
    }

    public void parse() throws JasperException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            ParserXJspSaxHandler parserXJspSaxHandler = new ParserXJspSaxHandler(this.filePath, this.jspHandler);
            xMLReader.setContentHandler(parserXJspSaxHandler);
            xMLReader.setEntityResolver(parserXJspSaxHandler);
            xMLReader.setDTDHandler(parserXJspSaxHandler);
            xMLReader.setErrorHandler(parserXJspSaxHandler);
            int n = 0;
            while (n < lexicalHandlerPropNames.length) {
                if (this.setSaxProperty(xMLReader, parserXJspSaxHandler, lexicalHandlerPropNames[n])) break;
                ++n;
            }
            try {
                xMLReader.setFeature("http://xml.org/sax/features/validation", false);
                xMLReader.setFeature("http://xml.org/sax/features/namespaces", false);
                xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                throw new JasperException(Constants.getString("jsp.parser.sax.featurenotsupported", new Object[]{sAXNotSupportedException.getMessage()}));
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                throw new JasperException(Constants.getString("jsp.parser.sax.featurenotrecognized", new Object[]{sAXNotRecognizedException.getMessage()}));
            }
            xMLReader.parse(this.is);
        }
        catch (IOException iOException) {
            throw new JasperException(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ParseException(parserConfigurationException.getMessage());
        }
        catch (SAXParseException sAXParseException) {
            Mark mark = new Mark(this.filePath, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
            String string = sAXParseException.getException() != null ? sAXParseException.getException().getMessage() : sAXParseException.getMessage();
            throw new ParseException(mark, string);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            throw new JasperException(exception);
        }
    }

    private boolean setSaxProperty(XMLReader xMLReader, DefaultHandler defaultHandler, String string) {
        try {
            xMLReader.setProperty(string, defaultHandler);
            return true;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            Constants.message("jsp.parser.sax.propertynotsupported", new Object[]{sAXNotSupportedException.getMessage()}, 2);
            return false;
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            Constants.message("jsp.parser.sax.propertynotrecognized", new Object[]{sAXNotRecognizedException.getMessage()}, 2);
            return false;
        }
    }
}

