/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import javax.management.AttributeChangeNotification;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.catalina.startup.Bootstrap;
import org.apache.catalina.startup.CatalinaManagerMBean;

public final class CatalinaManager
extends NotificationBroadcasterSupport
implements CatalinaManagerMBean,
MBeanRegistration {
    private int state = 0;
    private long sequenceNumber = 0L;

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        return new ObjectName(":service=Catalina");
    }

    public void postRegister(Boolean bl) {
        if (!bl.booleanValue()) {
            this.destroy();
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.destroy();
    }

    public String getName() {
        return "Catalina servlet container";
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return CatalinaManagerMBean.states[this.state];
    }

    public String getPath() {
        return System.getProperty("catalina.home");
    }

    public void setPath(String string) {
        System.setProperty("catalina.home", string);
    }

    public void start() throws Exception {
        AttributeChangeNotification attributeChangeNotification = null;
        if (this.state != 0) {
            return;
        }
        this.state = 2;
        attributeChangeNotification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Starting Catalina servlet container", "State", "java.lang.Integer", new Integer(0), new Integer(2));
        this.sendNotification(attributeChangeNotification);
        try {
            String[] stringArray = new String[]{"start"};
            Bootstrap.main(stringArray);
        }
        catch (Throwable throwable) {
            this.state = 0;
            attributeChangeNotification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopped Catalina servlet container", "State", "java.lang.Integer", new Integer(2), new Integer(0));
            this.sendNotification(attributeChangeNotification);
        }
        this.state = 3;
        attributeChangeNotification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Started Catalina servlet container", "State", "java.lang.Integer", new Integer(2), new Integer(3));
        this.sendNotification(attributeChangeNotification);
    }

    public void stop() {
        AttributeChangeNotification attributeChangeNotification = null;
        if (this.state != 3) {
            return;
        }
        this.state = 1;
        attributeChangeNotification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopping Catalina servlet container", "State", "java.lang.Integer", new Integer(3), new Integer(1));
        this.sendNotification(attributeChangeNotification);
        try {
            String[] stringArray = new String[]{"stop"};
            Bootstrap.main(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.state = 0;
        attributeChangeNotification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopped Catalina servlet container", "State", "java.lang.Integer", new Integer(1), new Integer(0));
        this.sendNotification(attributeChangeNotification);
    }

    public void destroy() {
        if (this.getState() != 0) {
            this.stop();
        }
    }
}

