/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.util.CustomObjectInputStream;

public class JDBCStore
extends StoreBase
implements Store {
    protected static String info = "JDBCStore/1.0";
    protected static String storeName = "JDBCStore";
    protected String threadName = "JDBCStore";
    protected String connString = null;
    private Connection conn = null;
    protected String driverName = null;
    protected String sessionTable = "tomcat$sessions";
    protected String sessionIdCol = "id";
    protected String sessionDataCol = "data";
    protected String sessionValidCol = "valid";
    protected String sessionMaxInactiveCol = "maxinactive";
    protected String sessionLastAccessedCol = "lastaccess";
    protected PreparedStatement preparedSizeSql = null;
    protected PreparedStatement preparedKeysSql = null;
    protected PreparedStatement preparedSaveSql = null;
    protected PreparedStatement preparedClearSql = null;
    protected PreparedStatement preparedRemoveSql = null;
    protected PreparedStatement preparedLoadSql = null;

    public String getInfo() {
        return info;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setDriverName(String string) {
        String string2 = this.driverName;
        this.driverName = string;
        this.support.firePropertyChange("driverName", string2, this.driverName);
        this.driverName = string;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setConnectionURL(String string) {
        String string2 = this.connString;
        this.connString = string;
        this.support.firePropertyChange("connString", string2, this.connString);
    }

    public String getConnectionURL() {
        return this.connString;
    }

    public void setSessionTable(String string) {
        String string2 = this.sessionTable;
        this.sessionTable = string;
        this.support.firePropertyChange("sessionTable", string2, this.sessionTable);
    }

    public String getSessionTable() {
        return this.sessionTable;
    }

    public void setSessionIdCol(String string) {
        String string2 = this.sessionIdCol;
        this.sessionIdCol = string;
        this.support.firePropertyChange("sessionIdCol", string2, this.sessionIdCol);
    }

    public String getSessionIdCol() {
        return this.sessionIdCol;
    }

    public void setSessionDataCol(String string) {
        String string2 = this.sessionDataCol;
        this.sessionDataCol = string;
        this.support.firePropertyChange("sessionDataCol", string2, this.sessionDataCol);
    }

    public String getSessionDataCol() {
        return this.sessionDataCol;
    }

    public void setSessionValidCol(String string) {
        String string2 = this.sessionValidCol;
        this.sessionValidCol = string;
        this.support.firePropertyChange("sessionValidCol", string2, this.sessionValidCol);
    }

    public String getSessionValidCol() {
        return this.sessionValidCol;
    }

    public void setSessionMaxInactiveCol(String string) {
        String string2 = this.sessionMaxInactiveCol;
        this.sessionMaxInactiveCol = string;
        this.support.firePropertyChange("sessionMaxInactiveCol", string2, this.sessionMaxInactiveCol);
    }

    public String getSessionMaxInactiveCol() {
        return this.sessionMaxInactiveCol;
    }

    public void setSessionLastAccessedCol(String string) {
        String string2 = this.sessionLastAccessedCol;
        this.sessionLastAccessedCol = string;
        this.support.firePropertyChange("sessionLastAccessedCol", string2, this.sessionLastAccessedCol);
    }

    public String getSessionLastAccessedCol() {
        return this.sessionLastAccessedCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] keys() throws IOException {
        String string = "SELECT COUNT(s." + this.sessionIdCol + "), c." + this.sessionIdCol + " FROM " + this.sessionTable + " s, " + this.sessionTable + " c" + " GROUP BY c." + this.sessionIdCol;
        Connection connection = this.getConnection();
        ResultSet resultSet = null;
        String[] stringArray = null;
        if (connection == null) {
            return new String[0];
        }
        try {
            if (this.preparedKeysSql == null) {
                this.preparedKeysSql = connection.prepareStatement(string);
            }
            if ((resultSet = this.preparedKeysSql.executeQuery()) != null && resultSet.next()) {
                stringArray = new String[resultSet.getInt(1)];
                stringArray[0] = resultSet.getString(2);
                int n = 1;
                while (resultSet.next()) {
                    stringArray[n++] = resultSet.getString(2);
                }
            } else {
                stringArray = new String[]{};
            }
        }
        catch (SQLException sQLException) {
            this.log(this.sm.getString(this.getStoreName() + ".SQLException", sQLException));
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            this.release(connection);
            connection = null;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() throws IOException {
        int n = 0;
        String string = "SELECT COUNT(" + this.sessionIdCol + ") FROM ".concat(this.sessionTable);
        Connection connection = this.getConnection();
        ResultSet resultSet = null;
        if (connection == null) {
            return n;
        }
        try {
            if (this.preparedSizeSql == null) {
                this.preparedSizeSql = connection.prepareStatement(string);
            }
            if ((resultSet = this.preparedSizeSql.executeQuery()).next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            this.log(this.sm.getString(this.getStoreName() + ".SQLException", sQLException));
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            this.release(connection);
            connection = null;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session load(String string) throws ClassNotFoundException, IOException {
        ResultSet resultSet = null;
        Connection connection = this.getConnection();
        StandardSession standardSession = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        ObjectInputStream objectInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Container container = this.manager.getContainer();
        String string2 = "SELECT " + this.sessionIdCol + ", " + this.sessionDataCol + " FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ?";
        if (connection == null) {
            return null;
        }
        try {
            if (this.preparedLoadSql == null) {
                this.preparedLoadSql = connection.prepareStatement(string2);
            }
            this.preparedLoadSql.setString(1, string);
            resultSet = this.preparedLoadSql.executeQuery();
            if (resultSet.next()) {
                bufferedInputStream = new BufferedInputStream(resultSet.getBinaryStream(2));
                if (container != null) {
                    loader = container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                objectInputStream = classLoader != null ? new CustomObjectInputStream(bufferedInputStream, classLoader) : new ObjectInputStream(bufferedInputStream);
            } else if (this.debug > 0) {
                this.log(this.getStoreName() + ": No persisted data object found");
            }
        }
        catch (SQLException sQLException) {
            this.log(this.sm.getString(this.getStoreName() + ".SQLException", sQLException));
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            this.release(connection);
            connection = null;
        }
        if (objectInputStream != null) {
            try {
                standardSession = (StandardSession)this.manager.createSession();
                standardSession.readObjectData(objectInputStream);
                standardSession.setManager(this.manager);
            }
            finally {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                        bufferedInputStream = null;
                    }
                    catch (IOException iOException) {}
                }
            }
            if (this.debug > 0) {
                this.log(this.sm.getString(this.getStoreName() + ".loading", string, this.sessionTable));
            }
        }
        return standardSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) throws IOException {
        Connection connection = this.getConnection();
        String string2 = "DELETE FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ?";
        if (connection == null) {
            return;
        }
        try {
            try {
                if (this.preparedRemoveSql == null) {
                    this.preparedRemoveSql = connection.prepareStatement(string2);
                }
                this.preparedRemoveSql.setString(1, string);
                this.preparedRemoveSql.execute();
            }
            catch (SQLException sQLException) {
                this.log(this.sm.getString(this.getStoreName() + ".SQLException", sQLException));
                Object var6_5 = null;
                this.release(connection);
                connection = null;
            }
            Object var6_4 = null;
            this.release(connection);
            connection = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.release(connection);
            connection = null;
            throw throwable;
        }
        if (this.debug > 0) {
            this.log(this.sm.getString(this.getStoreName() + ".removing", string, this.sessionTable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        Connection connection = this.getConnection();
        String string = "DELETE FROM ".concat(this.sessionTable);
        if (connection == null) {
            return;
        }
        try {
            try {
                if (this.preparedClearSql == null) {
                    this.preparedClearSql = connection.prepareStatement(string);
                }
                this.preparedClearSql.execute();
            }
            catch (SQLException sQLException) {
                this.log(this.sm.getString(this.getStoreName() + ".SQLException", sQLException));
                Object var5_4 = null;
                this.release(connection);
                connection = null;
            }
            Object var5_3 = null;
            this.release(connection);
            connection = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.release(connection);
            connection = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Session session) throws IOException {
        String string = "INSERT INTO " + this.sessionTable + " (" + this.sessionIdCol + ", " + this.sessionDataCol + ", " + this.sessionValidCol + ", " + this.sessionMaxInactiveCol + ", " + this.sessionLastAccessedCol + ") VALUES (?, ?, ?, ?, ?)";
        Connection connection = this.getConnection();
        ObjectOutputStream objectOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        InputStream inputStream = null;
        if (connection == null) {
            return;
        }
        this.remove(session.getId());
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(byteArrayOutputStream));
            ((StandardSession)session).writeObjectData(objectOutputStream);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n = byArray.length;
            byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
            inputStream = new BufferedInputStream(byteArrayInputStream, n);
            if (this.preparedSaveSql == null) {
                this.preparedSaveSql = connection.prepareStatement(string);
            }
            this.preparedSaveSql.setString(1, session.getId());
            this.preparedSaveSql.setBinaryStream(2, inputStream, n);
            this.preparedSaveSql.setString(3, session.isValid() ? "1" : "0");
            this.preparedSaveSql.setInt(4, session.getMaxInactiveInterval());
            this.preparedSaveSql.setLong(5, session.getLastAccessedTime());
            this.preparedSaveSql.execute();
        }
        catch (SQLException sQLException) {
            this.log(this.sm.getString(this.getStoreName() + ".SQLException", sQLException));
        }
        catch (IOException iOException) {
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            byteArrayInputStream = null;
            byteArrayOutputStream = null;
            objectOutputStream = null;
            inputStream = null;
            this.release(connection);
            connection = null;
        }
        if (this.debug > 0) {
            this.log(this.sm.getString(this.getStoreName() + ".saving", session.getId(), this.sessionTable));
        }
    }

    protected Connection getConnection() {
        block4: {
            try {
                if (this.conn != null && !this.conn.isClosed()) break block4;
                Class.forName(this.driverName);
                this.log(this.sm.getString(this.getStoreName() + ".checkConnectionDBClosed"));
                this.conn = DriverManager.getConnection(this.connString);
                this.conn.setAutoCommit(true);
                if (this.conn == null || this.conn.isClosed()) {
                    this.log(this.sm.getString(this.getStoreName() + ".checkConnectionDBReOpenFail"));
                }
            }
            catch (SQLException sQLException) {
                this.log(this.sm.getString(this.getStoreName() + ".checkConnectionSQLException", sQLException.toString()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log(this.sm.getString(this.getStoreName() + ".checkConnectionClassNotFoundException", classNotFoundException.toString()));
            }
        }
        return this.conn;
    }

    protected void release(Connection connection) {
    }

    public void start() throws LifecycleException {
        super.start();
        this.conn = this.getConnection();
    }

    public void stop() throws LifecycleException {
        super.stop();
        if (this.conn != null) {
            try {
                this.conn.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.preparedSizeSql.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.preparedKeysSql.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.preparedSaveSql.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.preparedClearSql.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.preparedRemoveSql.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.preparedLoadSql.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.preparedSizeSql = null;
            this.preparedKeysSql = null;
            this.preparedSaveSql = null;
            this.preparedClearSql = null;
            this.preparedRemoveSql = null;
            this.preparedLoadSql = null;
            this.conn = null;
        }
    }
}

