/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.catalina.connector.http.HttpHeader;
import org.apache.catalina.connector.http.HttpRequestStream;
import org.apache.catalina.connector.http.HttpResponseImpl;
import org.apache.catalina.util.Enumerator;

final class HttpRequestImpl
extends HttpRequestBase {
    protected static final int INITIAL_POOL_SIZE = 10;
    protected static final int POOL_SIZE_INCREMENT = 5;
    protected InetAddress inet = null;
    protected static final String info = "org.apache.catalina.connector.http.HttpRequestImpl/1.0";
    protected HttpHeader[] headerPool = new HttpHeader[10];
    protected int nextHeader = 0;
    protected HttpHeader connectionHeader = null;
    protected HttpHeader transferEncodingHeader = null;

    HttpRequestImpl() {
    }

    InetAddress getInet() {
        return this.inet;
    }

    void setInet(InetAddress inetAddress) {
        this.inet = inetAddress;
    }

    public String getInfo() {
        return info;
    }

    public void recycle() {
        super.recycle();
        this.inet = null;
        this.nextHeader = 0;
        this.connectionHeader = null;
    }

    public ServletInputStream createInputStream() throws IOException {
        return new HttpRequestStream(this, (HttpResponseImpl)this.response);
    }

    HttpHeader allocateHeader() {
        if (this.nextHeader == this.headerPool.length) {
            HttpHeader[] httpHeaderArray = new HttpHeader[this.headerPool.length + 5];
            int n = 0;
            while (n < this.nextHeader) {
                httpHeaderArray[n] = this.headerPool[n];
                ++n;
            }
            this.headerPool = httpHeaderArray;
        }
        if (this.headerPool[this.nextHeader] == null) {
            this.headerPool[this.nextHeader] = new HttpHeader();
        }
        return this.headerPool[this.nextHeader];
    }

    void nextHeader() {
        ++this.nextHeader;
    }

    public void addHeader(String string, String string2) {
        if (this.nextHeader == this.headerPool.length) {
            HttpHeader[] httpHeaderArray = new HttpHeader[this.headerPool.length + 5];
            int n = 0;
            while (n < this.nextHeader) {
                httpHeaderArray[n] = this.headerPool[n];
                ++n;
            }
            this.headerPool = httpHeaderArray;
        }
        this.headerPool[this.nextHeader++] = new HttpHeader(string, string2);
    }

    public void clearHeaders() {
        this.nextHeader = 0;
    }

    public HttpHeader getHeader(HttpHeader httpHeader) {
        int n = 0;
        while (n < this.nextHeader) {
            if (this.headerPool[n].equals(httpHeader)) {
                return this.headerPool[n];
            }
            ++n;
        }
        return null;
    }

    public HttpHeader getHeader(char[] cArray) {
        int n = 0;
        while (n < this.nextHeader) {
            if (this.headerPool[n].equals(cArray)) {
                return this.headerPool[n];
            }
            ++n;
        }
        return null;
    }

    public void finishRequest() throws IOException {
        if (this.reader == null && this.stream == null && this.getContentLength() != 0 && this.getProtocol() != null && this.getProtocol().equals("HTTP/1.1")) {
            this.getInputStream();
        }
        super.finishRequest();
    }

    public String getRemoteAddr() {
        return this.inet.getHostAddress();
    }

    public String getRemoteHost() {
        if (this.connector.getEnableLookups()) {
            return this.inet.getHostName();
        }
        return this.getRemoteAddr();
    }

    public String getHeader(String string) {
        string = string.toLowerCase();
        int n = 0;
        while (n < this.nextHeader) {
            if (this.headerPool[n].equals(string)) {
                return new String(this.headerPool[n].value, 0, this.headerPool[n].valueEnd);
            }
            ++n;
        }
        return null;
    }

    public Enumeration getHeaders(String string) {
        string = string.toLowerCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.nextHeader) {
            if (this.headerPool[n].equals(string)) {
                arrayList.add(new String(this.headerPool[n].value, 0, this.headerPool[n].valueEnd));
            }
            ++n;
        }
        return new Enumerator(arrayList);
    }

    public Enumeration getHeaderNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.nextHeader) {
            arrayList.add(new String(this.headerPool[n].name, 0, this.headerPool[n].nameEnd));
            ++n;
        }
        return new Enumerator(arrayList);
    }
}

