/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Vector;
import org.apache.catalina.cluster.ClusterReceiver;
import org.apache.catalina.cluster.ClusterSessionBase;
import org.apache.catalina.cluster.ReplicationWrapper;

public final class MulticastReceiver
extends ClusterSessionBase
implements ClusterReceiver {
    private static String senderId = null;
    private MulticastSocket multicastSocket = null;
    private String threadName = "MulticastReceiver";
    private String receiverName = "MulticastReceiver";
    private static Vector stack = new Vector();
    private boolean started = false;
    private Thread thread = null;
    protected boolean threadDone = false;
    private int checkInterval = 5;

    MulticastReceiver(String string, MulticastSocket multicastSocket, InetAddress inetAddress, int n) {
        this.multicastSocket = multicastSocket;
        senderId = string;
    }

    public String getName() {
        return this.receiverName;
    }

    public void setCheckInterval(int n) {
        this.checkInterval = n;
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getObjects() {
        Vector vector = stack;
        synchronized (vector) {
            Object[] objectArray = stack.toArray();
            stack.removeAllElements();
            return objectArray;
        }
    }

    public void start() {
        this.started = true;
        this.threadStart();
    }

    public void stop() {
        this.started = false;
        this.threadStop();
    }

    private void receive() {
        try {
            byte[] byArray = new byte[5000];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            ByteArrayInputStream byteArrayInputStream = null;
            ObjectInputStream objectInputStream = null;
            this.multicastSocket.receive(datagramPacket);
            byteArrayInputStream = new ByteArrayInputStream(byArray, 0, byArray.length);
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            ReplicationWrapper replicationWrapper = (ReplicationWrapper)objectInputStream.readObject();
            if (replicationWrapper.getSenderId().equals(senderId)) {
                stack.add(replicationWrapper);
            }
        }
        catch (IOException iOException) {
            this.log("An error occurred when trying to replicate: " + iOException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("An error occurred when trying to replicate: " + classNotFoundException.toString());
        }
    }

    public void run() {
        while (!this.threadDone) {
            this.receive();
            this.threadSleep();
        }
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.threadName = this.threadName + "[" + senderId + "]";
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }
}

