/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.EnumEntry;
import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.SequenceEntry;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.UnionBranch;
import com.sun.tools.corba.se.idl.UnionEntry;
import com.sun.tools.corba.se.idl.constExpr.EvaluationException;
import com.sun.tools.corba.se.idl.constExpr.Expression;
import com.sun.tools.corba.se.idl.toJavaPortable.Compile;
import com.sun.tools.corba.se.idl.toJavaPortable.Factories;
import com.sun.tools.corba.se.idl.toJavaPortable.JavaGenerator;
import com.sun.tools.corba.se.idl.toJavaPortable.TCOffsets;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UnionGen
implements com.sun.tools.corba.se.idl.UnionGen,
JavaGenerator {
    protected Hashtable symbolTable = null;
    protected UnionEntry u = null;
    protected PrintWriter stream = null;
    protected SymtabEntry utype = null;
    protected boolean unionIsEnum;
    protected String typePackage = "";

    public void generate(Hashtable hashtable, UnionEntry unionEntry, PrintWriter printWriter) {
        this.symbolTable = hashtable;
        this.u = unionEntry;
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.generateHelper();
        this.generateHolder();
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
        this.generateContainedTypes();
    }

    protected void init() {
        this.utype = Util.typeOf(this.u.type());
        this.unionIsEnum = this.utype instanceof EnumEntry;
    }

    protected void openStream() {
        this.stream = Util.stream(this.u, ".java");
    }

    protected void generateHelper() {
        ((Factories)Compile.compiler.factories()).helper().generate(this.symbolTable, this.u);
    }

    protected void generateHolder() {
        ((Factories)Compile.compiler.factories()).holder().generate(this.symbolTable, this.u);
    }

    protected void writeHeading() {
        this.typePackage = this.unionIsEnum ? Util.javaQualifiedName(this.utype) + '.' : "";
        Util.writePackage(this.stream, this.u);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        String string = this.u.name();
        this.stream.println("public final class " + this.u.name() + " implements org.omg.CORBA.portable.IDLEntity");
        this.stream.println("{");
    }

    protected void writeBody() {
        UnionBranch unionBranch;
        int n = this.u.branches().size() + 1;
        Enumeration enumeration = this.u.branches().elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            unionBranch = (UnionBranch)enumeration.nextElement();
            Util.fillInfo(unionBranch.typedef);
            this.stream.println("  private " + Util.javaName(unionBranch.typedef) + " ___" + unionBranch.typedef.name() + ";");
            ++n2;
        }
        this.stream.println("  private " + Util.javaName(this.utype) + " __discriminator;");
        this.stream.println("  private boolean __uninitialized = true;");
        this.stream.println();
        this.stream.println("  public " + this.u.name() + " ()");
        this.stream.println("  {");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public " + Util.javaName(this.utype) + " " + this.safeName(this.u, "discriminator") + " ()");
        this.stream.println("  {");
        this.stream.println("    if (__uninitialized)");
        this.stream.println("      throw new org.omg.CORBA.BAD_OPERATION ();");
        this.stream.println("    return __discriminator;");
        this.stream.println("  }");
        enumeration = this.u.branches().elements();
        n2 = 0;
        while (enumeration.hasMoreElements()) {
            unionBranch = (UnionBranch)enumeration.nextElement();
            this.writeBranchMethods(this.stream, this.u, unionBranch, n2++);
        }
        if (this.u.defaultBranch() == null && !this.coversAll(this.u)) {
            this.stream.println();
            this.stream.println("  public void _default ()");
            this.stream.println("  {");
            this.stream.println("    __discriminator = " + this.defaultDiscriminator(this.u) + ';');
            this.stream.println("    __uninitialized = false;");
            this.stream.println("  }");
            this.stream.println();
            this.stream.println("  public void _default (" + Util.javaName(this.utype) + " discriminator)");
            this.stream.println("  {");
            this.stream.println("    verifyDefault( discriminator ) ;");
            this.stream.println("    __discriminator = discriminator ;");
            this.stream.println("    __uninitialized = false;");
            this.stream.println("  }");
            this.writeVerifyDefault();
        }
        this.stream.println();
    }

    protected void writeClosing() {
        this.stream.println("} // class " + this.u.name());
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void generateContainedTypes() {
        Enumeration enumeration = this.u.contained().elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (symtabEntry instanceof SequenceEntry) continue;
            symtabEntry.generate(this.symbolTable, this.stream);
        }
    }

    private void writeVerifyDefault() {
        Vector vector = this.vectorizeLabels(this.u.branches(), true);
        this.stream.println("");
        this.stream.println("  private void verifyDefault( " + Util.javaName(this.utype) + " value )");
        this.stream.println("  {");
        if (this.unionIsEnum) {
            this.stream.println("    switch (value.value()) {");
        } else {
            this.stream.println("    switch (value) {");
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.stream.println("      case " + string + ":");
        }
        this.stream.println("        throw new org.omg.CORBA.BAD_OPERATION() ;");
        this.stream.println("");
        this.stream.println("      default:");
        this.stream.println("        return;");
        this.stream.println("    }");
        this.stream.println("  }");
    }

    private String defaultDiscriminator(UnionEntry unionEntry) {
        Vector vector = this.vectorizeLabels(unionEntry.branches(), false);
        String string = null;
        SymtabEntry symtabEntry = Util.typeOf(unionEntry.type());
        if (symtabEntry instanceof PrimitiveEntry && symtabEntry.name().equals("boolean")) {
            string = vector.contains("true") ? "false" : "true";
        } else if (symtabEntry.name().equals("char")) {
            int n = 0;
            String string2 = "'\\u0000'";
            while (n != 65535 && vector.contains(string2)) {
                string2 = ++n / 16 == 0 ? "'\\u000" + n + "'" : (n / 256 == 0 ? "\\u00" + n + "'" : (n / 4096 == 0 ? "\\u0" + n + "'" : "\\u" + n + "'"));
            }
            string = string2;
        } else if (symtabEntry instanceof EnumEntry) {
            Enumeration enumeration = vector.elements();
            EnumEntry enumEntry = (EnumEntry)symtabEntry;
            Vector vector2 = (Vector)enumEntry.elements().clone();
            while (enumeration.hasMoreElements()) {
                vector2.removeElement(enumeration.nextElement());
            }
            string = vector2.size() == 0 ? this.typePackage + (String)enumEntry.elements().lastElement() : this.typePackage + (String)vector2.firstElement();
        } else if (symtabEntry.name().equals("octet")) {
            int n = -128;
            while (n != 127 && vector.contains(Integer.toString(n))) {
                n = (short)(n + 1);
            }
            string = Integer.toString(n);
        } else if (symtabEntry.name().equals("short")) {
            int n = Short.MIN_VALUE;
            while (n != Short.MAX_VALUE && vector.contains(Integer.toString(n))) {
                n = (short)(n + 1);
            }
            string = Integer.toString(n);
        } else if (symtabEntry.name().equals("long")) {
            int n = Integer.MIN_VALUE;
            while (n != Integer.MAX_VALUE && vector.contains(Integer.toString(n))) {
                ++n;
            }
            string = Integer.toString(n);
        } else if (symtabEntry.name().equals("long long")) {
            long l = Long.MIN_VALUE;
            while (l != Long.MAX_VALUE && vector.contains(Long.toString(l))) {
                ++l;
            }
            string = Long.toString(l);
        } else if (symtabEntry.name().equals("unsigned short")) {
            int n = 0;
            while (n != Short.MAX_VALUE && vector.contains(Integer.toString(n))) {
                n = (short)(n + 1);
            }
            string = Integer.toString(n);
        } else if (symtabEntry.name().equals("unsigned long")) {
            int n = 0;
            while (n != Integer.MAX_VALUE && vector.contains(Integer.toString(n))) {
                ++n;
            }
            string = Integer.toString(n);
        } else if (symtabEntry.name().equals("unsigned long long")) {
            long l = 0L;
            while (l != Long.MAX_VALUE && vector.contains(Long.toString(l))) {
                ++l;
            }
            string = Long.toString(l);
        }
        return string;
    }

    private Vector vectorizeLabels(Vector vector, boolean bl) {
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UnionBranch unionBranch = (UnionBranch)enumeration.nextElement();
            Enumeration enumeration2 = unionBranch.labels.elements();
            while (enumeration2.hasMoreElements()) {
                Expression expression = (Expression)enumeration2.nextElement();
                String string = this.unionIsEnum ? (bl ? this.typePackage + "_" + Util.parseExpression(expression) : this.typePackage + Util.parseExpression(expression)) : Util.parseExpression(expression);
                vector2.addElement(string);
            }
        }
        return vector2;
    }

    private String safeName(UnionEntry unionEntry, String string) {
        Enumeration enumeration = unionEntry.branches().elements();
        while (enumeration.hasMoreElements()) {
            if (!((UnionBranch)enumeration.nextElement()).typedef.name().equals(string)) continue;
            string = '_' + string;
            break;
        }
        return string;
    }

    private boolean coversAll(UnionEntry unionEntry) {
        Vector vector;
        SymtabEntry symtabEntry = Util.typeOf(unionEntry.type());
        boolean bl = false;
        if (symtabEntry.name().equals("boolean")) {
            if (unionEntry.branches().size() == 2) {
                bl = true;
            }
        } else if (symtabEntry instanceof EnumEntry && (vector = this.vectorizeLabels(unionEntry.branches(), true)).size() == ((EnumEntry)symtabEntry).elements().size()) {
            bl = true;
        }
        return bl;
    }

    private void writeBranchMethods(PrintWriter printWriter, UnionEntry unionEntry, UnionBranch unionBranch, int n) {
        printWriter.println();
        printWriter.println("  public " + Util.javaName(unionBranch.typedef) + " " + unionBranch.typedef.name() + " ()");
        printWriter.println("  {");
        printWriter.println("    if (__uninitialized)");
        printWriter.println("      throw new org.omg.CORBA.BAD_OPERATION ();");
        printWriter.println("    verify" + unionBranch.typedef.name() + " (__discriminator);");
        printWriter.println("    return ___" + unionBranch.typedef.name() + ";");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  public void " + unionBranch.typedef.name() + " (" + Util.javaName(unionBranch.typedef) + " value)");
        printWriter.println("  {");
        if (unionBranch.labels.size() == 0) {
            printWriter.println("    __discriminator = " + this.defaultDiscriminator(unionEntry) + ";");
        } else if (this.unionIsEnum) {
            printWriter.println("    __discriminator = " + this.typePackage + Util.parseExpression((Expression)unionBranch.labels.firstElement()) + ";");
        } else {
            printWriter.println("    __discriminator = " + this.cast((Expression)unionBranch.labels.firstElement(), unionEntry.type()) + ";");
        }
        printWriter.println("    ___" + unionBranch.typedef.name() + " = value;");
        printWriter.println("    __uninitialized = false;");
        printWriter.println("  }");
        SymtabEntry symtabEntry = Util.typeOf(unionEntry.type());
        if (unionBranch.labels.size() > 1 || unionBranch.labels.size() > 0 && unionBranch.isDefault) {
            printWriter.println();
            printWriter.println("  public void " + unionBranch.typedef.name() + " (" + Util.javaName(symtabEntry) + " discriminator, " + Util.javaName(unionBranch.typedef) + " value)");
            printWriter.println("  {");
            printWriter.println("    verify" + unionBranch.typedef.name() + " (discriminator);");
            printWriter.println("    __discriminator = discriminator;");
            printWriter.println("    ___" + unionBranch.typedef.name() + " = value;");
            printWriter.println("    __uninitialized = false;");
            printWriter.println("  }");
        }
        printWriter.println();
        printWriter.println("  private void verify" + unionBranch.typedef.name() + " (" + Util.javaName(symtabEntry) + " discriminator)");
        printWriter.println("  {");
        boolean bl = true;
        if (!unionBranch.isDefault || unionEntry.branches().size() != 1) {
            printWriter.print("    if (");
            if (unionBranch.isDefault) {
                Enumeration enumeration = unionEntry.branches().elements();
                while (enumeration.hasMoreElements()) {
                    UnionBranch unionBranch2 = (UnionBranch)enumeration.nextElement();
                    if (unionBranch2 == unionBranch) continue;
                    Enumeration enumeration2 = unionBranch2.labels.elements();
                    while (enumeration2.hasMoreElements()) {
                        Expression expression = (Expression)enumeration2.nextElement();
                        if (!bl) {
                            printWriter.print(" || ");
                        }
                        if (this.unionIsEnum) {
                            printWriter.print("discriminator == " + this.typePackage + Util.parseExpression(expression));
                        } else {
                            printWriter.print("discriminator == " + Util.parseExpression(expression));
                        }
                        bl = false;
                    }
                }
            } else {
                Enumeration enumeration = unionBranch.labels.elements();
                while (enumeration.hasMoreElements()) {
                    Expression expression = (Expression)enumeration.nextElement();
                    if (!bl) {
                        printWriter.print(" && ");
                    }
                    if (this.unionIsEnum) {
                        printWriter.print("discriminator != " + this.typePackage + Util.parseExpression(expression));
                    } else {
                        printWriter.print("discriminator != " + Util.parseExpression(expression));
                    }
                    bl = false;
                }
            }
            printWriter.println(")");
            printWriter.println("      throw new org.omg.CORBA.BAD_OPERATION ();");
        }
        printWriter.println("  }");
    }

    private int unionLabelSize(UnionEntry unionEntry) {
        int n = 0;
        Vector vector = unionEntry.branches();
        int n2 = 0;
        while (n2 < vector.size()) {
            UnionBranch unionBranch = (UnionBranch)vector.get(n2);
            int n3 = unionBranch.labels.size();
            n += n3 == 0 ? 1 : n3;
            ++n2;
        }
        return n;
    }

    public int helperType(int n, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        TCOffsets tCOffsets2 = new TCOffsets();
        UnionEntry unionEntry = (UnionEntry)symtabEntry;
        String string3 = "_disTypeCode" + n;
        String string4 = "_members" + n;
        printWriter.println(string + "org.omg.CORBA.TypeCode " + string3 + ';');
        n = ((JavaGenerator)((Object)unionEntry.type().generator())).type(n + 1, string, tCOffsets2, string3, unionEntry.type(), printWriter);
        tCOffsets.bumpCurrentOffset(tCOffsets2.currentOffset());
        printWriter.println(string + "org.omg.CORBA.UnionMember[] " + string4 + " = new org.omg.CORBA.UnionMember [" + this.unionLabelSize(unionEntry) + "];");
        String string5 = "_tcOf" + string4;
        String string6 = "_anyOf" + string4;
        printWriter.println(string + "org.omg.CORBA.TypeCode " + string5 + ';');
        printWriter.println(string + "org.omg.CORBA.Any " + string6 + ';');
        tCOffsets2 = new TCOffsets();
        tCOffsets2.set(symtabEntry);
        int n2 = tCOffsets2.currentOffset();
        int n3 = 0;
        while (n3 < unionEntry.branches().size()) {
            Object object;
            UnionBranch unionBranch = (UnionBranch)unionEntry.branches().elementAt(n3);
            TypedefEntry typedefEntry = unionBranch.typedef;
            Vector vector = unionBranch.labels;
            String string7 = Util.stripLeadingUnderscores(typedefEntry.name());
            if (vector.size() == 0) {
                printWriter.println();
                printWriter.println(string + "// Branch for " + string7 + " (Default case)");
                object = Util.typeOf(unionEntry.type());
                printWriter.println(string + string6 + " = org.omg.CORBA.ORB.init ().create_any ();");
                printWriter.println(string + string6 + ".insert_octet ((byte)0); // default member label");
                tCOffsets2.bumpCurrentOffset(4);
                n = ((JavaGenerator)((Object)typedefEntry.generator())).type(n, string, tCOffsets2, string5, typedefEntry, printWriter);
                int n4 = tCOffsets2.currentOffset();
                tCOffsets2 = new TCOffsets();
                tCOffsets2.set(symtabEntry);
                tCOffsets2.bumpCurrentOffset(n4 - n2);
                printWriter.println(string + string4 + '[' + n3 + "] = new org.omg.CORBA.UnionMember (");
                printWriter.println(string + "  \"" + string7 + "\",");
                printWriter.println(string + "  " + string6 + ',');
                printWriter.println(string + "  " + string5 + ',');
                printWriter.println(string + "  null);");
            } else {
                object = vector.elements();
                while (object.hasMoreElements()) {
                    Expression expression = (Expression)object.nextElement();
                    String string8 = Util.parseExpression(expression);
                    printWriter.println();
                    printWriter.println(string + "// Branch for " + string7 + " (case label " + string8 + ")");
                    SymtabEntry symtabEntry2 = Util.typeOf(unionEntry.type());
                    printWriter.println(string + string6 + " = org.omg.CORBA.ORB.init ().create_any ();");
                    if (symtabEntry2 instanceof PrimitiveEntry) {
                        printWriter.println(string + string6 + ".insert_" + Util.collapseName(symtabEntry2.name()) + " ((" + Util.javaName(symtabEntry2) + ')' + string8 + ");");
                    } else {
                        String string9 = Util.javaName(symtabEntry2);
                        printWriter.println(string + Util.helperName(symtabEntry2, false) + ".insert (" + string6 + ", " + string9 + '.' + string8 + ");");
                    }
                    tCOffsets2.bumpCurrentOffset(4);
                    n = ((JavaGenerator)((Object)typedefEntry.generator())).type(n, string, tCOffsets2, string5, typedefEntry, printWriter);
                    int n5 = tCOffsets2.currentOffset();
                    tCOffsets2 = new TCOffsets();
                    tCOffsets2.set(symtabEntry);
                    tCOffsets2.bumpCurrentOffset(n5 - n2);
                    printWriter.println(string + string4 + '[' + n3 + "] = new org.omg.CORBA.UnionMember (");
                    printWriter.println(string + "  \"" + string7 + "\",");
                    printWriter.println(string + "  " + string6 + ',');
                    printWriter.println(string + "  " + string5 + ',');
                    printWriter.println(string + "  null);");
                }
            }
            ++n3;
        }
        tCOffsets.bumpCurrentOffset(tCOffsets2.currentOffset());
        printWriter.println(string + string2 + " = org.omg.CORBA.ORB.init ().create_union_tc (" + Util.helperName(unionEntry, true) + ".id (), \"" + symtabEntry.name() + "\", " + string3 + ", " + string4 + ");");
        return n;
    }

    public int type(int n, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println(string + string2 + " = " + Util.helperName(symtabEntry, true) + ".type ();");
        return n;
    }

    public void helperRead(String string, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println("    " + string + " value = new " + string + " ();");
        this.read(0, "    ", "value", symtabEntry, printWriter);
        printWriter.println("    return value;");
    }

    public void helperWrite(SymtabEntry symtabEntry, PrintWriter printWriter) {
        this.write(0, "    ", "value", symtabEntry, printWriter);
    }

    public int read(int n, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        UnionEntry unionEntry = (UnionEntry)symtabEntry;
        String string3 = "_dis" + n++;
        SymtabEntry symtabEntry2 = Util.typeOf(unionEntry.type());
        Util.writeInitializer(string, string3, "", symtabEntry2, printWriter);
        if (symtabEntry2 instanceof PrimitiveEntry) {
            n = ((JavaGenerator)((Object)symtabEntry2.generator())).read(n, string, string3, symtabEntry2, printWriter);
        } else {
            printWriter.println(string + string3 + " = " + Util.helperName(symtabEntry2, true) + ".read (istream);");
        }
        n = symtabEntry2.name().equals("boolean") ? this.readBoolean(string3, n, string, string2, unionEntry, printWriter) : this.readNonBoolean(string3, n, string, string2, unionEntry, printWriter);
        return n;
    }

    private int readBoolean(String string, int n, String string2, String string3, UnionEntry unionEntry, PrintWriter printWriter) {
        Object object;
        UnionBranch unionBranch = (UnionBranch)unionEntry.branches().firstElement();
        Object object2 = unionEntry.branches().size() == 2 ? (UnionBranch)unionEntry.branches().lastElement() : null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (unionEntry.branches().size() == 1 && (unionEntry.defaultBranch() != null || unionBranch.labels.size() == 2)) {
                bl2 = true;
            } else {
                object = (Expression)unionBranch.labels.firstElement();
                Boolean bl3 = (Boolean)((Expression)object).evaluate();
                bl = bl3;
            }
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        if (bl2) {
            n = this.readBranch(n, string2, unionBranch.typedef.name(), unionBranch.typedef, printWriter);
        } else {
            if (!bl) {
                object = unionBranch;
                unionBranch = object2;
                object2 = object;
            }
            printWriter.println(string2 + "if (" + string + ')');
            if (unionBranch == null) {
                printWriter.println(string2 + "  throw new org.omg.CORBA.BAD_OPERATION ();");
            } else {
                printWriter.println(string2 + '{');
                n = this.readBranch(n, string2 + "  ", unionBranch.typedef.name(), unionBranch.typedef, printWriter);
                printWriter.println(string2 + '}');
            }
            printWriter.println(string2 + "else");
            if (object2 == null) {
                printWriter.println(string2 + "  throw new org.omg.CORBA.BAD_OPERATION ();");
            } else {
                printWriter.println(string2 + '{');
                n = this.readBranch(n, string2 + "  ", ((UnionBranch)object2).typedef.name(), ((UnionBranch)object2).typedef, printWriter);
                printWriter.println(string2 + '}');
            }
        }
        return n;
    }

    private int readNonBoolean(String string, int n, String string2, String string3, UnionEntry unionEntry, PrintWriter printWriter) {
        SymtabEntry symtabEntry = Util.typeOf(unionEntry.type());
        if (symtabEntry instanceof EnumEntry) {
            printWriter.println(string2 + "switch (" + string + ".value ())");
        } else {
            printWriter.println(string2 + "switch (" + string + ')');
        }
        printWriter.println(string2 + '{');
        String string4 = Util.javaQualifiedName(symtabEntry) + '.';
        Enumeration enumeration = unionEntry.branches().elements();
        while (enumeration.hasMoreElements()) {
            UnionBranch unionBranch = (UnionBranch)enumeration.nextElement();
            Enumeration enumeration2 = unionBranch.labels.elements();
            while (enumeration2.hasMoreElements()) {
                Expression expression = (Expression)enumeration2.nextElement();
                if (symtabEntry instanceof EnumEntry) {
                    String string5 = Util.parseExpression(expression);
                    printWriter.println(string2 + "  case " + string4 + '_' + string5 + ':');
                    continue;
                }
                printWriter.println(string2 + "  case " + this.cast(expression, symtabEntry) + ':');
            }
            if (unionBranch.typedef.equals(unionEntry.defaultBranch())) continue;
            n = this.readBranch(n, string2 + "    ", unionBranch.typedef.name(), unionBranch.typedef, printWriter);
            printWriter.println(string2 + "    break;");
        }
        if (!this.coversAll(unionEntry)) {
            printWriter.println(string2 + "  default:");
            if (unionEntry.defaultBranch() == null) {
                printWriter.println(string2 + "    value._default( " + string + " ) ;");
            } else {
                n = this.readBranch(n, string2 + "    ", unionEntry.defaultBranch().name(), unionEntry.defaultBranch(), printWriter);
            }
            printWriter.println(string2 + "    break;");
        }
        printWriter.println(string2 + '}');
        return n;
    }

    private int readBranch(int n, String string, String string2, TypedefEntry typedefEntry, PrintWriter printWriter) {
        SymtabEntry symtabEntry = typedefEntry.type();
        Util.writeInitializer(string, '_' + string2, "", typedefEntry, printWriter);
        if (!typedefEntry.arrayInfo().isEmpty() || symtabEntry instanceof SequenceEntry || symtabEntry instanceof PrimitiveEntry || symtabEntry instanceof StringEntry) {
            n = ((JavaGenerator)((Object)typedefEntry.generator())).read(n, string, '_' + string2, typedefEntry, printWriter);
        } else {
            printWriter.println(string + '_' + string2 + " = " + Util.helperName(symtabEntry, true) + ".read (istream);");
        }
        printWriter.println(string + "value." + string2 + " (_" + string2 + ");");
        return n;
    }

    public int write(int n, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        UnionEntry unionEntry = (UnionEntry)symtabEntry;
        SymtabEntry symtabEntry2 = Util.typeOf(unionEntry.type());
        if (symtabEntry2 instanceof PrimitiveEntry) {
            n = ((JavaGenerator)((Object)symtabEntry2.generator())).write(n, string, string2 + ".discriminator ()", symtabEntry2, printWriter);
        } else {
            printWriter.println(string + Util.helperName(symtabEntry2, true) + ".write (ostream, " + string2 + ".discriminator ());");
        }
        n = symtabEntry2.name().equals("boolean") ? this.writeBoolean(string2 + ".discriminator ()", n, string, string2, unionEntry, printWriter) : this.writeNonBoolean(string2 + ".discriminator ()", n, string, string2, unionEntry, printWriter);
        return n;
    }

    private int writeBoolean(String string, int n, String string2, String string3, UnionEntry unionEntry, PrintWriter printWriter) {
        SymtabEntry symtabEntry = Util.typeOf(unionEntry.type());
        UnionBranch unionBranch = (UnionBranch)unionEntry.branches().firstElement();
        UnionBranch unionBranch2 = unionEntry.branches().size() == 2 ? (UnionBranch)unionEntry.branches().lastElement() : null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (unionEntry.branches().size() == 1 && (unionEntry.defaultBranch() != null || unionBranch.labels.size() == 2)) {
                bl2 = true;
            } else {
                bl = (Boolean)((Expression)unionBranch.labels.firstElement()).evaluate();
            }
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        if (bl2) {
            n = this.writeBranch(n, string2, string3, unionBranch.typedef, printWriter);
        } else {
            if (!bl) {
                UnionBranch unionBranch3 = unionBranch;
                unionBranch = unionBranch2;
                unionBranch2 = unionBranch3;
            }
            printWriter.println(string2 + "if (" + string + ')');
            if (unionBranch == null) {
                printWriter.println(string2 + "  throw new org.omg.CORBA.BAD_OPERATION ();");
            } else {
                printWriter.println(string2 + '{');
                n = this.writeBranch(n, string2 + "  ", string3, unionBranch.typedef, printWriter);
                printWriter.println(string2 + '}');
            }
            printWriter.println(string2 + "else");
            if (unionBranch2 == null) {
                printWriter.println(string2 + "  throw new org.omg.CORBA.BAD_OPERATION ();");
            } else {
                printWriter.println(string2 + '{');
                n = this.writeBranch(n, string2 + "  ", string3, unionBranch2.typedef, printWriter);
                printWriter.println(string2 + '}');
            }
        }
        return n;
    }

    private int writeNonBoolean(String string, int n, String string2, String string3, UnionEntry unionEntry, PrintWriter printWriter) {
        SymtabEntry symtabEntry = Util.typeOf(unionEntry.type());
        if (symtabEntry instanceof EnumEntry) {
            printWriter.println(string2 + "switch (" + string3 + ".discriminator ().value ())");
        } else {
            printWriter.println(string2 + "switch (" + string3 + ".discriminator ())");
        }
        printWriter.println(string2 + "{");
        String string4 = Util.javaQualifiedName(symtabEntry) + '.';
        Enumeration enumeration = unionEntry.branches().elements();
        while (enumeration.hasMoreElements()) {
            UnionBranch unionBranch = (UnionBranch)enumeration.nextElement();
            Enumeration enumeration2 = unionBranch.labels.elements();
            while (enumeration2.hasMoreElements()) {
                Expression expression = (Expression)enumeration2.nextElement();
                if (symtabEntry instanceof EnumEntry) {
                    String string5 = Util.parseExpression(expression);
                    printWriter.println(string2 + "  case " + string4 + '_' + string5 + ":");
                    continue;
                }
                printWriter.println(string2 + "  case " + this.cast(expression, symtabEntry) + ':');
            }
            if (unionBranch.typedef.equals(unionEntry.defaultBranch())) continue;
            n = this.writeBranch(n, string2 + "    ", string3, unionBranch.typedef, printWriter);
            printWriter.println(string2 + "    break;");
        }
        if (unionEntry.defaultBranch() != null) {
            printWriter.println(string2 + "  default:");
            n = this.writeBranch(n, string2 + "    ", string3, unionEntry.defaultBranch(), printWriter);
            printWriter.println(string2 + "    break;");
        }
        printWriter.println(string2 + "}");
        return n;
    }

    private int writeBranch(int n, String string, String string2, TypedefEntry typedefEntry, PrintWriter printWriter) {
        SymtabEntry symtabEntry = typedefEntry.type();
        if (!typedefEntry.arrayInfo().isEmpty() || symtabEntry instanceof SequenceEntry || symtabEntry instanceof PrimitiveEntry || symtabEntry instanceof StringEntry) {
            n = ((JavaGenerator)((Object)typedefEntry.generator())).write(n, string, string2 + '.' + typedefEntry.name() + " ()", typedefEntry, printWriter);
        } else {
            printWriter.println(string + Util.helperName(symtabEntry, true) + ".write (ostream, " + string2 + '.' + typedefEntry.name() + " ());");
        }
        return n;
    }

    private String cast(Expression expression, SymtabEntry symtabEntry) {
        String string = Util.parseExpression(expression);
        if (symtabEntry.name().indexOf("short") >= 0) {
            int n;
            if (expression.value() instanceof Long) {
                long l = (Long)expression.value();
                if (l > 32767L) {
                    string = "(short)(" + string + ')';
                }
            } else if (expression.value() instanceof Integer && (n = ((Integer)expression.value()).intValue()) > Short.MAX_VALUE) {
                string = "(short)(" + string + ')';
            }
        } else if (symtabEntry.name().indexOf("long") >= 0) {
            int n;
            if (expression.value() instanceof Long) {
                long l = (Long)expression.value();
                if (l > Integer.MAX_VALUE || l == Integer.MIN_VALUE) {
                    string = "(int)(" + string + ')';
                }
            } else if (expression.value() instanceof Integer && ((n = ((Integer)expression.value()).intValue()) > Integer.MAX_VALUE || n == Integer.MIN_VALUE)) {
                string = "(int)(" + string + ')';
            }
        }
        return string;
    }
}

