/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jta;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.jta.NativeXAResource;
import com.sun.jts.jta.SynchronizationImpl;
import com.sun.jts.jta.TransactionManagerImpl;
import com.sun.jts.jtsxa.OTSResourceImpl;
import com.sun.jts.jtsxa.Utility;
import com.sun.jts.jtsxa.XID;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.Unavailable;

public class TransactionState {
    private static final int NOT_EXIST = -1;
    private static final int ASSOCIATED = 0;
    private static final int NOT_ASSOCIATED = 1;
    private static final int ASSOCIATION_SUSPENDED = 2;
    private static final int FAILED = 3;
    private static final int ROLLING_BACK = 4;
    private Hashtable resourceStates = new Hashtable();
    private Hashtable resourceList = new Hashtable();
    private Set seenXids = new HashSet();
    private Vector factories = new Vector();
    private SynchronizationImpl syncImpl;
    private int activeResources = 0;
    private GlobalTID gtid;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");
    public static boolean debug = false;

    public TransactionState(GlobalTID globalTID) {
        this.gtid = globalTID;
    }

    public synchronized void beforeCompletion() throws XAException {
        Enumeration enumeration = this.resourceStates.keys();
        while (enumeration.hasMoreElements()) {
            XAResource xAResource = (XAResource)enumeration.nextElement();
            int n = this.getXAState(xAResource);
            switch (n) {
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    Xid xid = (Xid)this.resourceList.get(xAResource);
                    xAResource.end(xid, 0x4000000);
                    this.setXAState(xAResource, 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Wrong XA State: " + n);
                }
            }
        }
    }

    public synchronized void rollback(XAResource xAResource) throws IllegalStateException, XAException {
        Xid xid = (Xid)this.resourceList.get(xAResource);
        TransactionState.assertit(xid != null);
        int n = this.getXAState(xAResource);
        switch (n) {
            case 1: 
            case 3: {
                xAResource.rollback(xid);
                break;
            }
            case 2: {
                xAResource.end(xid, 0x4000000);
                this.setXAState(xAResource, 1);
                xAResource.rollback(xid);
                break;
            }
            case 0: {
                this.setXAState(xAResource, 4);
                ++this.activeResources;
                break;
            }
            default: {
                throw new IllegalStateException("Wrong XAState: " + n);
            }
        }
    }

    private Xid computeXid(XAResource xAResource, Control control) throws Inactive, Unavailable, XAException {
        Object object;
        int n = this.factories.size();
        int n2 = 0;
        while (n2 < n) {
            object = (XAResource)this.factories.elementAt(n2);
            if (xAResource.isSameRM((XAResource)object)) {
                Xid xid = (Xid)this.resourceList.get(object);
                return xid;
            }
            ++n2;
        }
        object = Configuration.isLocalFactory() ? Utility.getXID(((ControlImpl)control).get_localCoordinator()) : Utility.getXID(control.get_coordinator());
        this.factories.addElement(xAResource);
        byte[] byArray = TransactionState.parseSize(n);
        byte[] byArray2 = Configuration.getServerNameByteArray();
        byte[] byArray3 = new byte[byArray2.length + 1 + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        byArray3[byArray2.length] = 44;
        System.arraycopy(byArray, 0, byArray3, byArray2.length + 1, byArray.length);
        ((XID)object).setBranchQualifier(byArray3);
        return object;
    }

    public synchronized void startAssociation(XAResource xAResource, Control control, int n) throws XAException, SystemException, IllegalStateException, RollbackException {
        try {
            Xid xid = null;
            boolean bl = false;
            if (this.resourceList.get(xAResource) == null) {
                if (n != 0) {
                    throw new RollbackException();
                }
                bl = true;
                xid = this.computeXid(xAResource, control);
                if (!this.seenXids.contains(xid)) {
                    OTSResourceImpl oTSResourceImpl = new OTSResourceImpl(xid, xAResource, this);
                    if (Configuration.isLocalFactory()) {
                        ((ControlImpl)control).get_localCoordinator().register_resource(oTSResourceImpl);
                    } else {
                        control.get_coordinator().register_resource(oTSResourceImpl);
                    }
                }
                this.resourceList.put(xAResource, xid);
            } else {
                xid = (Xid)this.resourceList.get(xAResource);
            }
            int n2 = this.getXAState(xAResource);
            if (!this.seenXids.contains(xid)) {
                this.seenXids.add(xid);
                xAResource.start(xid, 0);
                this.setXAState(xAResource, 0);
            } else {
                switch (n2) {
                    case -1: 
                    case 1: {
                        xAResource.start(xid, 0x200000);
                        this.setXAState(xAResource, 0);
                        break;
                    }
                    case 2: {
                        xAResource.start(xid, 0x8000000);
                        this.setXAState(xAResource, 0);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Wrong XAState: " + n2);
                    }
                }
            }
            if (xAResource instanceof NativeXAResource && bl) {
                ((NativeXAResource)xAResource).enlistConnectionInXA();
            }
        }
        catch (XAException xAException) {
            this.setXAState(xAResource, 3);
            throw xAException;
        }
        catch (Inactive inactive) {
            _logger.log(Level.WARNING, "jts.transaction_inactive", inactive);
            throw new SystemException();
        }
        catch (Unavailable unavailable) {
            _logger.log(Level.WARNING, "jts.object_unavailable", unavailable);
            throw new SystemException();
        }
    }

    public synchronized void endAssociation(XAResource xAResource, int n) throws XAException, IllegalStateException {
        try {
            Xid xid = (Xid)this.resourceList.get(xAResource);
            TransactionState.assertit(xid != null);
            int n2 = this.getXAState(xAResource);
            switch (n2) {
                case 0: {
                    if ((n & 0x4000000) != 0) {
                        xAResource.end(xid, 0x4000000);
                        this.setXAState(xAResource, 1);
                        break;
                    }
                    if ((n & 0x2000000) != 0) {
                        xAResource.end(xid, 0x2000000);
                        this.setXAState(xAResource, 2);
                        break;
                    }
                    xAResource.end(xid, 0x20000000);
                    this.setXAState(xAResource, 3);
                    break;
                }
                case 4: {
                    --this.activeResources;
                    this.cleanupTransactionStateMapping();
                    xAResource.end(xid, 0x4000000);
                    this.setXAState(xAResource, 1);
                    xAResource.rollback(xid);
                    break;
                }
                case 2: {
                    if ((n & 0x4000000) != 0) {
                        xAResource.end(xid, 0x4000000);
                        this.setXAState(xAResource, 1);
                        break;
                    }
                    if ((n & 0x2000000) != 0) {
                        throw new IllegalStateException("Wrong XAState: " + n2);
                    }
                    xAResource.end(xid, 0x20000000);
                    this.setXAState(xAResource, 3);
                    break;
                }
                default: {
                    throw new IllegalStateException("Wrong XAState: " + n2);
                }
            }
        }
        catch (XAException xAException) {
            this.setXAState(xAResource, 3);
            throw xAException;
        }
    }

    synchronized void cleanupTransactionStateMapping() {
        if (this.activeResources == 0) {
            TransactionManagerImpl transactionManagerImpl = TransactionManagerImpl.getTransactionManagerImpl();
            transactionManagerImpl.cleanupTransactionState(this.gtid);
        }
    }

    public synchronized void registerSynchronization(Synchronization synchronization, Control control) throws RollbackException, IllegalStateException, SystemException {
        try {
            if (this.syncImpl == null) {
                this.syncImpl = new SynchronizationImpl();
                if (Configuration.isLocalFactory()) {
                    ((ControlImpl)control).get_localCoordinator().register_synchronization(this.syncImpl);
                } else {
                    control.get_coordinator().register_synchronization(this.syncImpl);
                }
            }
            this.syncImpl.addSynchronization(synchronization);
        }
        catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
            throw new RollbackException();
        }
        catch (Unavailable unavailable) {
            throw new SystemException();
        }
        catch (Inactive inactive) {
            throw new IllegalStateException();
        }
        catch (Exception exception) {
            throw new SystemException();
        }
    }

    private void setXAState(XAResource xAResource, int n) {
        if (debug) {
            int n2 = this.getXAState(xAResource);
            _logger.log(Level.FINE, "transaction id : " + this.gtid);
            _logger.log(Level.FINE, "res: " + xAResource + "," + n2 + "," + n);
        }
        this.resourceStates.put(xAResource, new Integer(n));
    }

    private int getXAState(XAResource xAResource) {
        Integer n = (Integer)this.resourceStates.get(xAResource);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public Enumeration listXAResources() {
        return this.resourceList.keys();
    }

    public boolean containsXAResource(XAResource xAResource) {
        return this.resourceList.containsKey(xAResource);
    }

    private static void assertit(boolean bl) {
        if (!bl) {
            Exception exception = new Exception();
            _logger.log(Level.WARNING, "jts.assert", exception);
        }
    }

    private static byte[] parseSize(int n) {
        int n2 = 9;
        byte[] byArray = new byte[10];
        if (n == 0) {
            byArray[n2--] = 0;
        }
        while (n > 0) {
            byArray[n2--] = (byte)(n % 10);
            n /= 10;
        }
        int n3 = 9 - n2;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2 + 1, byArray2, 0, n3);
        return byArray2;
    }
}

