/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.elements;

import com.sun.enterprise.deployment.MimeMappingDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import com.sun.enterprise.tools.verifier.tests.web.elements.MimeTypes;
import java.util.Arrays;
import java.util.Enumeration;

public class MimeTypeElement
extends WebTest
implements WebCheck,
MimeTypes {
    public Result check(WebBundleDescriptor webBundleDescriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor webComponentNameConstructor = new WebComponentNameConstructor(webBundleDescriptor);
        if (webBundleDescriptor.getMimeMappings().hasMoreElements()) {
            boolean bl = false;
            boolean bl2 = false;
            Enumeration enumeration = webBundleDescriptor.getMimeMappings();
            while (enumeration.hasMoreElements()) {
                bl2 = false;
                MimeMappingDescriptor mimeMappingDescriptor = (MimeMappingDescriptor)enumeration.nextElement();
                String string = mimeMappingDescriptor.getMimeType();
                Verifier.debug("servlet mimeType: " + string);
                int n = string.indexOf("/");
                System.out.println("MIME is " + string.substring(n));
                if (string.substring(n + 1).startsWith("X-") || string.substring(n + 1).startsWith("x-")) {
                    bl2 = true;
                } else if (string.startsWith("X-")) {
                    bl2 = true;
                } else if (string.substring(0, n).equals("text")) {
                    if (Arrays.asList(MimeTypes.text).contains(string.substring(n + 1, string.length()))) {
                        bl2 = true;
                    }
                } else if (string.substring(0, n).equals("multipart")) {
                    if (Arrays.asList(MimeTypes.multipart).contains(string.substring(n + 1, string.length()))) {
                        bl2 = true;
                    }
                } else if (string.substring(0, n).equals("message")) {
                    if (Arrays.asList(MimeTypes.message).contains(string.substring(n + 1, string.length()))) {
                        bl2 = true;
                    }
                } else if (string.substring(0, n).equals("application")) {
                    if (Arrays.asList(MimeTypes.application).contains(string.substring(n + 1, string.length()))) {
                        bl2 = true;
                    }
                } else if (string.substring(0, n).equals("image")) {
                    if (Arrays.asList(MimeTypes.image).contains(string.substring(n + 1, string.length()))) {
                        bl2 = true;
                    }
                } else if (string.substring(0, n).equals("audio")) {
                    if (Arrays.asList(MimeTypes.audio).contains(string.substring(n + 1, string.length()))) {
                        bl2 = true;
                    }
                } else if (string.substring(0, n).equals("video")) {
                    if (Arrays.asList(MimeTypes.video).contains(string.substring(n + 1, string.length()))) {
                        bl2 = true;
                    }
                } else if (string.substring(0, n).equals("model") && Arrays.asList(MimeTypes.model).contains(string.substring(n + 1, string.length()))) {
                    bl2 = true;
                }
                if (bl2) {
                    result.addGoodDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{webComponentNameConstructor.toString()}));
                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Servlet mime-type [ {0} ] defined for this web application [ {1} ]", new Object[]{string, webBundleDescriptor.getName()}));
                    continue;
                }
                if (!bl) {
                    bl = true;
                }
                result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{webComponentNameConstructor.toString()}));
                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: Servlet mime-type [ {0} ] not defined for this web application [ {1} ]", new Object[]{string, webBundleDescriptor.getName()}));
            }
            if (bl) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.addNaDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{webComponentNameConstructor.toString()}));
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no mimemappings within the web archive [ {0} ]", new Object[]{webBundleDescriptor.getName()}));
        }
        return result;
    }
}

