/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class RmiIIOPUtils {
    public static boolean isValidRmiIIOPInterface(Class clazz) {
        GenericDeclaration[] genericDeclarationArray;
        boolean bl = false;
        Class clazz2 = clazz;
        block2: do {
            if (clazz.getName().equals("java.rmi.Remote")) {
                bl = true;
                break;
            }
            genericDeclarationArray = clazz.getInterfaces();
            int n = 0;
            while (n < genericDeclarationArray.length) {
                if (((Class)genericDeclarationArray[n]).getName().equals("java.rmi.Remote") || ((Class)genericDeclarationArray[n]).getName().equals("javax.ejb.EJBObject") || ((Class)genericDeclarationArray[n]).getName().equals("javax.ejb.EJBHome")) {
                    bl = true;
                    continue block2;
                }
                if (RmiIIOPUtils.isValidRmiIIOPInterface((Class)genericDeclarationArray[n])) {
                    return true;
                }
                ++n;
            }
        } while ((clazz = clazz.getSuperclass()) != null && !bl);
        if (!bl) {
            return false;
        }
        try {
            genericDeclarationArray = clazz2.getDeclaredMethods();
            int n = 0;
            while (n < genericDeclarationArray.length) {
                Class[] classArray = ((Method)genericDeclarationArray[n]).getExceptionTypes();
                if (!EjbUtils.isValidRemoteException(classArray)) {
                    return false;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < genericDeclarationArray.length) {
                Class[] classArray = ((Method)genericDeclarationArray[n2]).getExceptionTypes();
                if (!RmiIIOPUtils.isValidRmiIIOPException(classArray)) {
                    return false;
                }
                ++n2;
            }
            Field[] fieldArray = clazz2.getFields();
            int n3 = 0;
            while (n3 < fieldArray.length) {
                if (!RmiIIOPUtils.isValidRmiIIOPField(fieldArray[n3])) {
                    return false;
                }
                ++n3;
            }
        }
        catch (Throwable throwable) {
            Verifier.debug(throwable);
            return false;
        }
        return bl;
    }

    public static boolean isValidRmiIIOPParameters(Class[] classArray) {
        if (classArray.length > 0) {
            int n = 0;
            while (n < classArray.length) {
                Class clazz = classArray[n];
                if (!(RmiIIOPUtils.isValidRmiIDLPrimitiveType(clazz) || RmiIIOPUtils.isValidRmiIIOPValueType(clazz) || RmiIIOPUtils.isValidRmiIIOPInterfaceType(clazz) || RmiIIOPUtils.isJavaLangStringType(clazz) || RmiIIOPUtils.isValidRmiIIOPException(classArray) || clazz.getName().equals("java.lang.Object") || RmiIIOPUtils.isValidRmiIIOPCORBAObjectType(clazz) || RmiIIOPUtils.isValidRmiIIOPIDLEntityType(clazz))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return true;
    }

    public static boolean isValidRmiIIOPCORBAObjectType(Class clazz) {
        Class clazz2 = clazz;
        boolean bl = false;
        block0: do {
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                if (classArray[n].getName().equals("org.omg.CORBA.Object")) {
                    bl = true;
                    continue block0;
                }
                Class<?> clazz3 = classArray[n];
                do {
                    if (!clazz3.getName().equals("org.omg.CORBA.Object")) continue;
                    bl = true;
                    break;
                } while ((clazz3 = clazz3.getSuperclass()) != null && !bl);
                ++n;
            }
        } while ((clazz2 = clazz2.getSuperclass()) != null && !bl);
        return bl;
    }

    public static boolean isValidRmiIIOPIDLEntityType(Class clazz) {
        Class clazz2 = clazz;
        boolean bl = false;
        block0: do {
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                if (classArray[n].getName().equals("org.omg.CORBA.portable.IDLEntity")) {
                    bl = true;
                    continue block0;
                }
                Class<?> clazz3 = classArray[n];
                do {
                    if (!clazz3.getName().equals("org.omg.CORBA.portable.IDLEntity")) continue;
                    bl = true;
                    break;
                } while ((clazz3 = clazz3.getSuperclass()) != null && !bl);
                ++n;
            }
        } while ((clazz2 = clazz2.getSuperclass()) != null && !bl);
        return bl;
    }

    public static boolean isValidRmiIIOPValueType(Class clazz) {
        int n;
        Class<?>[] classArray;
        Class clazz2 = clazz;
        boolean bl = false;
        boolean bl2 = false;
        if (clazz2.getName().equals("java.lang.Object")) {
            bl = true;
        }
        block0: do {
            classArray = clazz2.getInterfaces();
            n = 0;
            while (n < classArray.length) {
                if (classArray[n].getName().equals("java.io.Serializable")) {
                    bl = true;
                    continue block0;
                }
                Class<?> clazz3 = classArray[n];
                do {
                    if (!clazz3.getName().equals("java.io.Serializable")) continue;
                    bl = true;
                    break;
                } while ((clazz3 = clazz3.getSuperclass()) != null && !bl);
                ++n;
            }
        } while ((clazz2 = clazz2.getSuperclass()) != null && !bl);
        if (!bl) {
            return false;
        }
        clazz2 = clazz;
        block3: do {
            classArray = clazz2.getInterfaces();
            n = 0;
            while (n < classArray.length) {
                if (classArray[n].getName().equals("java.rmi.Remote")) {
                    bl2 = true;
                    continue block3;
                }
                ++n;
            }
        } while ((clazz2 = clazz2.getSuperclass()) != null && !bl2);
        if (bl2) {
            return false;
        }
        return bl;
    }

    public static boolean isValidRmiIIOPField(Field field) {
        boolean bl = false;
        if (RmiIIOPUtils.isValidRmiIDLPrimitiveType(field) || field.getType().equals("java.lang.String")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isValidRmiIDLPrimitiveType(Field field) {
        boolean bl = false;
        if (field.getType().getName().equals("void") || field.getType().getName().equals("boolean") || field.getType().getName().equals("byte") || field.getType().getName().equals("char") || field.getType().getName().equals("short") || field.getType().getName().equals("int") || field.getType().getName().equals("long") || field.getType().getName().equals("float") || field.getType().getName().equals("double")) {
            bl = true;
        }
        return bl;
    }

    private static boolean isValidRmiIIOPInterfaceType(Class clazz) {
        return clazz.isInterface();
    }

    public static boolean isValidRmiIDLPrimitiveType(Class clazz) {
        boolean bl = false;
        if (clazz.getName().equals("void") || clazz.getName().equals("boolean") || clazz.getName().equals("byte") || clazz.getName().equals("char") || clazz.getName().equals("short") || clazz.getName().equals("int") || clazz.getName().equals("long") || clazz.getName().equals("float") || clazz.getName().equals("double")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isJavaLangStringType(Class clazz) {
        boolean bl = false;
        if (clazz.getName().equals("java.lang.String")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isValidRmiIIOPException(Class[] classArray) {
        boolean bl = false;
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n].getName().equals("java.rmi.RemoteException") || classArray[n].getName().equals("RemoteException")) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public static boolean isValidRmiIIOPReturnType(Class clazz) {
        return RmiIIOPUtils.isValidRmiIDLPrimitiveType(clazz) || RmiIIOPUtils.isValidRmiIIOPValueType(clazz) || RmiIIOPUtils.isValidRmiIIOPInterfaceType(clazz) || RmiIIOPUtils.isJavaLangStringType(clazz) || RmiIIOPUtils.isValidRmiIIOPCORBAObjectType(clazz) || clazz.getName().equals("java.lang.Object") || RmiIIOPUtils.isValidRmiIIOPIDLEntityType(clazz);
    }

    public static boolean isValidSerializableType(Class clazz) {
        boolean bl = false;
        block0: do {
            Class<?>[] classArray = clazz.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                if (classArray[n].getName().equals("java.io.Serializable")) {
                    bl = true;
                    continue block0;
                }
                Class<?> clazz2 = classArray[n];
                do {
                    if (!clazz2.getName().equals("java.io.Serializable")) continue;
                    bl = true;
                    break;
                } while ((clazz2 = clazz2.getSuperclass()) != null && !bl);
                ++n;
            }
        } while ((clazz = clazz.getSuperclass()) != null && !bl);
        return bl;
    }

    public static boolean isPersistentFieldTypeValid(Class clazz, String string, String string2) {
        return RmiIIOPUtils.isValidRmiIDLPrimitiveType(clazz) || RmiIIOPUtils.isValidSerializableType(clazz) || clazz.getName().equals(string) || clazz.getName().equals(string2);
    }

    public static boolean isEjbFindMethodExceptionsSubsetOfFindMethodExceptions(Class[] classArray, Class[] classArray2) {
        boolean bl = false;
        if (Arrays.equals(classArray, classArray2)) {
            return true;
        }
        List<Class> list = Arrays.asList(classArray);
        List<Class> list2 = Arrays.asList(classArray2);
        if (!list.isEmpty()) {
            Iterator<Class> iterator = list.iterator();
            while (iterator.hasNext()) {
                Class clazz = iterator.next();
                if (list2.contains(clazz) || RmiIIOPUtils.isSuperClassofClass("java.lang.RuntimeException", clazz)) continue;
                bl = true;
                break;
            }
            return !bl;
        }
        return true;
    }

    private static boolean isSuperClassofClass(String string, Class clazz) {
        boolean bl = false;
        Class clazz2 = clazz;
        do {
            if (!clazz2.getName().equals(string)) continue;
            bl = true;
            break;
        } while ((clazz2 = clazz2.getSuperclass()) != null && !bl);
        return bl;
    }
}

