/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.sun.enterprise.security.acl.GuardedResource;
import com.sun.enterprise.security.acl.Resource;
import com.sun.enterprise.security.acl.ResourceGuard;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceAccessManager {
    private static Logger _logger = null;
    private static boolean debug;
    private Hashtable resTable = new Hashtable();

    public void protect(Resource resource, ResourceGuard resourceGuard) {
        if (!this.isProtected(resource)) {
            this.resTable.put(resource, resourceGuard);
            if (debug && _logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "ResourceAccessManage: Resource: " + resource + " is protected by " + resourceGuard);
            }
        }
    }

    public void unprotect(Resource resource) {
        if (this.isProtected(resource)) {
            this.resTable.remove(resource);
        }
    }

    public boolean isProtected(Resource resource) {
        boolean bl = this.resTable.containsKey(resource);
        if (!bl) {
            ResourceGuard resourceGuard = this.getResourceGuard(resource);
            return resourceGuard != null;
        }
        return true;
    }

    public GuardedResource getGuardedResource(Resource resource) {
        ResourceGuard resourceGuard = this.getResourceGuard(resource);
        if (resourceGuard != null) {
            return new GuardedResource(resource, resourceGuard);
        }
        return null;
    }

    private ResourceGuard getResourceGuard(Resource resource) {
        ResourceGuard resourceGuard = (ResourceGuard)this.resTable.get(resource);
        if (resourceGuard == null) {
            Enumeration enumeration = this.resTable.keys();
            while (enumeration.hasMoreElements()) {
                Resource resource2 = (Resource)enumeration.nextElement();
                if (!resource2.implies(resource)) continue;
                resourceGuard = (ResourceGuard)this.resTable.get(resource2);
                break;
            }
        }
        return resourceGuard;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        debug = false;
    }
}

