/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.sun.enterprise.security.acl.AccessControlEntry;
import com.sun.enterprise.security.acl.AccessControlList;
import com.sun.enterprise.security.acl.Role;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AccessControlListImpl
implements AccessControlList {
    private static boolean defaultPolicy;
    private Vector positiveEntries = new Vector(10);
    private Vector negativeEntries = new Vector(10);
    private HashSet positiveRoles = new HashSet();
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$enterprise$security$acl$AccessControlListImpl;

    public static boolean getDefaultPolicy() {
        return defaultPolicy;
    }

    public static synchronized void setDefaultPolicy(boolean bl) {
        defaultPolicy = bl;
    }

    public synchronized void addEntry(AccessControlEntry accessControlEntry) {
        if (accessControlEntry.isNegative()) {
            logger.log(Level.WARNING, "java_security.acl_nonegative", accessControlEntry.getRole());
        } else {
            this.positiveEntries.addElement(accessControlEntry);
            this.positiveRoles.add(accessControlEntry.getRole().getName());
        }
    }

    public synchronized void removeEntry(AccessControlEntry accessControlEntry) {
        if (!$assertionsDisabled && accessControlEntry.isNegative()) {
            throw new AssertionError();
        }
        this.positiveEntries.removeElement(accessControlEntry);
        this.positiveRoles.remove(accessControlEntry.getRole().getName());
    }

    public boolean checkAccess(Role role) {
        if (this.positiveRoles.contains(role.getName())) {
            return true;
        }
        return defaultPolicy;
    }

    public Enumeration getEntries() {
        Object object;
        Vector<Object> vector = new Vector<Object>(10);
        Enumeration enumeration = this.positiveEntries.elements();
        while (enumeration.hasMoreElements()) {
            object = (AccessControlEntry)enumeration.nextElement();
            vector.addElement(object);
        }
        object = this.negativeEntries.elements();
        while (object.hasMoreElements()) {
            AccessControlEntry accessControlEntry = (AccessControlEntry)object.nextElement();
            vector.addElement(accessControlEntry);
        }
        return vector.elements();
    }

    public String toString() {
        String string = "ACL{ ";
        Enumeration enumeration = this.getEntries();
        while (enumeration.hasMoreElements()) {
            string = string + enumeration.nextElement().toString() + " , ";
        }
        string = string + "}";
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$enterprise$security$acl$AccessControlListImpl == null ? (class$com$sun$enterprise$security$acl$AccessControlListImpl = AccessControlListImpl.class$("com.sun.enterprise.security.acl.AccessControlListImpl")) : class$com$sun$enterprise$security$acl$AccessControlListImpl).desiredAssertionStatus();
        defaultPolicy = false;
        logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    }
}

