/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.iplanet.ias.connectors.deployment.IASDeploymentException;
import com.iplanet.ias.connectors.deployment.IASMCFFactory;
import com.iplanet.ias.connectors.util.xml.InstancePropertiesObject;
import com.sun.enterprise.resource.IASConfigPool;
import com.sun.enterprise.resource.IASPoolHelper;
import com.sun.enterprise.resource.IASPoolManagerConstants;
import com.sun.enterprise.resource.IASPoolManagerException;
import com.sun.enterprise.resource.IASPoolObject;
import com.sun.enterprise.resource.IASPoolObjectImp;
import com.sun.enterprise.resource.PortabilityUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

public class IASPoolHelperImp
implements IASPoolHelper {
    ManagedConnectionFactory managedConnectionFactory = null;
    private String jndiName = null;
    static Logger _logger = PortabilityUtils.GetPoolManagerLogger();

    public IASPoolHelperImp(ManagedConnectionFactory managedConnectionFactory) throws ResourceException {
        this.managedConnectionFactory = managedConnectionFactory;
        try {
            this.jndiName = IASMCFFactory.getMCFFactory().getJNDINameByMCF(managedConnectionFactory);
        }
        catch (IASDeploymentException iASDeploymentException) {
            throw new ResourceException(iASDeploymentException.getMessage());
        }
        if (this.jndiName == null) {
            throw new ResourceException(IASPoolManagerConstants.JNDINAME_IS_NULL, "5");
        }
    }

    public IASPoolObject createPooledObject(Subject subject, Object object) throws IASPoolManagerException {
        _logger.log(Level.FINE, "In start of IASPoolHelperImp.createPooledObject().");
        ManagedConnection managedConnection = null;
        try {
            managedConnection = this.managedConnectionFactory.createManagedConnection(subject, (ConnectionRequestInfo)object);
        }
        catch (ResourceException resourceException) {
            String string = null;
            Exception exception = resourceException.getLinkedException();
            string = exception != null ? resourceException.getMessage() + ", " + exception.getMessage() : resourceException.getMessage();
            throw new IASPoolManagerException(string, resourceException.getErrorCode());
        }
        if (managedConnection == null) {
            throw new IASPoolManagerException(IASPoolManagerConstants.CREATE_POOL_OBJECT_ERROR, "6");
        }
        IASPoolObjectImp iASPoolObjectImp = new IASPoolObjectImp(managedConnection, null);
        _logger.log(Level.FINE, "In end of IASPoolHelperImp.createPooledObject().");
        return iASPoolObjectImp;
    }

    public Object matchPooledObject(Set set, Subject subject, Object object) throws IASPoolManagerException {
        _logger.log(Level.FINE, "In start of IASPoolHelperImp.matchPooledObject().");
        ManagedConnection managedConnection = null;
        try {
            managedConnection = this.managedConnectionFactory.matchManagedConnections(set, subject, (ConnectionRequestInfo)object);
        }
        catch (ResourceException resourceException) {
            String string = null;
            Exception exception = resourceException.getLinkedException();
            string = exception != null ? resourceException.getMessage() + ", " + exception.getMessage() : resourceException.getMessage();
            throw new IASPoolManagerException(string, resourceException.getErrorCode());
        }
        if (managedConnection == null) {
            return null;
        }
        _logger.log(Level.FINE, "In end of IASPoolHelperImp.matchPooledObject().");
        return managedConnection;
    }

    public IASConfigPool getConfigPool() {
        _logger.log(Level.FINE, "In start of IASPoolHelperImp.getConfigPool().");
        InstancePropertiesObject instancePropertiesObject = null;
        IASConfigPool iASConfigPool = new IASConfigPool();
        instancePropertiesObject = (InstancePropertiesObject)PortabilityUtils.GetInstancePropertiesObject(this.managedConnectionFactory);
        if (instancePropertiesObject != null) {
            int n = 0;
            n = instancePropertiesObject.getMaxPoolSize();
            if (n > 0) {
                iASConfigPool.setMaxPoolSize(n);
            }
            if ((n = instancePropertiesObject.getMaxWait()) > 0) {
                iASConfigPool.setMaxWait(n);
            }
            if ((n = instancePropertiesObject.getSteadyPoolSize()) > 0) {
                iASConfigPool.setSteadyPoolSize(n);
            }
            n = instancePropertiesObject.getUnusedMaxLife() * 1000;
            iASConfigPool.setUnusedMaxLife(n);
            _logger.log(Level.FINE, "Pool's configuration: ");
            _logger.log(Level.FINE, "maxPoolSize= " + iASConfigPool.getMaxPoolSize());
            _logger.log(Level.FINE, "maxWait= " + iASConfigPool.getMaxWait());
            _logger.log(Level.FINE, "steadyPoolSize= " + iASConfigPool.getSteadyPoolSize());
            _logger.log(Level.FINE, "unusedMaxLife= " + iASConfigPool.getUnusedMaxLife());
        }
        _logger.log(Level.FINE, "In end of IASPoolHelperImp.getConfigPool().");
        return iASConfigPool;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public String toString() {
        return this.jndiName;
    }
}

