/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.logging.LogDomains;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GSSUPName {
    private static Logger _logger = null;
    public static final char AT_CHAR = '@';
    public static final String AT_STRING = "@";
    public static final char ESCAPE_CHAR = '\\';
    public static final String ESCAPE_STRING = "\\";
    private String username;
    private String realm;

    public GSSUPName(String string, String string2) {
        this.username = string;
        this.realm = string2;
    }

    public GSSUPName(byte[] byArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        int n3 = -1;
        String string = "";
        String string2 = "";
        String string3 = "";
        byte[] byArray2 = new byte[]{};
        _logger.log(Level.FINE, "Attempting to create a mechanism specific name from the exported name.");
        try {
            byArray2 = GSSUtils.importName(GSSUtils.GSSUP_MECH_OID, byArray);
            string = new String(byArray2, "UTF8");
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.importname_exception", exception);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mechanism specific name: " + string);
        }
        int n4 = string.indexOf(64);
        int n5 = string.indexOf(92);
        if (n4 == -1) {
            string2 = string;
        } else if (n5 == -1) {
            if (n4 != 0) {
                string2 = string.substring(0, n4);
            }
            string3 = string.substring(n4 + 1);
        } else {
            n3 = 0;
            n2 = 0;
            n = 0;
            while ((n = string.indexOf(64, n)) != -1) {
                if (string.charAt(n - 1) != '\\') {
                    n2 = n;
                    break;
                }
                ++n;
            }
            string2 = string.substring(n3, n2);
            string3 = string.substring(n2 + 1);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "name_value: " + string2 + " ;  name_scope: " + string3);
        }
        if (string2.length() > 0 && n4 != -1) {
            stringBuffer = new StringBuffer("");
            n = 0;
            int n6 = 0;
            while ((n6 = string2.indexOf(92, n)) != -1) {
                stringBuffer.append(string2.substring(n, n6));
                n = n6 + 1;
            }
            stringBuffer.append(string2.substring(n));
            string2 = stringBuffer.toString();
        }
        this.username = string2;
        this.realm = string3;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Constructed GSSUPName ( " + this.toString() + " )");
        }
    }

    protected byte[] getExportedName() {
        byte[] byArray = new byte[]{};
        byte[] byArray2 = new byte[]{};
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Going to create exported name for:" + this.toString());
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.username.indexOf(64);
        int n2 = this.username.indexOf(92);
        if (n == -1 && n2 == -1) {
            stringBuffer = new StringBuffer(this.username);
        } else {
            StringTokenizer stringTokenizer;
            if (n2 != -1) {
                stringTokenizer = new StringTokenizer(this.username, ESCAPE_STRING);
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(stringTokenizer.nextToken());
                    stringBuffer.append('\\').append('\\');
                }
            }
            if (n != -1) {
                stringTokenizer = new StringTokenizer(this.username, AT_STRING);
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(stringTokenizer.nextToken());
                    stringBuffer.append('\\').append('@');
                }
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "username after processing for @ and \\: " + stringBuffer);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "username and realm name : " + stringBuffer);
        }
        try {
            byArray2 = stringBuffer.toString().getBytes("UTF8");
            byArray = GSSUtils.createExportedName(GSSUtils.GSSUP_MECH_OID, byArray2);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.createexportedname_exception", exception);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "GSSUPName in exported format = " + GSSUtils.dumpHex(byArray));
        }
        return byArray;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getUser() {
        return this.username;
    }

    public boolean equals(Object object) {
        GSSUPName gSSUPName;
        return object instanceof GSSUPName && (gSSUPName = (GSSUPName)object).getUser().equals(this.username) && gSSUPName.getRealm().equals(this.realm);
    }

    public int hashCode() {
        return this.username.hashCode() + this.realm.hashCode();
    }

    public String toString() {
        String string = "Username = " + this.username;
        string = string + " Realm = " + this.realm;
        return string;
    }

    private static void testGSSUP(String string, String string2) {
        _logger.log(Level.FINE, "Running unit test for TestGSSUPName.");
        _logger.log(Level.FINE, "Creating a GSSUPName instance");
        GSSUPName gSSUPName = new GSSUPName(string, string2);
        _logger.log(Level.FINE, "GSSUPName : " + gSSUPName.toString());
        _logger.log(Level.FINE, "Obtaining an exported name form");
        byte[] byArray = gSSUPName.getExportedName();
        _logger.log(Level.FINE, "Creating a GSSUPName instance from exported name");
        GSSUPName gSSUPName2 = new GSSUPName(byArray);
        _logger.log(Level.FINE, "GSSUPName created from exported name: " + gSSUPName2.toString());
    }

    public static void main(String[] stringArray) {
        GSSUPName.testGSSUP("sekhar@vajjha@la@", "sun.com");
        GSSUPName.testGSSUP("sekhar", "sun.com");
        GSSUPName.testGSSUP("sekhar", "");
        GSSUPName.testGSSUP("", "sun.com");
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
    }
}

