/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.connection.EndPointInfo;
import com.sun.corba.ee.connection.GetEndPointInfoAgainException;
import com.sun.corba.ee.connection.ORBSocketFactory;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.ior.IIOPAddress;
import com.sun.corba.ee.internal.ior.IIOPProfileTemplate;
import com.sun.enterprise.iiop.AlternateIIOPAddressComponent;
import com.sun.enterprise.iiop.AlternateIIOPAddressComponentHelper;
import com.sun.enterprise.iiop.EndPointInfoImpl;
import com.sun.enterprise.iiop.POAEJBORB;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.security.J2EEKeyManager;
import com.sun.enterprise.security.KeyTool;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.server.J2EEServer;
import com.sun.logging.LogDomains;
import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509KeyManager;
import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedComponent;

public class IIOPSSLSocketFactory
implements ORBSocketFactory,
Serializable {
    private static Logger _logger = null;
    public static final boolean debug = false;
    private static final String SSL = "SSL";
    private static final String SSL_MUTUALAUTH = "SSL_MUTUALAUTH";
    private static final String PERSISTENT_SSL = "PERSISTENT_SSL";
    private static final String CLEAR = "IIOP_CLEAR_TEXT";
    private static final String clientStr = "true";
    private String type = null;
    private int sslPort = 0;
    private SSLContext ctx = null;
    private String[] cipherSuites = null;
    private static SecureRandom sr;
    private Hashtable endpointTable = new Hashtable();
    private Codec codec;
    private static KeyManagerFactory keyManagerFactory;
    private static TrustManagerFactory trustManagerFactory;

    private void init() {
        try {
            if (keyManagerFactory == null || trustManagerFactory == null) {
                SSLUtils.initKeyStore();
            }
            this.ctx = SSLContext.getInstance((String)"TLS");
            KeyManagerFactory keyManagerFactory = IIOPSSLSocketFactory.keyManagerFactory;
            TrustManagerFactory trustManagerFactory = IIOPSSLSocketFactory.trustManagerFactory;
            this.ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), sr);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.init_exception", exception);
        }
    }

    private void clientInit() {
        try {
            if (keyManagerFactory == null || trustManagerFactory == null) {
                SSLUtils.initKeyStore();
            }
            this.ctx = SSLContext.getInstance((String)"TLS");
            KeyManagerFactory keyManagerFactory = IIOPSSLSocketFactory.keyManagerFactory;
            TrustManagerFactory trustManagerFactory = IIOPSSLSocketFactory.trustManagerFactory;
            KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
            J2EEKeyManager[] j2EEKeyManagerArray = new J2EEKeyManager[keyManagerArray.length];
            int n = 0;
            while (n < keyManagerArray.length) {
                j2EEKeyManagerArray[n] = new J2EEKeyManager((X509KeyManager)keyManagerArray[n]);
                ++n;
            }
            this.ctx.init((KeyManager[])j2EEKeyManagerArray, trustManagerFactory.getTrustManagers(), sr);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.client_init_exception", exception);
        }
    }

    public ServerSocket createServerSocket(String string, int n) throws IOException {
        if (string.equals(SSL_MUTUALAUTH) || string.equals(SSL) || string.equals(PERSISTENT_SSL)) {
            return this.createSSLServerSocket(string, n);
        }
        return new ServerSocket(n);
    }

    private ServerSocket createSSLServerSocket(String string, int n) throws IOException {
        if (this.ctx == null) {
            this.init();
        }
        SSLServerSocketFactory sSLServerSocketFactory = this.ctx.getServerSocketFactory();
        ServerSocket serverSocket = sSLServerSocketFactory.createServerSocket(n);
        try {
            if (this.cipherSuites != null) {
                ((SSLServerSocket)serverSocket).setEnabledCipherSuites(this.cipherSuites);
                if (string.equals(SSL_MUTUALAUTH)) {
                    ((SSLServerSocket)serverSocket).setNeedClientAuth(true);
                }
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        return serverSocket;
    }

    public EndPointInfo getEndPointInfo(ORB oRB, IOR iOR, EndPointInfo endPointInfo) {
        try {
            POAEJBORB pOAEJBORB = (POAEJBORB)oRB;
            SecurityMechanismSelector securityMechanismSelector = new SecurityMechanismSelector();
            IIOPProfileTemplate iIOPProfileTemplate = iOR.getProfile().getTemplate();
            IIOPAddress iIOPAddress = iIOPProfileTemplate.getPrimaryAddress();
            String string = iIOPAddress.getHost().toLowerCase();
            int n = 0;
            ConnectionContext connectionContext = new ConnectionContext();
            EndPointInfo endPointInfo2 = securityMechanismSelector.getSSLPort(iOR, connectionContext);
            securityMechanismSelector.setClientConnectionContext(connectionContext);
            if (endPointInfo2 == null) {
                this.type = CLEAR;
                n = iIOPAddress.getPort();
            } else {
                this.type = endPointInfo2.getType();
                n = endPointInfo2.getPort();
            }
            endPointInfo = (EndPointInfoImpl)this.endpointTable.get(string + n);
            if (endPointInfo != null) {
                return endPointInfo;
            }
            TaggedComponent[] taggedComponentArray = iOR.getProfile().getIOPComponents(oRB, 89374);
            if (taggedComponentArray.length > 0) {
                this.getCodec(oRB);
                int n2 = 0;
                while (n2 < taggedComponentArray.length) {
                    byte[] byArray = taggedComponentArray[n2].component_data;
                    Any any = null;
                    try {
                        any = this.codec.decode_value(byArray, AlternateIIOPAddressComponentHelper.type());
                    }
                    catch (TypeMismatch typeMismatch) {
                        throw new RuntimeException(typeMismatch.toString());
                    }
                    catch (FormatMismatch formatMismatch) {
                        throw new RuntimeException(formatMismatch.toString());
                    }
                    AlternateIIOPAddressComponent alternateIIOPAddressComponent = AlternateIIOPAddressComponentHelper.extract(any);
                    endPointInfo = (EndPointInfoImpl)this.endpointTable.get(alternateIIOPAddressComponent.host + alternateIIOPAddressComponent.port);
                    if (endPointInfo != null) {
                        this.endpointTable.put(string + n, endPointInfo);
                        return endPointInfo;
                    }
                    ++n2;
                }
                endPointInfo = new EndPointInfoImpl(this.type, string, n);
                this.endpointTable.put(string + n, endPointInfo);
            } else {
                endPointInfo = new EndPointInfoImpl(this.type, string, n);
                this.endpointTable.put(string + n, endPointInfo);
            }
            return endPointInfo;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Codec getCodec(ORB oRB) {
        if (this.codec == null) {
            IIOPSSLSocketFactory iIOPSSLSocketFactory = this;
            synchronized (iIOPSSLSocketFactory) {
                CodecFactory codecFactory = null;
                try {
                    codecFactory = CodecFactoryHelper.narrow(oRB.resolve_initial_references("CodecFactory"));
                }
                catch (InvalidName invalidName) {
                    System.out.println("Getting org.omg.CORBA.ORBPackage.InvalidName exception");
                }
                Encoding encoding = new Encoding(0, 1, 2);
                try {
                    this.codec = codecFactory.create_codec(encoding);
                }
                catch (UnknownEncoding unknownEncoding) {
                    System.out.println("Getting org.omg.IOP.CodecFactoryPackage.UnknownEncoding exception");
                }
            }
        }
        return this.codec;
    }

    private int shortToInt(short s) {
        if (s < 0) {
            return s + 65536;
        }
        return s;
    }

    public Socket createSocket(EndPointInfo endPointInfo) throws IOException, GetEndPointInfoAgainException {
        try {
            String string = endPointInfo.getType();
            String string2 = endPointInfo.getHost();
            int n = endPointInfo.getPort();
            if (string.equals(SSL) || string.equals(SSL_MUTUALAUTH)) {
                return this.createSSLSocket(string2, n);
            }
            return new Socket(string2, n);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    private Socket createSSLSocket(String string, int n) throws IOException {
        SSLSocket sSLSocket = null;
        SSLSocketFactory sSLSocketFactory = null;
        try {
            if (clientStr != null && clientStr.equals(clientStr)) {
                if (this.ctx == null) {
                    this.clientInit();
                }
                sSLSocketFactory = this.ctx.getSocketFactory();
            } else {
                sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            }
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        return sSLSocket;
    }

    public static void setFactories(KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory) {
        IIOPSSLSocketFactory.keyManagerFactory = keyManagerFactory;
        IIOPSSLSocketFactory.trustManagerFactory = trustManagerFactory;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
        KeyTool.initProvider();
        sr = J2EEServer.secureRandom;
        keyManagerFactory = null;
        trustManagerFactory = null;
    }
}

