/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient;

import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.security.ClientSecurityContext;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.logging.LogDomains;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class HttpAuthenticator
extends Authenticator {
    public static final boolean debug = false;
    private AppContainer container = null;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.appclient");

    public HttpAuthenticator(AppContainer appContainer) {
        this.container = appContainer;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        String string = null;
        String string2 = null;
        Subject subject = null;
        String string3 = this.getRequestingScheme();
        _logger.fine("scheme=" + string3);
        _logger.fine("requesting prompt=" + this.getRequestingPrompt());
        _logger.fine("requesting protocol=" + this.getRequestingProtocol());
        ClientSecurityContext clientSecurityContext = ClientSecurityContext.getCurrent();
        subject = clientSecurityContext.getSubject();
        string = this.getUserName(subject);
        string2 = this.getPassword(subject);
        if (string == null || string2 == null) {
            try {
                _logger.fine("Initiating login again...");
                LoginContextDriver.doClientLogin(1, AppContainer.handler);
                clientSecurityContext = ClientSecurityContext.getCurrent();
                subject = clientSecurityContext.getSubject();
                string = this.getUserName(subject);
                string2 = this.getPassword(subject);
            }
            catch (Exception exception) {
                _logger.log(Level.FINE, "Exception " + exception.toString(), exception);
                return null;
            }
        }
        _logger.fine("Username:" + string + " Password:" + string2);
        return new PasswordAuthentication(string, string2.toCharArray());
    }

    private String getUserName(Subject subject) {
        String string = null;
        if (subject == null) {
            return null;
        }
        Set<Principal> set = subject.getPrincipals();
        Iterator<Principal> iterator = set.iterator();
        if (iterator.hasNext()) {
            Principal principal = iterator.next();
            string = principal.getName();
        }
        return string;
    }

    private String getPassword(Subject subject) {
        Object object;
        String string = null;
        if (subject == null) {
            return null;
        }
        Set<Object> set = subject.getPrivateCredentials();
        Iterator<Object> iterator = set.iterator();
        if (iterator.hasNext() && (object = iterator.next()) instanceof PasswordCredential) {
            PasswordCredential passwordCredential = (PasswordCredential)object;
            string = passwordCredential.getPassword();
        }
        return string;
    }
}

