/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.cache;

import com.iplanet.ias.util.threadpool.Servicable;
import com.sun.appserv.util.cache.CacheListener;
import com.sun.ejb.EJBUtils;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.SessionFileCacheStore;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.containers.util.ContainerWorkPool;
import com.sun.ejb.containers.util.cache.BaseCache;
import com.sun.ejb.containers.util.cache.LruCache;
import com.sun.ejb.containers.util.cache.PassivatedBeansCache;
import com.sun.ejb.containers.util.cache.PassivatedSessionInfo;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;

public class LruSessionCache
extends LruCache {
    protected static final int IN_CACHE = 0;
    protected static final int ALIVE = 1;
    protected static final int PASSIVATED = 2;
    protected static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    protected PassivatedBeansCache passivatedSessions;
    protected Object activatedLock;
    protected int numActivated;
    protected SessionFileCacheStore fileCacheStore;
    protected int cacheIdleTimeoutInSeconds;
    protected int removalTimeoutInSeconds;
    protected StatefulSessionContainer container;
    protected IdleBeanCleanerTimerTask idleBeanCleanerTimerTask;
    protected Object idleBeanCleanerTimerTaskLock;
    protected boolean addedIdleBeanCleanerTimerTask;
    protected Object loadCountLock;
    protected int loadFromBackupCount;
    protected boolean removeIfIdle;
    public int passivationCount;
    protected Object passivationCountLock;
    protected String cacheName;
    private Object numPassLock;
    private int numPassivations;
    private int numPassivationSuccess;
    private int numPassivationErrors;
    private int numVictimsAccessed;

    public void destroy() {
        this.fileCacheStore = null;
        this.container = null;
        this.idleBeanCleanerTimerTask = null;
        super.destroy();
    }

    public LruSessionCache(String string, StatefulSessionContainer statefulSessionContainer, int n, int n2) {
        block3: {
            this.activatedLock = new Object();
            this.idleBeanCleanerTimerTaskLock = new Object();
            this.addedIdleBeanCleanerTimerTask = false;
            this.loadCountLock = new Object();
            this.removeIfIdle = false;
            this.passivationCount = 0;
            this.passivationCountLock = new Object();
            this.numPassLock = new Object();
            this.numVictimsAccessed = 0;
            this.cacheName = string;
            this.container = statefulSessionContainer;
            this.cacheIdleTimeoutInSeconds = n <= 0 ? 0 : n;
            this.removalTimeoutInSeconds = n2 <= 0 ? 0 : n2;
            this.passivatedSessions = new PassivatedBeansCache(string, statefulSessionContainer, this.removalTimeoutInSeconds <= this.cacheIdleTimeoutInSeconds ? 0 : this.removalTimeoutInSeconds);
            this.passivatedSessions.init(8192);
            if (this.cacheIdleTimeoutInSeconds > 0) {
                this.timeout = this.cacheIdleTimeoutInSeconds * 1000;
                try {
                    this.idleBeanCleanerTimerTask = new IdleBeanCleanerTimerTask(this.idleBeanCleanerTimerTaskLock);
                    ContainerFactoryImpl.getTimer().scheduleAtFixedRate((TimerTask)this.idleBeanCleanerTimerTask, this.cacheIdleTimeoutInSeconds * 1000, (long)(this.cacheIdleTimeoutInSeconds * 1000));
                }
                catch (Throwable throwable) {
                    if (!_logger.isLoggable(Level.WARNING)) break block3;
                    _logger.log(Level.WARNING, "[LruSessionCache]: Could not add PoolTimerTask. Continuing anyway...", throwable);
                }
            }
        }
        this.removeIfIdle = this.removalTimeoutInSeconds <= this.cacheIdleTimeoutInSeconds;
    }

    public void setSessionFileCacheStore(SessionFileCacheStore sessionFileCacheStore) {
        this.fileCacheStore = sessionFileCacheStore;
        this.passivatedSessions.setSessionFileCacheStore(sessionFileCacheStore);
    }

    public void cancelTimerTasks() {
        try {
            this.idleBeanCleanerTimerTask.cancel();
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "[LruSessionCache] cancelTimerTasks():  Exception when cancelling CacheIdleCleanerTask", exception);
        }
        try {
            this.passivatedSessions.cancelTimerTasks();
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "[LruSessionCache] cancelTimerTasks():  Exception when cancelling IdlePassivatedBeansTask", exception);
        }
    }

    protected void trimItem(BaseCache.CacheItem cacheItem) {
        LruCache.LruCacheItem lruCacheItem = (LruCache.LruCacheItem)cacheItem;
        if (this.removeIfIdle) {
            SessionContextImpl sessionContextImpl = (SessionContextImpl)cacheItem.value;
            long l = System.currentTimeMillis() - (long)(this.removalTimeoutInSeconds * 1000);
            if (sessionContextImpl.getLastTimeUsed() <= l) {
                this.container.passivateEJB(sessionContextImpl);
                return;
            }
        }
        int n = 0;
        while (n < this.listeners.size()) {
            CacheListener cacheListener = (CacheListener)this.listeners.get(n);
            cacheListener.trimEvent(lruCacheItem.key, lruCacheItem.value);
            ++n;
        }
    }

    protected void itemAccessed(BaseCache.CacheItem cacheItem) {
        LruCache.LruCacheItem lruCacheItem = (LruCache.LruCacheItem)cacheItem;
        if (lruCacheItem.isTrimmed) {
            lruCacheItem.isTrimmed = false;
            ++this.numVictimsAccessed;
            BaseCache.CacheItem cacheItem2 = super.itemAdded(cacheItem);
            if (cacheItem2 != null) {
                this.trimItem(cacheItem2);
            }
        } else {
            super.itemAccessed(cacheItem);
        }
    }

    protected Object loadFromBackup(PassivatedSessionInfo passivatedSessionInfo, Long l, StatefulSessionContainer statefulSessionContainer, EJBLocalRemoteObject eJBLocalRemoteObject) {
        try {
            byte[] byArray = this.loadState(l);
            if (byArray == null) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, this.cacheName + ": Cannot load from " + " BACKUPSTORE FOR Key: <" + l + ">");
                }
                return null;
            }
            this.incrementLoadFromBackupCount();
            return EJBUtils.deserializeObject(byArray, statefulSessionContainer.getClassLoader());
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, this.cacheName + ": Exception while " + " loading from backup session: <" + l + ">", exception);
            }
            return null;
        }
        catch (Error error) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, this.cacheName + ": Error while " + " loading from backup session: <" + l + ">", error);
            }
            return null;
        }
    }

    public int getLoadFromBackupCount() {
        return this.loadFromBackupCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementLoadFromBackupCount() {
        Object object = this.loadCountLock;
        synchronized (object) {
            ++this.loadFromBackupCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionContextImpl lookupEJB(Long l, StatefulSessionContainer statefulSessionContainer, EJBLocalRemoteObject eJBLocalRemoteObject) {
        int n = this.hash(l);
        int n2 = this.getIndex(n);
        Object object = null;
        BaseCache.CacheItem cacheItem = null;
        PassivatedSessionInfo passivatedSessionInfo = null;
        Object object2 = this.bucketLocks[n2];
        synchronized (object2) {
            cacheItem = this.buckets[n2];
            while (cacheItem != null) {
                if (n == cacheItem.hashCode && cacheItem.key.equals(l)) break;
                cacheItem = cacheItem.next;
            }
            if (cacheItem != null) {
                object = cacheItem.getValue();
                this.itemAccessed(cacheItem);
            } else {
                passivatedSessionInfo = this.passivatedSessions.get(l);
            }
        }
        if (cacheItem != null) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
            if (passivatedSessionInfo != null) {
                PassivatedSessionInfo passivatedSessionInfo2 = passivatedSessionInfo;
                synchronized (passivatedSessionInfo2) {
                    object = this.loadFromBackup(passivatedSessionInfo, l, statefulSessionContainer, eJBLocalRemoteObject);
                    if (object == null) {
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, "[" + this.cacheName + ".1]: Invalid sessionID: " + l);
                        }
                        return null;
                    }
                }
                boolean bl = false;
                BaseCache.CacheItem cacheItem2 = null;
                Object object3 = this.bucketLocks[n2];
                synchronized (object3) {
                    cacheItem = this.buckets[n2];
                    while (cacheItem != null) {
                        if (n == cacheItem.hashCode && cacheItem.key.equals(l)) break;
                        cacheItem = cacheItem.next;
                    }
                    if (cacheItem != null) {
                        object = cacheItem.getValue();
                    } else {
                        BaseCache.CacheItem cacheItem3 = this.createItem(n, l, object, -1);
                        cacheItem3.next = this.buckets[n2];
                        this.buckets[n2] = cacheItem3;
                        bl = true;
                        cacheItem2 = this.itemAdded(cacheItem3);
                    }
                }
                if (bl) {
                    try {
                        if (cacheItem2 != null) {
                            this.trimItem(cacheItem2);
                        }
                        statefulSessionContainer.activateEJB((SessionContextImpl)object, l, eJBLocalRemoteObject);
                        this.incrementEntryCount();
                    }
                    catch (EJBException eJBException) {
                        this.remove(l);
                        return null;
                    }
                }
            } else if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "[" + this.cacheName + ".2]: Invalid sessionID: " + l);
            }
        }
        return (SessionContextImpl)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Long l) {
        int n = this.hash(l);
        int n2 = this.getIndex(n);
        BaseCache.CacheItem cacheItem = null;
        BaseCache.CacheItem cacheItem2 = null;
        PassivatedSessionInfo passivatedSessionInfo = null;
        Object object = this.bucketLocks[n2];
        synchronized (object) {
            cacheItem2 = this.buckets[n2];
            while (cacheItem2 != null) {
                if (n == cacheItem2.hashCode && l.equals(cacheItem2.key)) {
                    if (cacheItem == null) {
                        this.buckets[n2] = cacheItem2.next;
                    } else {
                        cacheItem.next = cacheItem2.next;
                    }
                    cacheItem2.next = null;
                    this.itemRemoved(cacheItem2);
                    break;
                }
                cacheItem = cacheItem2;
                cacheItem2 = cacheItem2.next;
            }
            if (cacheItem2 == null) {
                passivatedSessionInfo = this.passivatedSessions.remove(l);
            }
        }
        if (cacheItem2 != null) {
            this.decrementEntryCount();
            this.incrementRemovalCount();
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
    }

    public void removePassivatedEJB(Long l) {
        try {
            this.remove(l);
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean passivateEJB(SessionContextImpl sessionContextImpl, Long l) {
        try {
            Object object;
            int n = this.hash(l);
            int n2 = this.getIndex(n);
            Object var5_6 = null;
            boolean bl = false;
            BaseCache.CacheItem cacheItem = null;
            BaseCache.CacheItem cacheItem2 = null;
            Object object2 = this.bucketLocks[n2];
            synchronized (object2) {
                cacheItem2 = this.buckets[n2];
                while (cacheItem2 != null) {
                    if (cacheItem2.value == sessionContextImpl) {
                        object = (LruCache.LruCacheItem)cacheItem2;
                        if (((LruCache.LruCacheItem)object).isTrimmed) break;
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, this.cacheName + ": session accessed after marked for passivation: " + l);
                        }
                        return false;
                    }
                    cacheItem = cacheItem2;
                    cacheItem2 = cacheItem2.next;
                }
                if (cacheItem2 == null) {
                    return this.passivatedSessions.get(l) != null;
                }
                if (this.removeIfIdle) {
                    long l2 = System.currentTimeMillis() - (long)(this.removalTimeoutInSeconds * 1000);
                    if (sessionContextImpl.getLastTimeUsed() <= l2) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, this.cacheName + ": Removing session " + " instead of passivating for key: " + l);
                        }
                        if (cacheItem == null) {
                            this.buckets[n2] = cacheItem2.next;
                        } else {
                            cacheItem.next = cacheItem2.next;
                        }
                        cacheItem2.next = null;
                        bl = true;
                        this.passivatedSessions.incrementExpiredSessionsRemoved();
                    }
                }
            }
            if (bl) {
                this.decrementEntryCount();
                this.incrementRemovalCount();
                return true;
            }
            try {
                this.incrementNumPassivations();
                object = EJBUtils.serializeObject(sessionContextImpl);
                this.saveState(l, (byte[])object);
            }
            catch (Exception exception) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, this.cacheName + ": ERROR While passivating " + " key: " + l, exception);
                }
                this.incrementNumPassivationErrors();
                return false;
            }
            object = this.bucketLocks[n2];
            synchronized (object) {
                cacheItem = null;
                cacheItem2 = this.buckets[n2];
                while (cacheItem2 != null) {
                    if (cacheItem2.value == sessionContextImpl) {
                        LruCache.LruCacheItem lruCacheItem = (LruCache.LruCacheItem)cacheItem2;
                        if (!lruCacheItem.isTrimmed) {
                            return false;
                        }
                        if (cacheItem == null) {
                            this.buckets[n2] = cacheItem2.next;
                        } else {
                            cacheItem.next = cacheItem2.next;
                        }
                        cacheItem2.next = null;
                        break;
                    }
                    cacheItem = cacheItem2;
                    cacheItem2 = cacheItem2.next;
                }
                this.passivatedSessions.put(l, (int)(sessionContextImpl.getLastTimeUsed() / 1000L));
                this.incrementNumPassivationSuccess();
            }
            if (cacheItem2 != null) {
                this.decrementEntryCount();
                this.incrementRemovalCount();
            }
            return true;
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "[" + this.cacheName + "]: passivateEJB(), Exception caught -> ", exception);
            return false;
        }
    }

    private void saveState(Long l, byte[] byArray) throws Exception {
        this.fileCacheStore.saveState(l, byArray);
    }

    private synchronized byte[] loadState(Long l) throws Exception {
        return this.fileCacheStore.loadState(l);
    }

    private synchronized void removeState(Long l) throws Exception {
        this.fileCacheStore.removeState(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimSelectedVictims(ArrayList arrayList) {
        int n = arrayList.size();
        LruSessionCache lruSessionCache = this;
        synchronized (lruSessionCache) {
            this.trimCount += n;
        }
        BaseCache.CacheItem cacheItem = null;
        int n2 = 0;
        while (n2 < n) {
            cacheItem = (BaseCache.CacheItem)arrayList.get(n2);
            this.trimItem(cacheItem);
            ++n2;
        }
    }

    public void undeploy(StatefulSessionContainer statefulSessionContainer) {
        this.cancelTimerTasks();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            SessionContextImpl sessionContextImpl = (SessionContextImpl)enumeration.nextElement();
            try {
                statefulSessionContainer.undeploy(sessionContextImpl);
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.WARNING)) continue;
                _logger.log(Level.WARNING, "[" + this.cacheName + "]: Error while " + " undeploying SessionCache...", exception);
            }
        }
        this.passivatedSessions.undeploy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimTimedoutItems(int n) {
        int n2 = 0;
        long l = System.currentTimeMillis();
        long l2 = l - (long)(this.cacheIdleTimeoutInSeconds * 1000);
        ArrayList<LruCache.LruCacheItem> arrayList = new ArrayList<LruCache.LruCacheItem>();
        LruSessionCache lruSessionCache = this;
        synchronized (lruSessionCache) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[" + this.cacheName + "]: IdleBeanCleanerTask started...");
            }
            if (this.tail == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[" + this.cacheName + "]: IdleBeanCleanerTask " + " finished after removing 0 idle beans");
                }
                this.head = null;
                return;
            }
            LruCache.LruCacheItem lruCacheItem = this.tail;
            while (true) {
                EJBContextImpl eJBContextImpl;
                if ((eJBContextImpl = (EJBContextImpl)lruCacheItem.value) != null) {
                    if (eJBContextImpl.getLastTimeUsed() > l2 || !this.container.canPassivateEJB(eJBContextImpl)) break;
                    lruCacheItem.isTrimmed = true;
                    arrayList.add(lruCacheItem);
                }
                if ((lruCacheItem = lruCacheItem.lPrev) == null) break;
                lruCacheItem.lNext.lPrev = null;
                lruCacheItem.lNext = null;
            }
            if (lruCacheItem == this.tail) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[" + this.cacheName + "]: IdleBeanCleanerTask " + " finished after removing 0 idle beans");
                }
                return;
            }
            if (lruCacheItem == null) {
                this.head = null;
            }
            this.tail = lruCacheItem;
            n2 = arrayList.size();
            this.listSize -= n2;
            this.trimCount += n2;
        }
        int n3 = 0;
        while (n3 < n2) {
            this.trimItem((LruCache.LruCacheItem)arrayList.get(n3));
            ++n3;
        }
        if (_logger.isLoggable(Level.WARNING)) {
            _logger.log(Level.WARNING, "[" + this.cacheName + "]: IdleBeanCleanerTask " + " finished after removing " + n2 + " idle beans");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimUnSortedTimedoutItems(int n) {
        int n2 = this.buckets.length;
        long l = System.currentTimeMillis() - this.timeout;
        ArrayList<LruCache.LruCacheItem> arrayList = new ArrayList<LruCache.LruCacheItem>();
        int n3 = 0;
        int n4 = 0;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[" + this.cacheName + "]: IdleBeanCleanerTask started...");
        }
        int n5 = 0;
        while (n5 < n2) {
            if (this.buckets[n5] != null) {
                Object object = this.bucketLocks[n5];
                synchronized (object) {
                    BaseCache.CacheItem cacheItem = this.buckets[n5];
                    while (cacheItem != null) {
                        SessionContextImpl sessionContextImpl = (SessionContextImpl)cacheItem.value;
                        if (sessionContextImpl != null && sessionContextImpl.getLastTimeUsed() <= l && this.container.canPassivateEJB(sessionContextImpl)) {
                            LruCache.LruCacheItem lruCacheItem = (LruCache.LruCacheItem)cacheItem;
                            LruSessionCache lruSessionCache = this;
                            synchronized (lruSessionCache) {
                                if (!lruCacheItem.isTrimmed) {
                                    this.itemRemoved(lruCacheItem);
                                    lruCacheItem.isTrimmed = true;
                                    arrayList.add(lruCacheItem);
                                }
                            }
                        }
                        cacheItem = cacheItem.next;
                    }
                }
                n3 = arrayList.size();
                if (n3 >= this.container.getPassivationBatchCount()) {
                    this.trimSelectedVictims(arrayList);
                    n4 += n3;
                    arrayList.clear();
                }
            }
            ++n5;
        }
        n3 = arrayList.size();
        if (n3 > 0) {
            this.trimSelectedVictims(arrayList);
            n4 += n3;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[" + this.cacheName + "]: IdleBeanCleanerTask " + " finished after removing " + n4 + " idle beans");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementNumPassivations() {
        Object object = this.numPassLock;
        synchronized (object) {
            ++this.numPassivations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementNumPassivationSuccess() {
        Object object = this.numPassLock;
        synchronized (object) {
            ++this.numPassivationSuccess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementNumPassivationErrors() {
        Object object = this.numPassLock;
        synchronized (object) {
            ++this.numPassivationErrors;
        }
    }

    public int getNumPassivations() {
        return this.numPassivations;
    }

    public int getNumPassivationErrors() {
        return this.numPassivationErrors;
    }

    public int getNumPassivationSuccess() {
        return this.numPassivationSuccess;
    }

    public int getExpiredSessionsRemoved() {
        return this.passivatedSessions.getNumExpiredSessionsRemoved();
    }

    public int getNumExpiredSessionsRemoved() {
        return this.passivatedSessions.getNumExpiredSessionsRemoved();
    }

    public int getNumVictimsAccessed() {
        return this.numVictimsAccessed;
    }

    private class IdleBeanPassivatorTask
    implements Servicable {
        private IdleBeanPassivatorTask() {
        }

        public void prolog() {
        }

        public void epilog() {
        }

        public void service() {
            this.run();
        }

        public void run() {
            block2: {
                try {
                    LruSessionCache.this.trimTimedoutItems(Integer.MAX_VALUE);
                }
                catch (Exception exception) {
                    if (!_logger.isLoggable(Level.WARNING)) break block2;
                    _logger.log(Level.WARNING, "[" + LruSessionCache.this.cacheName + "]: Exception while " + "removing idle beans", exception);
                }
            }
        }
    }

    private class IdleBeanCleanerTimerTask
    extends TimerTask {
        Object lock;

        IdleBeanCleanerTimerTask() {
        }

        IdleBeanCleanerTimerTask(Object object) {
            this.lock = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object;
            Object object2 = this.lock;
            synchronized (object2) {
                if (LruSessionCache.this.addedIdleBeanCleanerTimerTask) {
                    return;
                }
                LruSessionCache.this.addedIdleBeanCleanerTimerTask = true;
            }
            try {
                try {
                    IdleBeanPassivatorTask idleBeanPassivatorTask = new IdleBeanPassivatorTask();
                    ContainerWorkPool.addLast(idleBeanPassivatorTask);
                }
                catch (Exception idleBeanPassivatorTask) {
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.WARNING, LruSessionCache.this.cacheName + ":Cannot add idle bean passivation task", idleBeanPassivatorTask);
                    }
                    Object var4_5 = null;
                    Object object3 = this.lock;
                    synchronized (object3) {
                        LruSessionCache.this.addedIdleBeanCleanerTimerTask = false;
                        return;
                    }
                }
                Object var4_4 = null;
                object = this.lock;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                Object object4 = this.lock;
                synchronized (object4) {
                    LruSessionCache.this.addedIdleBeanCleanerTimerTask = false;
                    throw throwable;
                }
            }
            synchronized (object) {
                LruSessionCache.this.addedIdleBeanCleanerTimerTask = false;
                return;
            }
        }
    }
}

