/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.orbutil;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.se.internal.io.ObjectStreamClass;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;

public final class ObjectStreamClassUtil_1_3 {
    private static Comparator compareClassByName = new CompareClassByName();
    private static Comparator compareMemberByName = new CompareMemberByName();
    private static Method hasStaticInitializerMethod = null;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;
    static /* synthetic */ Class class$java$io$ObjectStreamClass;
    static /* synthetic */ Class class$java$lang$Class;

    public static long computeSerialVersionUID(Class clazz) {
        long l = ObjectStreamClass.getSerialVersionUID(clazz);
        if (l == 0L) {
            return l;
        }
        l = ObjectStreamClassUtil_1_3.getSerialVersion(l, clazz);
        return l;
    }

    private static Long getSerialVersion(final long l, final Class clazz) {
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                long l2;
                try {
                    Field field = clazz.getDeclaredField("serialVersionUID");
                    int n = field.getModifiers();
                    l2 = Modifier.isStatic(n) && Modifier.isFinal(n) && Modifier.isPrivate(n) ? l : ObjectStreamClassUtil_1_3._computeSerialVersionUID(clazz);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    l2 = ObjectStreamClassUtil_1_3._computeSerialVersionUID(clazz);
                    LogWrap.logger.log(Level.WARNING, "", noSuchFieldException);
                }
                return new Long(l2);
            }
        });
    }

    public static long computeStructuralUID(boolean bl, Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        try {
            int n;
            Object object;
            if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = ObjectStreamClassUtil_1_3.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz) || clazz.isInterface()) {
                return 0L;
            }
            if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = ObjectStreamClassUtil_1_3.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clazz)) {
                return 1L;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null && clazz2 != (class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamClassUtil_1_3.class$("java.lang.Object")) : class$java$lang$Object)) {
                boolean bl2 = false;
                Class[] classArray = new Class[]{class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = ObjectStreamClassUtil_1_3.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream};
                object = ObjectStreamClassUtil_1_3.getDeclaredMethod(clazz2, "writeObject", classArray, 2, 8);
                if (object != null) {
                    bl2 = true;
                }
                dataOutputStream.writeLong(ObjectStreamClassUtil_1_3.computeStructuralUID(bl2, clazz2));
            }
            if (bl) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(1);
            }
            Field[] fieldArray = ObjectStreamClassUtil_1_3.getDeclaredFields(clazz);
            Arrays.sort(fieldArray, compareMemberByName);
            int n2 = 0;
            while (n2 < fieldArray.length) {
                object = fieldArray[n2];
                n = ((Field)object).getModifiers();
                if (!Modifier.isTransient(n) && !Modifier.isStatic(n)) {
                    dataOutputStream.writeUTF(((Field)object).getName());
                    dataOutputStream.writeUTF(ObjectStreamClassUtil_1_3.getSignature(((Field)object).getType()));
                }
                ++n2;
            }
            dataOutputStream.flush();
            object = messageDigest.digest();
            int n3 = n = Math.min(8, ((Object)object).length);
            while (n3 > 0) {
                l += (long)(object[n3] & 0xFF) << n3 * 8;
                --n3;
            }
        }
        catch (IOException iOException) {
            l = -1L;
            LogWrap.logger.log(Level.WARNING, "", iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LogWrap.logger.log(Level.WARNING, "", noSuchAlgorithmException);
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l;
    }

    private static long _computeSerialVersionUID(Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        try {
            Object object;
            Object object2;
            int n;
            MethodSignature[] methodSignatureArray;
            int n2;
            AnnotatedElement[] annotatedElementArray;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n3 = clazz.getModifiers();
            Member[] memberArray = clazz.getDeclaredMethods();
            if (((n3 &= 0x611) & 0x200) != 0) {
                n3 &= 0xFFFFFBFF;
                if (memberArray.length > 0) {
                    n3 |= 0x400;
                }
            }
            dataOutputStream.writeInt(n3);
            if (!clazz.isArray()) {
                annotatedElementArray = clazz.getInterfaces();
                Arrays.sort(annotatedElementArray, compareClassByName);
                n2 = 0;
                while (n2 < annotatedElementArray.length) {
                    dataOutputStream.writeUTF(((Class)annotatedElementArray[n2]).getName());
                    ++n2;
                }
            }
            annotatedElementArray = clazz.getDeclaredFields();
            Arrays.sort(annotatedElementArray, compareMemberByName);
            n2 = 0;
            while (n2 < annotatedElementArray.length) {
                methodSignatureArray = annotatedElementArray[n2];
                n = methodSignatureArray.getModifiers();
                if (!Modifier.isPrivate(n) || !Modifier.isTransient(n) && !Modifier.isStatic(n)) {
                    dataOutputStream.writeUTF(methodSignatureArray.getName());
                    dataOutputStream.writeInt(n);
                    dataOutputStream.writeUTF(ObjectStreamClassUtil_1_3.getSignature(methodSignatureArray.getType()));
                }
                ++n2;
            }
            if (ObjectStreamClassUtil_1_3.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            methodSignatureArray = MethodSignature.removePrivateAndSort(clazz.getDeclaredConstructors());
            n = 0;
            while (n < methodSignatureArray.length) {
                object2 = methodSignatureArray[n];
                String string = "<init>";
                object = object2.signature;
                object = ((String)object).replace('/', '.');
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeInt(object2.member.getModifiers());
                dataOutputStream.writeUTF((String)object);
                ++n;
            }
            object2 = MethodSignature.removePrivateAndSort(memberArray);
            int n4 = 0;
            while (n4 < ((MethodSignature[])object2).length) {
                object = object2[n4];
                String string = ((MethodSignature)object).signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF(((MethodSignature)object).member.getName());
                dataOutputStream.writeInt(((MethodSignature)object).member.getModifiers());
                dataOutputStream.writeUTF(string);
                ++n4;
            }
            dataOutputStream.flush();
            object = messageDigest.digest();
            int n5 = 0;
            while (n5 < Math.min(8, ((Object)object).length)) {
                l += (long)(object[n5] & 0xFF) << n5 * 8;
                ++n5;
            }
        }
        catch (IOException iOException) {
            l = -1L;
            LogWrap.logger.log(Level.WARNING, "", iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LogWrap.logger.log(Level.WARNING, "", noSuchAlgorithmException);
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l;
    }

    private static String getSignature(Class clazz) {
        String string = null;
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz;
            int n = 0;
            while (clazz2.isArray()) {
                ++n;
                clazz2 = clazz2.getComponentType();
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append("[");
                ++n2;
            }
            stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(clazz2));
            string = stringBuffer.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                string = "I";
            } else if (clazz == Byte.TYPE) {
                string = "B";
            } else if (clazz == Long.TYPE) {
                string = "J";
            } else if (clazz == Float.TYPE) {
                string = "F";
            } else if (clazz == Double.TYPE) {
                string = "D";
            } else if (clazz == Short.TYPE) {
                string = "S";
            } else if (clazz == Character.TYPE) {
                string = "C";
            } else if (clazz == Boolean.TYPE) {
                string = "Z";
            } else if (clazz == Void.TYPE) {
                string = "V";
            }
        } else {
            string = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return string;
    }

    private static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(classArray[n]));
            ++n;
        }
        stringBuffer.append(")");
        stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    private static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class<?>[] classArray = constructor.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(classArray[n]));
            ++n;
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    private static Field[] getDeclaredFields(final Class clazz) {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredFields();
            }
        });
    }

    private static boolean hasStaticInitializer(Class clazz) {
        Class clazz2;
        if (hasStaticInitializerMethod == null) {
            clazz2 = null;
            try {
                try {
                    clazz2 = Class.forName("sun.misc.ClassReflector");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LogWrap.logger.log(Level.FINE, "", classNotFoundException);
                }
                if (clazz2 == null) {
                    clazz2 = class$java$io$ObjectStreamClass == null ? (class$java$io$ObjectStreamClass = ObjectStreamClassUtil_1_3.class$("java.io.ObjectStreamClass")) : class$java$io$ObjectStreamClass;
                }
                hasStaticInitializerMethod = clazz2.getDeclaredMethod("hasStaticInitializer", class$java$lang$Class == null ? (class$java$lang$Class = ObjectStreamClassUtil_1_3.class$("java.lang.Class")) : class$java$lang$Class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LogWrap.logger.log(Level.FINE, "", noSuchMethodException);
            }
            if (hasStaticInitializerMethod == null) {
                throw new InternalError("Can't find hasStaticInitializer method on " + clazz2.getName());
            }
            hasStaticInitializerMethod.setAccessible(true);
        }
        try {
            clazz2 = (Boolean)hasStaticInitializerMethod.invoke(null, clazz);
            return (Boolean)((Object)clazz2);
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, "", exception);
            throw new InternalError("Error invoking hasStaticInitializer: " + exception);
        }
    }

    private static Method getDeclaredMethod(final Class clazz, final String string, final Class[] classArray, final int n, final int n2) {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method = null;
                try {
                    method = clazz.getDeclaredMethod(string, classArray);
                    int n3 = method.getModifiers();
                    if ((n3 & n2) != 0 || (n3 & n) != n) {
                        method = null;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    LogWrap.logger.log(Level.FINE, "", noSuchMethodException);
                }
                return method;
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        static MethodSignature[] removePrivateAndSort(Member[] memberArray) {
            int n = 0;
            int n2 = 0;
            while (n2 < memberArray.length) {
                if (!Modifier.isPrivate(memberArray[n2].getModifiers())) {
                    ++n;
                }
                ++n2;
            }
            MethodSignature[] methodSignatureArray = new MethodSignature[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < memberArray.length) {
                if (!Modifier.isPrivate(memberArray[n4].getModifiers())) {
                    methodSignatureArray[n3] = new MethodSignature(memberArray[n4]);
                    ++n3;
                }
                ++n4;
            }
            if (n3 > 0) {
                Arrays.sort(methodSignatureArray, methodSignatureArray[0]);
            }
            return methodSignatureArray;
        }

        public int compare(Object object, Object object2) {
            int n;
            if (object == object2) {
                return 0;
            }
            MethodSignature methodSignature = (MethodSignature)object;
            MethodSignature methodSignature2 = (MethodSignature)object2;
            if (this.isConstructor()) {
                n = methodSignature.signature.compareTo(methodSignature2.signature);
            } else {
                n = methodSignature.member.getName().compareTo(methodSignature2.member.getName());
                if (n == 0) {
                    n = methodSignature.signature.compareTo(methodSignature2.signature);
                }
            }
            return n;
        }

        private final boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        private MethodSignature(Member member) {
            this.member = member;
            this.signature = this.isConstructor() ? ObjectStreamClassUtil_1_3.getSignature((Constructor)member) : ObjectStreamClassUtil_1_3.getSignature((Method)member);
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        public int compare(Object object, Object object2) {
            String string = ((Member)object).getName();
            String string2 = ((Member)object2).getName();
            if (object instanceof Method) {
                string = string + ObjectStreamClassUtil_1_3.getSignature((Method)object);
                string2 = string2 + ObjectStreamClassUtil_1_3.getSignature((Method)object2);
            } else if (object instanceof Constructor) {
                string = string + ObjectStreamClassUtil_1_3.getSignature((Constructor)object);
                string2 = string2 + ObjectStreamClassUtil_1_3.getSignature((Constructor)object2);
            }
            return string.compareTo(string2);
        }
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }
    }
}

