/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.sun.corba.ee.internal.core.CodeSetComponentInfo;
import com.sun.corba.ee.internal.core.CodeSetConversion;
import com.sun.corba.ee.internal.core.GIOPVersion;
import com.sun.corba.ee.internal.core.OSFCodeSetRegistry;
import com.sun.corba.ee.internal.iiop.CDRInputStream;
import com.sun.corba.ee.internal.iiop.Connection;
import com.sun.corba.ee.internal.iiop.ORB;
import com.sun.corba.ee.internal.iiop.messages.Message;
import com.sun.corba.ee.internal.orbutil.ORBUtility;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;

public class IIOPInputStream
extends CDRInputStream {
    protected Connection conn;
    protected Message msg = null;
    private boolean unmarshaledHeader;

    private void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public IIOPInputStream() {
    }

    private IIOPInputStream(IIOPInputStream iIOPInputStream) {
        super(iIOPInputStream);
        this.conn = iIOPInputStream.conn;
        this.msg = iIOPInputStream.msg;
        this.unmarshaledHeader = iIOPInputStream.unmarshaledHeader;
    }

    public CDRInputStream dup() {
        return new IIOPInputStream(this);
    }

    public IIOPInputStream(ORB oRB, byte[] byArray, int n, boolean bl, Message message, Connection connection) {
        super(oRB, byArray, n, bl, message.getGIOPVersion(), false);
        this.getBufferManager().init(message);
        this.unmarshaledHeader = true;
        this.msg = message;
        this.conn = connection;
    }

    public IIOPInputStream(Connection connection, byte[] byArray, Message message) throws IOException {
        super(connection.getORB(), byArray, message.getSize(), message.isLittleEndian(), message.getGIOPVersion());
        this.getBufferManager().init(message);
        this.conn = connection;
        ORB oRB = connection.getORB();
        if (oRB.transportDebugFlag) {
            this.dprint("Constructing IIOPInputStream object");
        }
        this.msg = message;
        this.unmarshaledHeader = false;
        this.setIndex(12);
        this.setBufferLength(this.msg.getSize());
        if (oRB.transportDebugFlag) {
            this.dprint("Setting the time stamp");
        }
        connection.stampTime();
    }

    public void unmarshalHeader() {
        if (!this.unmarshaledHeader) {
            this.msg.read(this);
            this.unmarshaledHeader = true;
        }
    }

    public final boolean unmarshaledHeader() {
        return this.unmarshaledHeader;
    }

    public final Connection getConnection() {
        return this.conn;
    }

    public final Message getMessage() {
        return this.msg;
    }

    protected void grow(int n, int n2) {
        throw new MARSHAL(1398079694, CompletionStatus.COMPLETED_MAYBE);
    }

    final CodeBase getCodeBase() {
        if (this.conn == null) {
            return null;
        }
        return this.conn.getCodeBase();
    }

    protected CodeSetConversion.BTCConverter createCharBTCConverter() {
        CodeSetComponentInfo.CodeSetContext codeSetContext = this.getCodeSets();
        if (codeSetContext == null) {
            return super.createCharBTCConverter();
        }
        OSFCodeSetRegistry.Entry entry = OSFCodeSetRegistry.lookupEntry(codeSetContext.getCharCodeSet());
        if (entry == null) {
            throw new MARSHAL("Unknown char set: " + entry, 1398079704, CompletionStatus.COMPLETED_NO);
        }
        return CodeSetConversion.impl().getBTCConverter(entry, this.isLittleEndian());
    }

    protected CodeSetConversion.BTCConverter createWCharBTCConverter() {
        CodeSetComponentInfo.CodeSetContext codeSetContext = this.getCodeSets();
        if (codeSetContext == null) {
            if (this.conn.isServer()) {
                throw new BAD_PARAM(1330446359, CompletionStatus.COMPLETED_MAYBE);
            }
            throw new INV_OBJREF(1330446337, CompletionStatus.COMPLETED_NO);
        }
        OSFCodeSetRegistry.Entry entry = OSFCodeSetRegistry.lookupEntry(codeSetContext.getWCharCodeSet());
        if (entry == null) {
            throw new MARSHAL("Unknown wchar set: " + entry, 1398079704, CompletionStatus.COMPLETED_NO);
        }
        if (entry == OSFCodeSetRegistry.UTF_16 && this.getGIOPVersion().equals(GIOPVersion.V1_2)) {
            return CodeSetConversion.impl().getBTCConverter(entry, false);
        }
        return CodeSetConversion.impl().getBTCConverter(entry, this.isLittleEndian());
    }

    private CodeSetComponentInfo.CodeSetContext getCodeSets() {
        if (this.conn == null) {
            return CodeSetComponentInfo.LOCAL_CODE_SETS;
        }
        return this.conn.getCodeSetContext();
    }
}

