/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Interceptors;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.omg.CORBA.INTERNAL;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;

public class InterceptorList {
    static final int INTERCEPTOR_TYPE_CLIENT = 0;
    static final int INTERCEPTOR_TYPE_SERVER = 1;
    static final int INTERCEPTOR_TYPE_IOR = 2;
    static final int NUM_INTERCEPTOR_TYPES = 3;
    static final Class[] classTypes = new Class[]{class$org$omg$PortableInterceptor$ClientRequestInterceptor == null ? (class$org$omg$PortableInterceptor$ClientRequestInterceptor = InterceptorList.class$("org.omg.PortableInterceptor.ClientRequestInterceptor")) : class$org$omg$PortableInterceptor$ClientRequestInterceptor, class$org$omg$PortableInterceptor$ServerRequestInterceptor == null ? (class$org$omg$PortableInterceptor$ServerRequestInterceptor = InterceptorList.class$("org.omg.PortableInterceptor.ServerRequestInterceptor")) : class$org$omg$PortableInterceptor$ServerRequestInterceptor, class$org$omg$PortableInterceptor$IORInterceptor == null ? (class$org$omg$PortableInterceptor$IORInterceptor = InterceptorList.class$("org.omg.PortableInterceptor.IORInterceptor")) : class$org$omg$PortableInterceptor$IORInterceptor};
    private boolean locked = false;
    private Interceptor[][] interceptors = new Interceptor[3][];
    static /* synthetic */ Class class$org$omg$PortableInterceptor$ClientRequestInterceptor;
    static /* synthetic */ Class class$org$omg$PortableInterceptor$ServerRequestInterceptor;
    static /* synthetic */ Class class$org$omg$PortableInterceptor$IORInterceptor;

    InterceptorList() {
        this.initInterceptorArrays();
    }

    void register_interceptor(Interceptor interceptor, int n) throws DuplicateName {
        if (this.locked) {
            throw new INTERNAL("InterceptorList is locked.");
        }
        String string = interceptor.name();
        boolean bl = string.equals("");
        boolean bl2 = false;
        Interceptor[] interceptorArray = this.interceptors[n];
        if (!bl) {
            int n2 = interceptorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Interceptor interceptor2 = interceptorArray[n3];
                if (interceptor2.name().equals(string)) {
                    bl2 = true;
                    break;
                }
                ++n3;
            }
        }
        if (bl2) {
            throw new DuplicateName(string);
        }
        this.growInterceptorArray(n);
        this.interceptors[n][this.interceptors[n].length - 1] = interceptor;
    }

    void lock() {
        this.locked = true;
    }

    Interceptor[] getInterceptors(int n) {
        return this.interceptors[n];
    }

    boolean hasInterceptorsOfType(int n) {
        return this.interceptors[n].length > 0;
    }

    private void initInterceptorArrays() {
        int n = 0;
        while (n < 3) {
            Class clazz = classTypes[n];
            this.interceptors[n] = (Interceptor[])Array.newInstance(clazz, 0);
            ++n;
        }
    }

    private void growInterceptorArray(int n) {
        Class clazz = classTypes[n];
        int n2 = this.interceptors[n].length;
        Interceptor[] interceptorArray = (Interceptor[])Array.newInstance(clazz, n2 + 1);
        System.arraycopy(this.interceptors[n], 0, interceptorArray, 0, n2);
        this.interceptors[n] = interceptorArray;
    }

    void destroyAll() {
        int n = this.interceptors.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.interceptors[n2].length;
            int n4 = 0;
            while (n4 < n3) {
                this.interceptors[n2][n4].destroy();
                ++n4;
            }
            ++n2;
        }
    }

    void sortInterceptors() {
        ArrayList<Object> arrayList = null;
        ArrayList<Object> arrayList2 = null;
        int n = this.interceptors.length;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            int n3 = this.interceptors[n2].length;
            if (n3 > 0) {
                arrayList = new ArrayList<Object>();
                arrayList2 = new ArrayList<Object>();
            }
            int n4 = 0;
            while (n4 < n3) {
                object = this.interceptors[n2][n4];
                if (object instanceof Comparable) {
                    arrayList.add(object);
                } else {
                    arrayList2.add(object);
                }
                ++n4;
            }
            if (n3 > 0 && arrayList.size() > 0) {
                Collections.sort(arrayList);
                object = arrayList.iterator();
                Iterator iterator = arrayList2.iterator();
                int n5 = 0;
                while (n5 < n3) {
                    if (object.hasNext()) {
                        this.interceptors[n2][n5] = (Interceptor)object.next();
                    } else if (iterator.hasNext()) {
                        this.interceptors[n2][n5] = (Interceptor)iterator.next();
                    } else {
                        throw new INTERNAL("InterceptorList.sortInterceptors");
                    }
                    ++n5;
                }
            }
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

