/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.diagnostics;

import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.diagnostics.FieldInfo;
import java.util.Vector;

class FieldInfoVector {
    Vector v = new Vector();
    private int classNameLength = 0;
    private int fieldNameLength = 0;
    private int modifiersLength = 0;

    FieldInfoVector() {
    }

    public void addElement(Object object) {
        this.v.addElement(object);
    }

    public String toString() {
        int n = this.v.size();
        StringBuffer stringBuffer = new StringBuffer();
        this.setLongestNames();
        stringBuffer.append(StringUtils.padRight((String)"Class", (int)this.classNameLength));
        stringBuffer.append(StringUtils.padRight((String)"Modifiers", (int)this.modifiersLength));
        stringBuffer.append(StringUtils.padRight((String)"Field", (int)this.fieldNameLength));
        stringBuffer.append("Value");
        stringBuffer.append("\n\n");
        int n2 = 0;
        while (n2 < n) {
            FieldInfo fieldInfo = this.fetch(n2);
            stringBuffer.append(StringUtils.padRight((String)fieldInfo.className, (int)this.classNameLength));
            stringBuffer.append(StringUtils.padRight((String)fieldInfo.modifiers, (int)this.modifiersLength));
            stringBuffer.append(StringUtils.padRight((String)fieldInfo.field.getName(), (int)this.fieldNameLength));
            stringBuffer.append(fieldInfo.value);
            stringBuffer.append('\n');
            ++n2;
        }
        return stringBuffer.toString();
    }

    private FieldInfo fetch(int n) {
        return (FieldInfo)this.v.elementAt(n);
    }

    private void setLongestNames() {
        int n = this.v.size();
        this.classNameLength = 5;
        this.fieldNameLength = 5;
        this.modifiersLength = 5;
        int n2 = 0;
        while (n2 < n) {
            FieldInfo fieldInfo = this.fetch(n2);
            int n3 = fieldInfo.className.length();
            int n4 = fieldInfo.field.getName().length();
            int n5 = fieldInfo.modifiers.length();
            if (n3 > this.classNameLength) {
                this.classNameLength = n3;
            }
            if (n4 > this.fieldNameLength) {
                this.fieldNameLength = n4;
            }
            if (n5 > this.modifiersLength) {
                this.modifiersLength = n5;
            }
            ++n2;
        }
        this.classNameLength += 2;
        this.fieldNameLength += 2;
        this.modifiersLength += 2;
    }
}

